/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.stores.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.stores.xml.XmlMetaStoreCache;

public abstract class BaseXmlMetaStoreCache
implements XmlMetaStoreCache {
    private final Map<String, Long> processedFiles = new HashMap<String, Long>();
    private final Map<String, Map<String, ElementType>> elementTypesMap = new HashMap<String, Map<String, ElementType>>();

    @Override
    public synchronized void registerElementTypeIdForName(String namespace, String elementTypeName, String elementId) {
        ElementType elementType;
        Map<String, ElementType> elementTypeNameToId = this.elementTypesMap.get(namespace);
        if (elementTypeNameToId == null) {
            elementTypeNameToId = this.createStorage();
            this.elementTypesMap.put(namespace, elementTypeNameToId);
        }
        if ((elementType = elementTypeNameToId.get(elementTypeName)) == null) {
            elementType = this.createElementType(elementId);
            elementTypeNameToId.put(elementTypeName, elementType);
        } else if (!elementType.getId().equals(elementId)) {
            elementType.unregisterElements();
            elementType.setId(elementId);
        }
    }

    @Override
    public synchronized String getElementTypeIdByName(String namespace, String elementTypeName) {
        Map<String, ElementType> elementTypeNameToId = this.elementTypesMap.get(namespace);
        if (elementTypeNameToId == null) {
            return null;
        }
        ElementType element = elementTypeNameToId.get(elementTypeName);
        return element == null ? null : element.getId();
    }

    @Override
    public synchronized void unregisterElementTypeId(String namespace, String elementTypeId) {
        Map<String, ElementType> elementTypeNameToId = this.elementTypesMap.get(namespace);
        if (elementTypeNameToId == null) {
            return;
        }
        Iterator<Map.Entry<String, ElementType>> iterator = elementTypeNameToId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ElementType> elementType = iterator.next();
            if (!elementType.getValue().getId().equals(elementTypeId)) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public synchronized void registerElementIdForName(String namespace, IMetaStoreElementType elementType, String elementName, String elementId) {
        ElementType type;
        Map<String, ElementType> nameToElementType = this.elementTypesMap.get(namespace);
        if (nameToElementType == null) {
            this.registerElementTypeIdForName(namespace, elementType.getName(), elementType.getId());
            nameToElementType = this.elementTypesMap.get(namespace);
        }
        if ((type = nameToElementType.get(elementType.getName())) == null) {
            this.registerElementTypeIdForName(namespace, elementType.getName(), elementType.getId());
            type = nameToElementType.get(elementType.getName());
        }
        type.registerElementIdForName(elementName, elementId);
    }

    @Override
    public synchronized String getElementIdByName(String namespace, IMetaStoreElementType elementType, String elementName) {
        Map<String, ElementType> elementTypeNameToId = this.elementTypesMap.get(namespace);
        if (elementTypeNameToId == null) {
            return null;
        }
        ElementType type = elementTypeNameToId.get(elementType.getName());
        return type == null ? null : type.getElementIdByName(elementName);
    }

    @Override
    public synchronized void unregisterElementId(String namespace, IMetaStoreElementType elementType, String elementId) {
        Map<String, ElementType> elementTypeNameToId = this.elementTypesMap.get(namespace);
        if (elementTypeNameToId == null) {
            return;
        }
        ElementType type = elementTypeNameToId.get(elementType.getName());
        if (type == null) {
            return;
        }
        type.unregisterElementId(elementId);
    }

    @Override
    public synchronized void registerProcessedFile(String fullPath, long lastUpdate) {
        this.processedFiles.put(fullPath, lastUpdate);
    }

    @Override
    public synchronized Map<String, Long> getProcessedFiles() {
        return Collections.unmodifiableMap(this.processedFiles);
    }

    @Override
    public synchronized void unregisterProcessedFile(String fullPath) {
        this.processedFiles.remove(fullPath);
    }

    @Override
    public synchronized void clear() {
        this.processedFiles.clear();
        for (Map<String, ElementType> namespaceElementType : this.elementTypesMap.values()) {
            for (ElementType elementType : namespaceElementType.values()) {
                elementType.unregisterElements();
            }
            namespaceElementType.clear();
        }
        this.elementTypesMap.clear();
    }

    protected abstract <K, V> Map<K, V> createStorage();

    protected abstract ElementType createElementType(String var1);

    protected static abstract class ElementType {
        private String id;

        public ElementType(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        protected abstract Map<String, String> getElementNameToIdMap();

        public void registerElementIdForName(String elementName, String elementId) {
            if (elementId == null) {
                return;
            }
            Map<String, String> elementNameToIdMap = this.getElementNameToIdMap();
            elementNameToIdMap.put(elementName, elementId);
        }

        public String getElementIdByName(String elementName) {
            Map<String, String> elementNameToIdMap = this.getElementNameToIdMap();
            return elementNameToIdMap.get(elementName);
        }

        public void unregisterElementId(String elementId) {
            Map<String, String> elementNameToIdMap = this.getElementNameToIdMap();
            Iterator<Map.Entry<String, String>> iterator = elementNameToIdMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element = iterator.next();
                if (!element.getValue().equals(elementId)) continue;
                iterator.remove();
                return;
            }
        }

        public void unregisterElements() {
            Map<String, String> elementNameToIdMap = this.getElementNameToIdMap();
            elementNameToIdMap.clear();
        }
    }
}

