/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.app;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.reactivex.Flowable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.security.UserGroupInformation;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.engine.api.Engine;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.events.LogEvent;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.events.StatusEvent;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.model.ModelElement;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.remote.Execution;
import org.pentaho.di.engine.api.remote.ExecutionException;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.spark.SystemManager;
import org.pentaho.osgi.objecttunnel.TunnelFactory;
import org.pentaho.osgi.objecttunnel.TunnelSerializer;
import org.pentaho.osgi.objecttunnel.TunneledPayload;
import org.pentaho.platform.servicecoordination.api.IServiceBarrier;

public class ExecutionListener {
    public static final String LOGGING_LEVEL = "loggingLevel";
    private final SystemManager systemManager;
    private final TunnelFactory tunnelFactory;
    private final String executionRequestID;
    public static final Map<LogLevel, org.pentaho.di.engine.api.reporting.LogLevel> LEVEL_MAP = new HashMap<LogLevel, org.pentaho.di.engine.api.reporting.LogLevel>();

    public ExecutionListener(String executionRequestID, TunnelFactory tunnelFactory) {
        this(executionRequestID, tunnelFactory, SystemManager.getInstance());
    }

    protected ExecutionListener(String executionRequestID, TunnelFactory tunnelFactory, SystemManager systemManager) {
        this.executionRequestID = executionRequestID;
        this.tunnelFactory = tunnelFactory;
        this.systemManager = systemManager;
    }

    public void removeExecution(Execution execution, Map<String, String> properties) {
    }

    public void setExecution(Execution execution, Map<String, String> properties) {
        String executionUuid = properties.get("execution.uuid");
        if (executionUuid != null && !executionUuid.equalsIgnoreCase(this.executionRequestID)) {
            return;
        }
        Optional<ExecutionRequest> request = Optional.ofNullable(execution.getRequest());
        if (!request.isPresent()) {
            return;
        }
        ExecutionRequest executionRequest = request.get();
        Engine engine = null;
        try {
            engine = (Engine)this.systemManager.loadEngine("spark").get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.fail(execution, executionRequest, e);
        }
        Objects.requireNonNull(engine);
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                this.doSetExecutionAsProxyUser(execution, executionRequest, engine);
            } else {
                this.doSetExecution(execution, executionRequest, engine);
            }
        }
        catch (Exception e) {
            this.fail(execution, executionRequest, e);
            this.releaseHold();
        }
    }

    private void doSetExecutionAsProxyUser(Execution execution, ExecutionRequest executionRequest, Engine engine) {
        try {
            String proxyUserName = executionRequest.getActingPrincipal().getName();
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            UserGroupInformation proxyUgi = UserGroupInformation.createProxyUser((String)proxyUserName, (UserGroupInformation)ugi);
            proxyUgi.doAs(() -> {
                this.doSetExecution(execution, executionRequest, engine);
                return null;
            });
        }
        catch (IOException e) {
            this.fail(execution, executionRequest, e);
        }
    }

    private void doSetExecution(Execution execution, ExecutionRequest executionRequest, Engine engine) {
        Transformation transformation = executionRequest.getTransformation();
        Map modelElementMap = ImmutableList.builder().add((Object)transformation).addAll((Iterable)transformation.getOperations()).addAll((Iterable)transformation.getHops()).build().stream().collect(Collectors.toMap(ModelElement::getId, Function.identity()));
        ExecutionContext context = engine.prepare(transformation);
        context.setParameters(executionRequest.getParameters());
        context.setEnvironment(executionRequest.getEnvironment());
        context.setLoggingLogLevel(executionRequest.getLoggingLogLevel());
        context.subscribe((LogicalModelElement)transformation, Status.class, status -> {
            if (status.isFinal()) {
                this.releaseHold();
            }
        }, throwable -> this.fail(execution, executionRequest, (Throwable)throwable), () -> {});
        Map reportingTopics = executionRequest.getReportingTopics();
        reportingTopics.keySet().stream().map(modelElementMap::get).filter(Objects::nonNull).flatMap(element -> {
            String id = element.getId();
            return ((Set)reportingTopics.get(id)).stream().map(type -> context.eventStream(element, type));
        }).map(Flowable::fromPublisher).reduce(Flowable::merge).orElseGet(Flowable::empty).subscribe(event -> execution.update(this.serialize((PDIEvent)event)), error -> this.fail(execution, executionRequest, (Throwable)error));
        CompletableFuture execute = context.execute();
        execute.handle((executionResult, throwable) -> {
            if (throwable != null) {
                this.fail(execution, executionRequest, (Throwable)throwable);
            }
            this.cleanup(execution);
            return executionResult;
        });
    }

    private void fail(Execution execution, ExecutionRequest executionRequest, Throwable throwable) {
        Transformation transformation = executionRequest.getTransformation();
        ExecutionException executionException = new ExecutionException(throwable);
        LogEntry logEntry = LogEntry.LogEntryBuilder.aLogEntry().withMessage(executionException.getMessage()).withLogLevel(org.pentaho.di.engine.api.reporting.LogLevel.ERROR).withTimestamp(new Date()).withThrowable((Throwable)executionException).build();
        LogEvent logEvent = new LogEvent((LogicalModelElement)transformation, logEntry);
        execution.update(this.serialize((PDIEvent)logEvent));
        execution.update(this.serialize((PDIEvent)new StatusEvent((LogicalModelElement)transformation, Status.FAILED)));
    }

    private void cleanup(Execution execution) {
        this.releaseHold();
    }

    private void releaseHold() {
        IServiceBarrier barrier = this.systemManager.getServiceBarrier();
        barrier.terminate();
    }

    private Serializable serialize(PDIEvent event) {
        TunnelSerializer serializer = this.tunnelFactory.getSerializer(event.getClass());
        if (serializer == null) {
            throw new IllegalStateException("No Serializer found for class: " + event.getClass());
        }
        String serialize = serializer.serialize((Object)event);
        return new TunneledPayload(event.getClass().getName(), serialize);
    }

    private Map<String, Engine> createEngineMap(List<Engine> engines) {
        return Maps.uniqueIndex(engines, e -> e.getId());
    }

    public void requestRemoved(ExecutionRequest request) {
    }

    static {
        LEVEL_MAP.put(LogLevel.BASIC, org.pentaho.di.engine.api.reporting.LogLevel.BASIC);
        LEVEL_MAP.put(LogLevel.DEBUG, org.pentaho.di.engine.api.reporting.LogLevel.DEBUG);
        LEVEL_MAP.put(LogLevel.DETAILED, org.pentaho.di.engine.api.reporting.LogLevel.DETAILED);
        LEVEL_MAP.put(LogLevel.ERROR, org.pentaho.di.engine.api.reporting.LogLevel.ERROR);
        LEVEL_MAP.put(LogLevel.MINIMAL, org.pentaho.di.engine.api.reporting.LogLevel.MINIMAL);
        LEVEL_MAP.put(LogLevel.ROWLEVEL, org.pentaho.di.engine.api.reporting.LogLevel.TRACE);
    }
}

