/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.StringBlob;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.WritableUtils;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Index;
import org.apache.openjpa.persistence.jdbc.Strategy;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Entity
@NamedQueries(value={@NamedQuery(name="UPDATE_COORD_ACTION", query="update CoordinatorActionBean w set w.actionNumber = :actionNumber, w.actionXml = :actionXml, w.consoleUrl = :consoleUrl, w.createdConf = :createdConf, w.errorCode = :errorCode, w.errorMessage = :errorMessage, w.externalStatus = :externalStatus, w.missingDependencies = :missingDependencies, w.runConf = :runConf, w.timeOut = :timeOut, w.trackerUri = :trackerUri, w.type = :type, w.createdTimestamp = :createdTime, w.externalId = :externalId, w.jobId = :jobId, w.lastModifiedTimestamp = :lastModifiedTime, w.nominalTimestamp = :nominalTime, w.slaXml = :slaXml, w.statusStr = :status where w.id = :id"), @NamedQuery(name="UPDATE_COORD_ACTION_MIN", query="update CoordinatorActionBean w set w.actionXml = :actionXml, w.missingDependencies = :missingDependencies, w.lastModifiedTimestamp = :lastModifiedTime, w.statusStr = :status where w.id = :id"), @NamedQuery(name="UPDATE_COORD_ACTION_STATUS_PENDING_TIME", query="update CoordinatorActionBean w set w.statusStr =:status, w.pending =:pending, w.lastModifiedTimestamp = :lastModifiedTime where w.id = :id"), @NamedQuery(name="UPDATE_COORD_ACTION_FOR_INPUTCHECK", query="update CoordinatorActionBean w set w.statusStr = :status, w.lastModifiedTimestamp = :lastModifiedTime, w.actionXml = :actionXml, w.missingDependencies = :missingDependencies where w.id = :id"), @NamedQuery(name="UPDATE_COORD_ACTION_FOR_PUSH_INPUTCHECK", query="update CoordinatorActionBean w set w.statusStr = :status, w.lastModifiedTimestamp = :lastModifiedTime,  w.actionXml = :actionXml, w.pushMissingDependencies = :pushMissingDependencies where w.id = :id"), @NamedQuery(name="UPDATE_COORD_ACTION_DEPENDENCIES", query="update CoordinatorActionBean w set w.missingDependencies = :missingDependencies, w.pushMissingDependencies = :pushMissingDependencies where w.id = :id"), @NamedQuery(name="UPDATE_COORD_ACTION_FOR_START", query="update CoordinatorActionBean w set w.statusStr =:status, w.lastModifiedTimestamp = :lastModifiedTime, w.runConf = :runConf, w.externalId = :externalId, w.pending = :pending, w.errorCode = :errorCode, w.errorMessage = :errorMessage  where w.id = :id"), @NamedQuery(name="UPDATE_COORD_ACTION_FOR_MODIFIED_DATE", query="update CoordinatorActionBean w set w.lastModifiedTimestamp = :lastModifiedTime where w.id = :id"), @NamedQuery(name="UPDATE_COORD_ACTION_RERUN", query="update CoordinatorActionBean w set w.actionXml =:actionXml, w.statusStr = :status, w.externalId = :externalId, w.externalStatus = :externalStatus, w.rerunTimestamp = :rerunTime, w.lastModifiedTimestamp = :lastModifiedTime, w.createdTimestamp = :createdTime, w.createdConf = :createdConf, w.runConf = :runConf, w.missingDependencies = :missingDependencies, w.pushMissingDependencies = :pushMissingDependencies, w.errorCode = :errorCode, w.errorMessage = :errorMessage where w.id = :id"), @NamedQuery(name="DELETE_COMPLETED_ACTIONS_FOR_COORDINATOR", query="delete from CoordinatorActionBean a where a.jobId = :jobId and (a.statusStr = 'SUCCEEDED' OR a.statusStr = 'FAILED' OR a.statusStr= 'KILLED')"), @NamedQuery(name="DELETE_ACTIONS_FOR_LONG_RUNNING_COORDINATOR", query="delete from CoordinatorActionBean a where a.id IN (:actionId)"), @NamedQuery(name="DELETE_UNSCHEDULED_ACTION", query="delete from CoordinatorActionBean a where a.id = :id and (a.statusStr = 'WAITING' OR a.statusStr = 'READY')"), @NamedQuery(name="GET_COORD_ACTIONS_FOR_COORDINATOR", query="select a.id from CoordinatorActionBean a where a.jobId = :jobId"), @NamedQuery(name="GET_COORD_ACTIONS", query="select OBJECT(w) from CoordinatorActionBean w"), @NamedQuery(name="GET_COORD_ACTION", query="select OBJECT(a) from CoordinatorActionBean a where a.id = :id"), @NamedQuery(name="GET_COORD_ACTION_FOR_SLA", query="select a.id, a.jobId, a.statusStr, a.externalId, a.lastModifiedTimestamp from CoordinatorActionBean a where a.id = :id"), @NamedQuery(name="GET_COORD_ACTION_FOR_INFO", query="select a.id, a.jobId, a.actionNumber, a.consoleUrl, a.errorCode, a.errorMessage, a.externalId, a.externalStatus, a.trackerUri, a.createdTimestamp, a.nominalTimestamp, a.statusStr, a.lastModifiedTimestamp, a.missingDependencies, a.pushMissingDependencies from CoordinatorActionBean a where a.id = :id"), @NamedQuery(name="GET_COORD_ACTION_FOR_TIMEOUT", query="select a.id, a.jobId, a.statusStr, a.runConf, a.pending, a.nominalTimestamp, a.createdTimestamp from CoordinatorActionBean a where a.id = :id"), @NamedQuery(name="GET_COORD_ACTION_FOR_INPUTCHECK", query="select a.id, a.actionNumber, a.jobId, a.statusStr, a.runConf, a.nominalTimestamp, a.createdTimestamp, a.actionXml, a.missingDependencies, a.pushMissingDependencies, a.timeOut, a.externalId from CoordinatorActionBean a where a.id = :id"), @NamedQuery(name="GET_COORD_ACTION_FOR_EXTERNALID", query="select a.id, a.jobId, a.statusStr, a.pending, a.externalId, a.lastModifiedTimestamp, a.slaXml, a.nominalTimestamp, a.createdTimestamp from CoordinatorActionBean a where a.externalId = :externalId"), @NamedQuery(name="GET_COORD_ACTION_FOR_CHECK", query="select a.id, a.jobId, a.statusStr, a.pending, a.externalId, a.lastModifiedTimestamp, a.slaXml, a.nominalTimestamp, a.createdTimestamp from CoordinatorActionBean a where a.id = :id"), @NamedQuery(name="GET_COORD_ACTION_FOR_START", query="select a.id, a.jobId, a.statusStr, a.pending, a.createdConf, a.slaXml, a.actionXml, a.externalId, a.errorMessage, a.errorCode, a.nominalTimestamp, a.createdTimestamp from CoordinatorActionBean a where a.id = :id"), @NamedQuery(name="GET_COORD_ACTIONS_FOR_JOB_FIFO", query="select a.id, a.actionNumber, a.jobId, a.statusStr, a.pending, a.nominalTimestamp, a.createdTimestamp from CoordinatorActionBean a where a.jobId = :jobId AND a.statusStr = 'READY' order by a.nominalTimestamp"), @NamedQuery(name="GET_COORD_ACTIONS_FOR_JOB_LIFO", query="select a.id, a.actionNumber, a.jobId, a.statusStr, a.pending, a.nominalTimestamp, a.createdTimestamp from CoordinatorActionBean a where a.jobId = :jobId AND a.statusStr = 'READY' order by a.nominalTimestamp desc"), @NamedQuery(name="GET_COORD_RUNNING_ACTIONS_COUNT", query="select count(a) from CoordinatorActionBean a where a.jobId = :jobId AND (a.statusStr = 'RUNNING' OR a.statusStr='SUBMITTED')"), @NamedQuery(name="GET_COORD_ACTIONS_COUNT_BY_JOBID", query="select count(a) from CoordinatorActionBean a where a.jobId = :jobId"), @NamedQuery(name="GET_COORD_ACTIVE_ACTIONS_COUNT_BY_JOBID", query="select count(a) from CoordinatorActionBean a where a.jobId = :jobId AND a.statusStr = 'WAITING'"), @NamedQuery(name="GET_COORD_ACTIONS_PENDING_FALSE_COUNT", query="select count(a) from CoordinatorActionBean a where a.jobId = :jobId AND a.pending = 0 AND (a.statusStr = 'SUSPENDED' OR a.statusStr = 'TIMEDOUT' OR a.statusStr = 'SUCCEEDED' OR a.statusStr = 'KILLED' OR a.statusStr = 'FAILED')"), @NamedQuery(name="GET_COORD_ACTIONS_PENDING_FALSE_STATUS_COUNT", query="select count(a) from CoordinatorActionBean a where a.jobId = :jobId AND a.pending = 0 AND a.statusStr = :status"), @NamedQuery(name="GET_ACTIONS_FOR_COORD_JOB", query="select count(a) from CoordinatorActionBean a where a.jobId = :jobId"), @NamedQuery(name="GET_ACTIONS_FOR_COORD_JOB_ORDER_BY_NOMINAL_TIME", query="select a.id, a.actionNumber, a.consoleUrl, a.errorCode, a.errorMessage, a.externalId, a.externalStatus, a.jobId, a.trackerUri, a.createdTimestamp, a.nominalTimestamp, a.statusStr, a.lastModifiedTimestamp, a.missingDependencies, a.pushMissingDependencies, a.timeOut from CoordinatorActionBean a where a.jobId = :jobId order by a.nominalTimestamp"), @NamedQuery(name="GET_ALL_COLS_FOR_ACTIONS_FOR_COORD_JOB_ORDER_BY_NOMINAL_TIME", query="select OBJECT(a) from CoordinatorActionBean a where a.jobId = :jobId order by a.nominalTimestamp"), @NamedQuery(name="GET_COORD_ACTIONS_NOT_COMPLETED", query="select a.id, a.statusStr, a.pending, a.externalId, a.pushMissingDependencies, a.nominalTimestamp, a.createdTimestamp, a.jobId from CoordinatorActionBean a where a.jobId = :jobId AND a.statusStr <> 'FAILED' AND a.statusStr <> 'TIMEDOUT' AND a.statusStr <> 'SUCCEEDED' AND a.statusStr <> 'KILLED' AND a.statusStr <> 'IGNORED'"), @NamedQuery(name="GET_COORD_ACTIONS_RUNNING", query="select a.id, a.statusStr, a.pending, a.externalId, a.nominalTimestamp, a.createdTimestamp from CoordinatorActionBean a where a.jobId = :jobId and a.statusStr = 'RUNNING'"), @NamedQuery(name="GET_COORD_ACTIONS_SUSPENDED", query="select a.id, a.statusStr, a.pending, a.externalId, a.nominalTimestamp, a.createdTimestamp from CoordinatorActionBean a where a.jobId = :jobId and a.statusStr = 'SUSPENDED'"), @NamedQuery(name="GET_COORD_ACTIONS_PENDING_COUNT", query="select count(a) from CoordinatorActionBean a where a.jobId = :jobId AND a.pending > 0"), @NamedQuery(name="GET_COORD_ACTIONS_STATUS_UNIGNORED", query="select a.statusStr, a.pending from CoordinatorActionBean a where a.jobId = :jobId AND a.statusStr <> 'IGNORED'"), @NamedQuery(name="GET_COORD_ACTION_STATUS", query="select a.statusStr from CoordinatorActionBean a where a.id = :id"), @NamedQuery(name="GET_COORD_ACTION_FOR_COORD_JOB_BY_ACTION_NUMBER", query="select a.id from CoordinatorActionBean a where a.jobId = :jobId AND a.actionNumber = :actionNumber"), @NamedQuery(name="GET_COORD_ACTIONS_BY_LAST_MODIFIED_TIME", query="select a.jobId from CoordinatorActionBean a where a.lastModifiedTimestamp >= :lastModifiedTime"), @NamedQuery(name="GET_RUNNING_ACTIONS_FOR_COORD_JOB", query="select OBJECT(a) from CoordinatorActionBean a where a.jobId = :jobId AND a.statusStr = 'RUNNING'"), @NamedQuery(name="GET_RUNNING_ACTIONS_OLDER_THAN", query="select a.id from CoordinatorActionBean a where a.statusStr = 'RUNNING' AND a.lastModifiedTimestamp <= :lastModifiedTime"), @NamedQuery(name="GET_COORD_ACTIONS_WAITING_SUBMITTED_OLDER_THAN", query="select a.id, a.jobId, a.statusStr, a.externalId, a.pushMissingDependencies from CoordinatorActionBean a where (a.statusStr = 'WAITING' OR a.statusStr = 'SUBMITTED') AND a.lastModifiedTimestamp <= :lastModifiedTime"), @NamedQuery(name="GET_COORD_ACTIONS_FOR_RECOVERY_OLDER_THAN", query="select a.id, a.jobId, a.statusStr, a.externalId, a.pending from CoordinatorActionBean a where a.pending > 0 AND (a.statusStr = 'SUSPENDED' OR a.statusStr = 'KILLED' OR a.statusStr = 'RUNNING') AND a.lastModifiedTimestamp <= :lastModifiedTime"), @NamedQuery(name="GET_ACTIONS_FOR_DATES", query="select OBJECT(a) from CoordinatorActionBean a where a.jobId = :jobId AND (a.statusStr = 'TIMEDOUT' OR a.statusStr = 'SUCCEEDED' OR a.statusStr = 'KILLED' OR a.statusStr = 'FAILED' OR a.statusStr = 'IGNORED') AND a.nominalTimestamp >= :startTime AND a.nominalTimestamp <= :endTime"), @NamedQuery(name="GET_ACTION_IDS_FOR_DATES", query="select a.id from CoordinatorActionBean a where a.jobId = :jobId AND (a.statusStr = 'TIMEDOUT' OR a.statusStr = 'SUCCEEDED' OR a.statusStr = 'KILLED' OR a.statusStr = 'FAILED') AND a.nominalTimestamp >= :startTime AND a.nominalTimestamp <= :endTime"), @NamedQuery(name="GET_ACTION_FOR_NOMINALTIME", query="select OBJECT(a) from CoordinatorActionBean a where a.jobId = :jobId AND a.nominalTimestamp = :nominalTime"), @NamedQuery(name="GET_ACTIONS_BY_DATES_FOR_KILL", query="select a.id, a.jobId, a.statusStr, a.externalId, a.pending, a.nominalTimestamp, a.createdTimestamp from CoordinatorActionBean a where a.jobId = :jobId AND (a.statusStr <> 'FAILED' AND a.statusStr <> 'KILLED' AND a.statusStr <> 'SUCCEEDED' AND a.statusStr <> 'TIMEDOUT') AND a.nominalTimestamp >= :startTime AND a.nominalTimestamp <= :endTime"), @NamedQuery(name="GET_COORD_ACTIONS_COUNT", query="select count(w) from CoordinatorActionBean w"), @NamedQuery(name="GET_COORD_ACTIONS_COUNT_RUNNING_FOR_RANGE", query="select count(w) from CoordinatorActionBean w where w.statusStr = 'RUNNING' and w.jobId= :jobId and w.id >= :startAction AND w.id <= :endAction"), @NamedQuery(name="GET_COORD_ACTIONS_MAX_MODIFIED_DATE_FOR_RANGE", query="select max(w.lastModifiedTimestamp) from CoordinatorActionBean w where w.jobId= :jobId and w.id >= :startAction AND w.id <= :endAction"), @NamedQuery(name="GET_READY_ACTIONS_GROUP_BY_JOBID", query="select a.jobId, min(a.lastModifiedTimestamp) from CoordinatorActionBean a where a.statusStr = 'READY' group by a.jobId having min(a.lastModifiedTimestamp) < :lastModifiedTime")})
@Table(name="COORD_ACTIONS")
public class CoordinatorActionBean
implements Writable,
CoordinatorAction,
JsonBean,
PersistenceCapable {
    @Id
    private String id;
    @Basic
    @Index
    @Column(name="job_id")
    private String jobId;
    @Basic
    @Index
    @Column(name="status")
    private String statusStr = CoordinatorAction.Status.WAITING.toString();
    @Basic
    @Index
    @Column(name="nominal_time")
    private Timestamp nominalTimestamp = null;
    @Basic
    @Index
    @Column(name="last_modified_time")
    private Timestamp lastModifiedTimestamp = null;
    @Basic
    @Index
    @Column(name="created_time")
    private Timestamp createdTimestamp = null;
    @Basic
    @Index
    @Column(name="rerun_time")
    private Timestamp rerunTimestamp = null;
    @Basic
    @Index
    @Column(name="external_id")
    private String externalId;
    @Basic
    @Column(name="sla_xml")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob slaXml = null;
    @Basic
    @Column(name="pending")
    private int pending = 0;
    @Basic
    @Column(name="job_type")
    private String type;
    @Basic
    @Column(name="action_number")
    private int actionNumber;
    @Basic
    @Column(name="created_conf")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob createdConf;
    @Basic
    @Column(name="time_out")
    private int timeOut = 0;
    @Basic
    @Column(name="run_conf")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob runConf;
    @Basic
    @Column(name="action_xml")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob actionXml;
    @Basic
    @Column(name="missing_dependencies")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob missingDependencies;
    @Basic
    @Column(name="push_missing_dependencies")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob pushMissingDependencies;
    @Basic
    @Column(name="external_status")
    private String externalStatus;
    @Basic
    @Column(name="tracker_uri")
    private String trackerUri;
    @Basic
    @Column(name="console_url")
    private String consoleUrl;
    @Basic
    @Column(name="error_code")
    private String errorCode;
    @Basic
    @Column(name="error_message")
    private String errorMessage;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Lorg$apache$oozie$StringBlob;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Lorg$apache$oozie$CoordinatorActionBean;
    private transient Object pcDetachedState;

    @Override
    public JSONObject toJSONObject() {
        return this.toJSONObject("GMT");
    }

    public void write(DataOutput dataOutput) throws IOException {
        WritableUtils.writeStr(dataOutput, this.getJobId());
        WritableUtils.writeStr(dataOutput, this.getType());
        WritableUtils.writeStr(dataOutput, this.getId());
        WritableUtils.writeStr(dataOutput, this.getCreatedConf());
        WritableUtils.writeStr(dataOutput, this.getStatus().toString());
        dataOutput.writeInt(this.getActionNumber());
        WritableUtils.writeStr(dataOutput, this.getRunConf());
        WritableUtils.writeStr(dataOutput, this.getExternalStatus());
        WritableUtils.writeStr(dataOutput, this.getTrackerUri());
        WritableUtils.writeStr(dataOutput, this.getConsoleUrl());
        WritableUtils.writeStr(dataOutput, this.getErrorCode());
        WritableUtils.writeStr(dataOutput, this.getErrorMessage());
        dataOutput.writeLong(this.getCreatedTime() != null ? this.getCreatedTime().getTime() : -1L);
        dataOutput.writeLong(this.getLastModifiedTime() != null ? this.getLastModifiedTime().getTime() : -1L);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.setJobId(WritableUtils.readStr(dataInput));
        this.setType(WritableUtils.readStr(dataInput));
        this.setId(WritableUtils.readStr(dataInput));
        this.setCreatedConf(WritableUtils.readStr(dataInput));
        this.setStatus(CoordinatorAction.Status.valueOf((String)WritableUtils.readStr(dataInput)));
        this.setActionNumber(dataInput.readInt());
        this.setRunConf(WritableUtils.readStr(dataInput));
        this.setExternalStatus(WritableUtils.readStr(dataInput));
        this.setTrackerUri(WritableUtils.readStr(dataInput));
        this.setConsoleUrl(WritableUtils.readStr(dataInput));
        this.setErrorCode(WritableUtils.readStr(dataInput));
        this.setErrorMessage(WritableUtils.readStr(dataInput));
        long d = dataInput.readLong();
        if (d != -1L) {
            this.setCreatedTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setLastModifiedTime(new Date(d));
        }
    }

    public String getJobId() {
        return CoordinatorActionBean.pcGetjobId(this);
    }

    public void setJobId(String id) {
        CoordinatorActionBean.pcSetjobId(this, id);
    }

    public CoordinatorAction.Status getStatus() {
        return CoordinatorAction.Status.valueOf((String)CoordinatorActionBean.pcGetstatusStr(this));
    }

    public String getStatusStr() {
        return CoordinatorActionBean.pcGetstatusStr(this);
    }

    public void setStatus(CoordinatorAction.Status status) {
        CoordinatorActionBean.pcSetstatusStr(this, status.toString());
    }

    public void setStatusStr(String statusStr) {
        CoordinatorActionBean.pcSetstatusStr(this, statusStr);
    }

    public void setCreatedTime(Date createdTime) {
        CoordinatorActionBean.pcSetcreatedTimestamp(this, DateUtils.convertDateToTimestamp(createdTime));
    }

    public void setRerunTime(Date rerunTime) {
        CoordinatorActionBean.pcSetrerunTimestamp(this, DateUtils.convertDateToTimestamp(rerunTime));
    }

    public void setNominalTime(Date nominalTime) {
        CoordinatorActionBean.pcSetnominalTimestamp(this, DateUtils.convertDateToTimestamp(nominalTime));
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        CoordinatorActionBean.pcSetlastModifiedTimestamp(this, DateUtils.convertDateToTimestamp(lastModifiedTime));
    }

    public Date getCreatedTime() {
        return DateUtils.toDate(CoordinatorActionBean.pcGetcreatedTimestamp(this));
    }

    public Timestamp getCreatedTimestamp() {
        return CoordinatorActionBean.pcGetcreatedTimestamp(this);
    }

    public Date getRerunTime() {
        return DateUtils.toDate(CoordinatorActionBean.pcGetrerunTimestamp(this));
    }

    public Timestamp getRerunTimestamp() {
        return CoordinatorActionBean.pcGetrerunTimestamp(this);
    }

    public Date getLastModifiedTime() {
        return DateUtils.toDate(CoordinatorActionBean.pcGetlastModifiedTimestamp(this));
    }

    public Timestamp getLastModifiedTimestamp() {
        return CoordinatorActionBean.pcGetlastModifiedTimestamp(this);
    }

    public Date getNominalTime() {
        return DateUtils.toDate(CoordinatorActionBean.pcGetnominalTimestamp(this));
    }

    public Timestamp getNominalTimestamp() {
        return CoordinatorActionBean.pcGetnominalTimestamp(this);
    }

    public String getExternalId() {
        return CoordinatorActionBean.pcGetexternalId(this);
    }

    public void setExternalId(String externalId) {
        CoordinatorActionBean.pcSetexternalId(this, externalId);
    }

    public StringBlob getSlaXmlBlob() {
        return CoordinatorActionBean.pcGetslaXml(this);
    }

    public void setSlaXmlBlob(StringBlob slaXml) {
        CoordinatorActionBean.pcSetslaXml(this, slaXml);
    }

    public String getSlaXml() {
        return CoordinatorActionBean.pcGetslaXml(this) == null ? null : CoordinatorActionBean.pcGetslaXml(this).getString();
    }

    public void setSlaXml(String slaXml) {
        if (CoordinatorActionBean.pcGetslaXml(this) == null) {
            CoordinatorActionBean.pcSetslaXml(this, new StringBlob(slaXml));
        } else {
            CoordinatorActionBean.pcGetslaXml(this).setString(slaXml);
        }
    }

    public boolean isTerminalStatus() {
        boolean isTerminal = true;
        switch (this.getStatus()) {
            case WAITING: 
            case READY: 
            case SUBMITTED: 
            case RUNNING: 
            case SUSPENDED: {
                isTerminal = false;
                break;
            }
            default: {
                isTerminal = true;
            }
        }
        return isTerminal;
    }

    public boolean isTerminalWithFailure() {
        boolean result = false;
        switch (this.getStatus()) {
            case FAILED: 
            case KILLED: 
            case TIMEDOUT: {
                result = true;
            }
        }
        return result;
    }

    public void setPending(int pending) {
        CoordinatorActionBean.pcSetpending(this, pending);
    }

    public int incrementAndGetPending() {
        CoordinatorActionBean coordinatorActionBean = this;
        CoordinatorActionBean.pcSetpending(coordinatorActionBean, CoordinatorActionBean.pcGetpending(coordinatorActionBean) + 1);
        return CoordinatorActionBean.pcGetpending(this);
    }

    public int decrementAndGetPending() {
        CoordinatorActionBean.pcSetpending(this, Math.max(CoordinatorActionBean.pcGetpending(this) - 1, 0));
        return CoordinatorActionBean.pcGetpending(this);
    }

    public int getPending() {
        return CoordinatorActionBean.pcGetpending(this);
    }

    public boolean isPending() {
        return CoordinatorActionBean.pcGetpending(this) > 0;
    }

    public String getId() {
        return CoordinatorActionBean.pcGetid(this);
    }

    public void setId(String id) {
        CoordinatorActionBean.pcSetid(this, id);
    }

    public String getType() {
        return CoordinatorActionBean.pcGettype(this);
    }

    public void setType(String type) {
        CoordinatorActionBean.pcSettype(this, type);
    }

    public void setActionNumber(int actionNumber) {
        CoordinatorActionBean.pcSetactionNumber(this, actionNumber);
    }

    public int getActionNumber() {
        return CoordinatorActionBean.pcGetactionNumber(this);
    }

    public String getCreatedConf() {
        return CoordinatorActionBean.pcGetcreatedConf(this) == null ? null : CoordinatorActionBean.pcGetcreatedConf(this).getString();
    }

    public void setCreatedConf(String createdConf) {
        if (CoordinatorActionBean.pcGetcreatedConf(this) == null) {
            CoordinatorActionBean.pcSetcreatedConf(this, new StringBlob(createdConf));
        } else {
            CoordinatorActionBean.pcGetcreatedConf(this).setString(createdConf);
        }
    }

    public void setCreatedConfBlob(StringBlob createdConf) {
        CoordinatorActionBean.pcSetcreatedConf(this, createdConf);
    }

    public StringBlob getCreatedConfBlob() {
        return CoordinatorActionBean.pcGetcreatedConf(this);
    }

    public void setRunConf(String runConf) {
        if (CoordinatorActionBean.pcGetrunConf(this) == null) {
            CoordinatorActionBean.pcSetrunConf(this, new StringBlob(runConf));
        } else {
            CoordinatorActionBean.pcGetrunConf(this).setString(runConf);
        }
    }

    public String getRunConf() {
        return CoordinatorActionBean.pcGetrunConf(this) == null ? null : CoordinatorActionBean.pcGetrunConf(this).getString();
    }

    public void setRunConfBlob(StringBlob runConf) {
        CoordinatorActionBean.pcSetrunConf(this, runConf);
    }

    public StringBlob getRunConfBlob() {
        return CoordinatorActionBean.pcGetrunConf(this);
    }

    public void setMissingDependencies(String missingDependencies) {
        if (CoordinatorActionBean.pcGetmissingDependencies(this) == null) {
            CoordinatorActionBean.pcSetmissingDependencies(this, new StringBlob(missingDependencies));
        } else {
            CoordinatorActionBean.pcGetmissingDependencies(this).setString(missingDependencies);
        }
    }

    public String getMissingDependencies() {
        return CoordinatorActionBean.pcGetmissingDependencies(this) == null ? null : CoordinatorActionBean.pcGetmissingDependencies(this).getString();
    }

    public void setMissingDependenciesBlob(StringBlob missingDependencies) {
        CoordinatorActionBean.pcSetmissingDependencies(this, missingDependencies);
    }

    public StringBlob getMissingDependenciesBlob() {
        return CoordinatorActionBean.pcGetmissingDependencies(this);
    }

    public String getPushMissingDependencies() {
        return CoordinatorActionBean.pcGetpushMissingDependencies(this) == null ? null : CoordinatorActionBean.pcGetpushMissingDependencies(this).getString();
    }

    public void setPushMissingDependencies(String pushMissingDependencies) {
        if (CoordinatorActionBean.pcGetpushMissingDependencies(this) == null) {
            CoordinatorActionBean.pcSetpushMissingDependencies(this, new StringBlob(pushMissingDependencies));
        } else {
            CoordinatorActionBean.pcGetpushMissingDependencies(this).setString(pushMissingDependencies);
        }
    }

    public void setPushMissingDependenciesBlob(StringBlob pushMissingDependencies) {
        CoordinatorActionBean.pcSetpushMissingDependencies(this, pushMissingDependencies);
    }

    public StringBlob getPushMissingDependenciesBlob() {
        return CoordinatorActionBean.pcGetpushMissingDependencies(this);
    }

    public String getExternalStatus() {
        return CoordinatorActionBean.pcGetexternalStatus(this);
    }

    public void setExternalStatus(String externalStatus) {
        CoordinatorActionBean.pcSetexternalStatus(this, externalStatus);
    }

    public String getTrackerUri() {
        return CoordinatorActionBean.pcGettrackerUri(this);
    }

    public void setTrackerUri(String trackerUri) {
        CoordinatorActionBean.pcSettrackerUri(this, trackerUri);
    }

    public String getConsoleUrl() {
        return CoordinatorActionBean.pcGetconsoleUrl(this);
    }

    public void setConsoleUrl(String consoleUrl) {
        CoordinatorActionBean.pcSetconsoleUrl(this, consoleUrl);
    }

    public String getErrorCode() {
        return CoordinatorActionBean.pcGeterrorCode(this);
    }

    public String getErrorMessage() {
        return CoordinatorActionBean.pcGeterrorMessage(this);
    }

    public void setErrorInfo(String errorCode, String errorMessage) {
        CoordinatorActionBean.pcSeterrorCode(this, errorCode);
        CoordinatorActionBean.pcSeterrorMessage(this, errorMessage);
    }

    public String getActionXml() {
        return CoordinatorActionBean.pcGetactionXml(this) == null ? null : CoordinatorActionBean.pcGetactionXml(this).getString();
    }

    public void setActionXml(String actionXml) {
        if (CoordinatorActionBean.pcGetactionXml(this) == null) {
            CoordinatorActionBean.pcSetactionXml(this, new StringBlob(actionXml));
        } else {
            CoordinatorActionBean.pcGetactionXml(this).setString(actionXml);
        }
    }

    public void setActionXmlBlob(StringBlob actionXml) {
        CoordinatorActionBean.pcSetactionXml(this, actionXml);
    }

    public StringBlob getActionXmlBlob() {
        return CoordinatorActionBean.pcGetactionXml(this);
    }

    public String toString() {
        return MessageFormat.format("CoordinatorAction name[{0}] status[{1}]", this.getId(), this.getStatus());
    }

    public int getTimeOut() {
        return CoordinatorActionBean.pcGettimeOut(this);
    }

    public void setTimeOut(int timeOut) {
        CoordinatorActionBean.pcSettimeOut(this, timeOut);
    }

    public void setErrorCode(String errorCode) {
        CoordinatorActionBean.pcSeterrorCode(this, errorCode);
    }

    public void setErrorMessage(String errorMessage) {
        CoordinatorActionBean.pcSeterrorMessage(this, errorMessage);
    }

    @Override
    public JSONObject toJSONObject(String timeZoneId) {
        JSONObject json = new JSONObject();
        json.put((Object)"id", (Object)CoordinatorActionBean.pcGetid(this));
        json.put((Object)"coordJobId", (Object)CoordinatorActionBean.pcGetjobId(this));
        json.put((Object)"type", (Object)CoordinatorActionBean.pcGettype(this));
        json.put((Object)"actionNumber", (Object)CoordinatorActionBean.pcGetactionNumber(this));
        json.put((Object)"createdConf", (Object)this.getCreatedConf());
        json.put((Object)"createdTime", (Object)JsonUtils.formatDateRfc822((Date)this.getCreatedTime(), (String)timeZoneId));
        json.put((Object)"nominalTime", (Object)JsonUtils.formatDateRfc822((Date)this.getNominalTime(), (String)timeZoneId));
        json.put((Object)"externalId", (Object)CoordinatorActionBean.pcGetexternalId(this));
        json.put((Object)"status", (Object)CoordinatorActionBean.pcGetstatusStr(this));
        json.put((Object)"runConf", (Object)this.getRunConf());
        json.put((Object)"lastModifiedTime", (Object)JsonUtils.formatDateRfc822((Date)this.getLastModifiedTime(), (String)timeZoneId));
        json.put((Object)"missingDependencies", (Object)this.getMissingDependencies());
        json.put((Object)"pushMissingDependencies", (Object)this.getPushMissingDependencies());
        json.put((Object)"externalStatus", (Object)CoordinatorActionBean.pcGetexternalStatus(this));
        json.put((Object)"trackerUri", (Object)CoordinatorActionBean.pcGettrackerUri(this));
        json.put((Object)"consoleUrl", (Object)CoordinatorActionBean.pcGetconsoleUrl(this));
        json.put((Object)"errorCode", (Object)CoordinatorActionBean.pcGeterrorCode(this));
        json.put((Object)"errorMessage", (Object)CoordinatorActionBean.pcGeterrorMessage(this));
        json.put((Object)"toString", (Object)this.toString());
        return json;
    }

    public static JSONArray toJSONArray(List<CoordinatorActionBean> actions, String timeZoneId) {
        JSONArray array = new JSONArray();
        for (CoordinatorActionBean action : actions) {
            array.add((Object)action.toJSONObject(timeZoneId));
        }
        return array;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (CoordinatorActionBean.pcGetid(this) == null ? 0 : CoordinatorActionBean.pcGetid(this).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoordinatorActionBean other = (CoordinatorActionBean)obj;
        return !(CoordinatorActionBean.pcGetid(this) == null ? CoordinatorActionBean.pcGetid(other) != null : !CoordinatorActionBean.pcGetid(this).equals(CoordinatorActionBean.pcGetid(other)));
    }

    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        pcFieldNames = new String[]{"actionNumber", "actionXml", "consoleUrl", "createdConf", "createdTimestamp", "errorCode", "errorMessage", "externalId", "externalStatus", "id", "jobId", "lastModifiedTimestamp", "missingDependencies", "nominalTimestamp", "pending", "pushMissingDependencies", "rerunTimestamp", "runConf", "slaXml", "statusStr", "timeOut", "trackerUri", "type"};
        Class[] classArray = new Class[23];
        classArray[0] = Integer.TYPE;
        Class clazz = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = CoordinatorActionBean.class$("org.apache.oozie.StringBlob"));
        classArray[1] = clazz;
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorActionBean.class$("java.lang.String"));
        classArray[2] = clazz2;
        classArray[3] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = CoordinatorActionBean.class$("org.apache.oozie.StringBlob"));
        Class clazz3 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorActionBean.class$("java.sql.Timestamp"));
        classArray[4] = clazz3;
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorActionBean.class$("java.lang.String"));
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorActionBean.class$("java.lang.String"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorActionBean.class$("java.lang.String"));
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorActionBean.class$("java.lang.String"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorActionBean.class$("java.lang.String"));
        classArray[10] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorActionBean.class$("java.lang.String"));
        classArray[11] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorActionBean.class$("java.sql.Timestamp"));
        classArray[12] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = CoordinatorActionBean.class$("org.apache.oozie.StringBlob"));
        classArray[13] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorActionBean.class$("java.sql.Timestamp"));
        classArray[14] = Integer.TYPE;
        classArray[15] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = CoordinatorActionBean.class$("org.apache.oozie.StringBlob"));
        classArray[16] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorActionBean.class$("java.sql.Timestamp"));
        classArray[17] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = CoordinatorActionBean.class$("org.apache.oozie.StringBlob"));
        classArray[18] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = CoordinatorActionBean.class$("org.apache.oozie.StringBlob"));
        classArray[19] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorActionBean.class$("java.lang.String"));
        classArray[20] = Integer.TYPE;
        classArray[21] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorActionBean.class$("java.lang.String"));
        classArray[22] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorActionBean.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 10, 26, 10, 26, 26, 26, 26, 26, 26, 26, 26, 10, 26, 26, 10, 26, 10, 10, 26, 26, 26, 26};
        Class clazz4 = class$Lorg$apache$oozie$CoordinatorActionBean != null ? class$Lorg$apache$oozie$CoordinatorActionBean : (class$Lorg$apache$oozie$CoordinatorActionBean = CoordinatorActionBean.class$("org.apache.oozie.CoordinatorActionBean"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"CoordinatorActionBean", (PersistenceCapable)new CoordinatorActionBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.actionNumber = 0;
        this.actionXml = null;
        this.consoleUrl = null;
        this.createdConf = null;
        this.createdTimestamp = null;
        this.errorCode = null;
        this.errorMessage = null;
        this.externalId = null;
        this.externalStatus = null;
        this.id = null;
        this.jobId = null;
        this.lastModifiedTimestamp = null;
        this.missingDependencies = null;
        this.nominalTimestamp = null;
        this.pending = 0;
        this.pushMissingDependencies = null;
        this.rerunTimestamp = null;
        this.runConf = null;
        this.slaXml = null;
        this.statusStr = null;
        this.timeOut = 0;
        this.trackerUri = null;
        this.type = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        CoordinatorActionBean coordinatorActionBean = new CoordinatorActionBean();
        if (bl) {
            coordinatorActionBean.pcClearFields();
        }
        coordinatorActionBean.pcStateManager = stateManager;
        coordinatorActionBean.pcCopyKeyFieldsFromObjectId(object);
        return coordinatorActionBean;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        CoordinatorActionBean coordinatorActionBean = new CoordinatorActionBean();
        if (bl) {
            coordinatorActionBean.pcClearFields();
        }
        coordinatorActionBean.pcStateManager = stateManager;
        return coordinatorActionBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 23;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.actionNumber = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.actionXml = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.consoleUrl = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.createdConf = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.createdTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.errorCode = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.errorMessage = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.externalStatus = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.id = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.jobId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.lastModifiedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.missingDependencies = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.nominalTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.pending = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.pushMissingDependencies = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.rerunTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.runConf = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.slaXml = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.statusStr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this.timeOut = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 21: {
                this.trackerUri = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 22: {
                this.type = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.actionNumber);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.actionXml);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.consoleUrl);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createdConf);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createdTimestamp);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.errorCode);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.errorMessage);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalStatus);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 10: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.jobId);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastModifiedTimestamp);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.missingDependencies);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.nominalTimestamp);
                return;
            }
            case 14: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.pending);
                return;
            }
            case 15: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pushMissingDependencies);
                return;
            }
            case 16: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.rerunTimestamp);
                return;
            }
            case 17: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.runConf);
                return;
            }
            case 18: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.slaXml);
                return;
            }
            case 19: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.statusStr);
                return;
            }
            case 20: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.timeOut);
                return;
            }
            case 21: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.trackerUri);
                return;
            }
            case 22: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.type);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(CoordinatorActionBean coordinatorActionBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.actionNumber = coordinatorActionBean.actionNumber;
                return;
            }
            case 1: {
                this.actionXml = coordinatorActionBean.actionXml;
                return;
            }
            case 2: {
                this.consoleUrl = coordinatorActionBean.consoleUrl;
                return;
            }
            case 3: {
                this.createdConf = coordinatorActionBean.createdConf;
                return;
            }
            case 4: {
                this.createdTimestamp = coordinatorActionBean.createdTimestamp;
                return;
            }
            case 5: {
                this.errorCode = coordinatorActionBean.errorCode;
                return;
            }
            case 6: {
                this.errorMessage = coordinatorActionBean.errorMessage;
                return;
            }
            case 7: {
                this.externalId = coordinatorActionBean.externalId;
                return;
            }
            case 8: {
                this.externalStatus = coordinatorActionBean.externalStatus;
                return;
            }
            case 9: {
                this.id = coordinatorActionBean.id;
                return;
            }
            case 10: {
                this.jobId = coordinatorActionBean.jobId;
                return;
            }
            case 11: {
                this.lastModifiedTimestamp = coordinatorActionBean.lastModifiedTimestamp;
                return;
            }
            case 12: {
                this.missingDependencies = coordinatorActionBean.missingDependencies;
                return;
            }
            case 13: {
                this.nominalTimestamp = coordinatorActionBean.nominalTimestamp;
                return;
            }
            case 14: {
                this.pending = coordinatorActionBean.pending;
                return;
            }
            case 15: {
                this.pushMissingDependencies = coordinatorActionBean.pushMissingDependencies;
                return;
            }
            case 16: {
                this.rerunTimestamp = coordinatorActionBean.rerunTimestamp;
                return;
            }
            case 17: {
                this.runConf = coordinatorActionBean.runConf;
                return;
            }
            case 18: {
                this.slaXml = coordinatorActionBean.slaXml;
                return;
            }
            case 19: {
                this.statusStr = coordinatorActionBean.statusStr;
                return;
            }
            case 20: {
                this.timeOut = coordinatorActionBean.timeOut;
                return;
            }
            case 21: {
                this.trackerUri = coordinatorActionBean.trackerUri;
                return;
            }
            case 22: {
                this.type = coordinatorActionBean.type;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        CoordinatorActionBean coordinatorActionBean = (CoordinatorActionBean)object;
        if (coordinatorActionBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(coordinatorActionBean, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(9 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.id = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$oozie$CoordinatorActionBean != null ? class$Lorg$apache$oozie$CoordinatorActionBean : (class$Lorg$apache$oozie$CoordinatorActionBean = CoordinatorActionBean.class$("org.apache.oozie.CoordinatorActionBean"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$oozie$CoordinatorActionBean != null ? class$Lorg$apache$oozie$CoordinatorActionBean : (class$Lorg$apache$oozie$CoordinatorActionBean = CoordinatorActionBean.class$("org.apache.oozie.CoordinatorActionBean"));
        return new StringId(clazz, this.id);
    }

    private static final int pcGetactionNumber(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.actionNumber;
        }
        int n = pcInheritedFieldCount + 0;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.actionNumber;
    }

    private static final void pcSetactionNumber(CoordinatorActionBean coordinatorActionBean, int n) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.actionNumber = n;
            return;
        }
        coordinatorActionBean.pcStateManager.settingIntField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 0, coordinatorActionBean.actionNumber, n, 0);
    }

    private static final StringBlob pcGetactionXml(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.actionXml;
        }
        int n = pcInheritedFieldCount + 1;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.actionXml;
    }

    private static final void pcSetactionXml(CoordinatorActionBean coordinatorActionBean, StringBlob stringBlob) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.actionXml = stringBlob;
            return;
        }
        coordinatorActionBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 1, (Object)coordinatorActionBean.actionXml, (Object)stringBlob, 0);
    }

    private static final String pcGetconsoleUrl(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.consoleUrl;
        }
        int n = pcInheritedFieldCount + 2;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.consoleUrl;
    }

    private static final void pcSetconsoleUrl(CoordinatorActionBean coordinatorActionBean, String string) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.consoleUrl = string;
            return;
        }
        coordinatorActionBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 2, coordinatorActionBean.consoleUrl, string, 0);
    }

    private static final StringBlob pcGetcreatedConf(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.createdConf;
        }
        int n = pcInheritedFieldCount + 3;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.createdConf;
    }

    private static final void pcSetcreatedConf(CoordinatorActionBean coordinatorActionBean, StringBlob stringBlob) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.createdConf = stringBlob;
            return;
        }
        coordinatorActionBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 3, (Object)coordinatorActionBean.createdConf, (Object)stringBlob, 0);
    }

    private static final Timestamp pcGetcreatedTimestamp(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.createdTimestamp;
        }
        int n = pcInheritedFieldCount + 4;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.createdTimestamp;
    }

    private static final void pcSetcreatedTimestamp(CoordinatorActionBean coordinatorActionBean, Timestamp timestamp) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.createdTimestamp = timestamp;
            return;
        }
        coordinatorActionBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 4, (Object)coordinatorActionBean.createdTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGeterrorCode(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.errorCode;
        }
        int n = pcInheritedFieldCount + 5;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.errorCode;
    }

    private static final void pcSeterrorCode(CoordinatorActionBean coordinatorActionBean, String string) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.errorCode = string;
            return;
        }
        coordinatorActionBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 5, coordinatorActionBean.errorCode, string, 0);
    }

    private static final String pcGeterrorMessage(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.errorMessage;
        }
        int n = pcInheritedFieldCount + 6;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.errorMessage;
    }

    private static final void pcSeterrorMessage(CoordinatorActionBean coordinatorActionBean, String string) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.errorMessage = string;
            return;
        }
        coordinatorActionBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 6, coordinatorActionBean.errorMessage, string, 0);
    }

    private static final String pcGetexternalId(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.externalId;
        }
        int n = pcInheritedFieldCount + 7;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.externalId;
    }

    private static final void pcSetexternalId(CoordinatorActionBean coordinatorActionBean, String string) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.externalId = string;
            return;
        }
        coordinatorActionBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 7, coordinatorActionBean.externalId, string, 0);
    }

    private static final String pcGetexternalStatus(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.externalStatus;
        }
        int n = pcInheritedFieldCount + 8;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.externalStatus;
    }

    private static final void pcSetexternalStatus(CoordinatorActionBean coordinatorActionBean, String string) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.externalStatus = string;
            return;
        }
        coordinatorActionBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 8, coordinatorActionBean.externalStatus, string, 0);
    }

    private static final String pcGetid(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.id;
        }
        int n = pcInheritedFieldCount + 9;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.id;
    }

    private static final void pcSetid(CoordinatorActionBean coordinatorActionBean, String string) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.id = string;
            return;
        }
        coordinatorActionBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 9, coordinatorActionBean.id, string, 0);
    }

    private static final String pcGetjobId(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.jobId;
        }
        int n = pcInheritedFieldCount + 10;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.jobId;
    }

    private static final void pcSetjobId(CoordinatorActionBean coordinatorActionBean, String string) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.jobId = string;
            return;
        }
        coordinatorActionBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 10, coordinatorActionBean.jobId, string, 0);
    }

    private static final Timestamp pcGetlastModifiedTimestamp(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.lastModifiedTimestamp;
        }
        int n = pcInheritedFieldCount + 11;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.lastModifiedTimestamp;
    }

    private static final void pcSetlastModifiedTimestamp(CoordinatorActionBean coordinatorActionBean, Timestamp timestamp) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.lastModifiedTimestamp = timestamp;
            return;
        }
        coordinatorActionBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 11, (Object)coordinatorActionBean.lastModifiedTimestamp, (Object)timestamp, 0);
    }

    private static final StringBlob pcGetmissingDependencies(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.missingDependencies;
        }
        int n = pcInheritedFieldCount + 12;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.missingDependencies;
    }

    private static final void pcSetmissingDependencies(CoordinatorActionBean coordinatorActionBean, StringBlob stringBlob) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.missingDependencies = stringBlob;
            return;
        }
        coordinatorActionBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 12, (Object)coordinatorActionBean.missingDependencies, (Object)stringBlob, 0);
    }

    private static final Timestamp pcGetnominalTimestamp(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.nominalTimestamp;
        }
        int n = pcInheritedFieldCount + 13;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.nominalTimestamp;
    }

    private static final void pcSetnominalTimestamp(CoordinatorActionBean coordinatorActionBean, Timestamp timestamp) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.nominalTimestamp = timestamp;
            return;
        }
        coordinatorActionBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 13, (Object)coordinatorActionBean.nominalTimestamp, (Object)timestamp, 0);
    }

    private static final int pcGetpending(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.pending;
        }
        int n = pcInheritedFieldCount + 14;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.pending;
    }

    private static final void pcSetpending(CoordinatorActionBean coordinatorActionBean, int n) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.pending = n;
            return;
        }
        coordinatorActionBean.pcStateManager.settingIntField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 14, coordinatorActionBean.pending, n, 0);
    }

    private static final StringBlob pcGetpushMissingDependencies(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.pushMissingDependencies;
        }
        int n = pcInheritedFieldCount + 15;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.pushMissingDependencies;
    }

    private static final void pcSetpushMissingDependencies(CoordinatorActionBean coordinatorActionBean, StringBlob stringBlob) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.pushMissingDependencies = stringBlob;
            return;
        }
        coordinatorActionBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 15, (Object)coordinatorActionBean.pushMissingDependencies, (Object)stringBlob, 0);
    }

    private static final Timestamp pcGetrerunTimestamp(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.rerunTimestamp;
        }
        int n = pcInheritedFieldCount + 16;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.rerunTimestamp;
    }

    private static final void pcSetrerunTimestamp(CoordinatorActionBean coordinatorActionBean, Timestamp timestamp) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.rerunTimestamp = timestamp;
            return;
        }
        coordinatorActionBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 16, (Object)coordinatorActionBean.rerunTimestamp, (Object)timestamp, 0);
    }

    private static final StringBlob pcGetrunConf(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.runConf;
        }
        int n = pcInheritedFieldCount + 17;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.runConf;
    }

    private static final void pcSetrunConf(CoordinatorActionBean coordinatorActionBean, StringBlob stringBlob) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.runConf = stringBlob;
            return;
        }
        coordinatorActionBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 17, (Object)coordinatorActionBean.runConf, (Object)stringBlob, 0);
    }

    private static final StringBlob pcGetslaXml(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.slaXml;
        }
        int n = pcInheritedFieldCount + 18;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.slaXml;
    }

    private static final void pcSetslaXml(CoordinatorActionBean coordinatorActionBean, StringBlob stringBlob) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.slaXml = stringBlob;
            return;
        }
        coordinatorActionBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 18, (Object)coordinatorActionBean.slaXml, (Object)stringBlob, 0);
    }

    private static final String pcGetstatusStr(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.statusStr;
        }
        int n = pcInheritedFieldCount + 19;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.statusStr;
    }

    private static final void pcSetstatusStr(CoordinatorActionBean coordinatorActionBean, String string) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.statusStr = string;
            return;
        }
        coordinatorActionBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 19, coordinatorActionBean.statusStr, string, 0);
    }

    private static final int pcGettimeOut(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.timeOut;
        }
        int n = pcInheritedFieldCount + 20;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.timeOut;
    }

    private static final void pcSettimeOut(CoordinatorActionBean coordinatorActionBean, int n) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.timeOut = n;
            return;
        }
        coordinatorActionBean.pcStateManager.settingIntField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 20, coordinatorActionBean.timeOut, n, 0);
    }

    private static final String pcGettrackerUri(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.trackerUri;
        }
        int n = pcInheritedFieldCount + 21;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.trackerUri;
    }

    private static final void pcSettrackerUri(CoordinatorActionBean coordinatorActionBean, String string) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.trackerUri = string;
            return;
        }
        coordinatorActionBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 21, coordinatorActionBean.trackerUri, string, 0);
    }

    private static final String pcGettype(CoordinatorActionBean coordinatorActionBean) {
        if (coordinatorActionBean.pcStateManager == null) {
            return coordinatorActionBean.type;
        }
        int n = pcInheritedFieldCount + 22;
        coordinatorActionBean.pcStateManager.accessingField(n);
        return coordinatorActionBean.type;
    }

    private static final void pcSettype(CoordinatorActionBean coordinatorActionBean, String string) {
        if (coordinatorActionBean.pcStateManager == null) {
            coordinatorActionBean.type = string;
            return;
        }
        coordinatorActionBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorActionBean, pcInheritedFieldCount + 22, coordinatorActionBean.type, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

