/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.oozie.hadoop.utils.HadoopShims;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.jdom.JDOMException;

public class ShareLibService
implements Service,
Instrumentable {
    public static final String LAUNCHERJAR_LIB_RETENTION = "oozie.service.ShareLibService.temp.sharelib.retention.days";
    public static final String SHARELIB_MAPPING_FILE = "oozie.service.ShareLibService.mapping.file";
    public static final String SHIP_LAUNCHER_JAR = "oozie.action.ship.launcher.jar";
    public static final String PURGE_INTERVAL = "oozie.service.ShareLibService.purge.interval";
    public static final String FAIL_FAST_ON_STARTUP = "oozie.service.ShareLibService.fail.fast.on.startup";
    private static final String PERMISSION_STRING = "-rwxr-xr-x";
    public static final String LAUNCHER_LIB_PREFIX = "launcher_";
    public static final String SHARE_LIB_PREFIX = "lib_";
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private Services services;
    private Map<String, List<Path>> shareLibMap = new HashMap<String, List<Path>>();
    private Map<String, Map<Path, Configuration>> shareLibConfigMap = new HashMap<String, Map<Path, Configuration>>();
    private Map<String, List<Path>> launcherLibMap = new HashMap<String, List<Path>>();
    private Set<String> actionConfSet = new HashSet<String>();
    private Map<String, Map<Path, Path>> symlinkMapping = new HashMap<String, Map<Path, Path>>();
    private static XLog LOG = XLog.getLog(ShareLibService.class);
    private String sharelibMappingFile;
    private boolean isShipLauncherEnabled = false;
    public static String SHARE_LIB_CONF_PREFIX = "oozie";
    private boolean shareLibLoadAttempted = false;
    private String sharelibMetaFileOldTimeStamp;
    private String sharelibDirOld;
    FileSystem fs;
    final long retentionTime = 86400000 * ConfigurationService.getInt("oozie.service.ShareLibService.temp.sharelib.retention.days");

    @Override
    public void init(Services services) throws ServiceException {
        this.services = services;
        this.sharelibMappingFile = ConfigurationService.get(services.getConf(), SHARELIB_MAPPING_FILE);
        this.isShipLauncherEnabled = ConfigurationService.getBoolean(services.getConf(), SHIP_LAUNCHER_JAR);
        boolean failOnfailure = ConfigurationService.getBoolean(services.getConf(), FAIL_FAST_ON_STARTUP);
        Path launcherlibPath = this.getLauncherlibPath();
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        URI uri = launcherlibPath.toUri();
        try {
            this.fs = FileSystem.get((Configuration)has.createJobConf(uri.getAuthority()));
            this.cacheActionKeySharelibConfList();
            this.updateLauncherLib();
            this.updateShareLib();
        }
        catch (Throwable e) {
            if (failOnfailure) {
                LOG.error((Object)"Sharelib initialization fails", e);
                throw new ServiceException(ErrorCode.E0104, this.getClass().getName(), "Sharelib initialization fails. ", e);
            }
            ServiceException se = new ServiceException(ErrorCode.E0104, this.getClass().getName(), "Not able to cache sharelib. An Admin needs to install the sharelib with oozie-setup.sh and issue the 'oozie admin' CLI command to update the sharelib", e);
            LOG.error(se);
        }
        Runnable purgeLibsRunnable = new Runnable(){

            @Override
            public void run() {
                System.out.flush();
                try {
                    if (Services.get().get(JobsConcurrencyService.class).isLeader()) {
                        Date current = Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime();
                        ShareLibService.this.purgeLibs(ShareLibService.this.fs, ShareLibService.LAUNCHER_LIB_PREFIX, current);
                        ShareLibService.this.purgeLibs(ShareLibService.this.fs, ShareLibService.SHARE_LIB_PREFIX, current);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"There was an issue purging the sharelib", e);
                }
            }
        };
        services.get(SchedulerService.class).schedule(purgeLibsRunnable, 10L, (long)(ConfigurationService.getInt(services.getConf(), PURGE_INTERVAL) * 60 * 60 * 24), SchedulerService.Unit.SEC);
    }

    private void updateLauncherLib() throws IOException {
        if (this.isShipLauncherEnabled) {
            Path launcherlibPath;
            if (this.fs == null) {
                launcherlibPath = this.getLauncherlibPath();
                HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
                URI uri = launcherlibPath.toUri();
                this.fs = FileSystem.get((Configuration)has.createJobConf(uri.getAuthority()));
            }
            launcherlibPath = this.getLauncherlibPath();
            this.setupLauncherLibPath(this.fs, launcherlibPath);
            this.recursiveChangePermissions(this.fs, launcherlibPath, FsPermission.valueOf((String)PERMISSION_STRING));
        }
    }

    private void setupLauncherLibPath(FileSystem fs, Path tmpLauncherLibPath) throws IOException {
        ActionService actionService = Services.get().get(ActionService.class);
        List<Class> classes = JavaActionExecutor.getCommonLauncherClasses();
        Path baseDir = new Path(tmpLauncherLibPath, "oozie");
        this.copyJarContainingClasses(classes, fs, baseDir, "oozie");
        Set<String> actionTypes = actionService.getActionTypes();
        for (String key : actionTypes) {
            JavaActionExecutor jexecutor;
            ActionExecutor executor = actionService.getExecutor(key);
            if (!(executor instanceof JavaActionExecutor) || (classes = (jexecutor = (JavaActionExecutor)executor).getLauncherClasses()) == null) continue;
            String type = executor.getType();
            Path executorDir = new Path(tmpLauncherLibPath, type);
            this.copyJarContainingClasses(classes, fs, executorDir, type);
        }
    }

    private void recursiveChangePermissions(FileSystem fs, Path path, FsPermission fsPerm) throws IOException {
        fs.setPermission(path, fsPerm);
        FileStatus[] filesStatus = fs.listStatus(path);
        for (int i = 0; i < filesStatus.length; ++i) {
            Path p = filesStatus[i].getPath();
            if (filesStatus[i].isDir()) {
                this.recursiveChangePermissions(fs, p, fsPerm);
                continue;
            }
            fs.setPermission(p, fsPerm);
        }
    }

    private void copyJarContainingClasses(List<Class> classes, FileSystem fs, Path executorDir, String type) throws IOException {
        fs.mkdirs(executorDir);
        HashSet<String> localJarSet = new HashSet<String>();
        for (Class c : classes) {
            String localJar = this.findContainingJar(c);
            if (localJar != null) {
                localJarSet.add(localJar);
                continue;
            }
            throw new IOException("No jar containing " + c + " found");
        }
        ArrayList<Path> listOfPaths = new ArrayList<Path>();
        for (String localJarStr : localJarSet) {
            File localJar = new File(localJarStr);
            fs.copyFromLocalFile(new Path(localJar.getPath()), executorDir);
            Path path = new Path(executorDir, localJar.getName());
            listOfPaths.add(path);
            LOG.info(localJar.getName() + " uploaded to " + executorDir.toString());
        }
        this.launcherLibMap.put(type, listOfPaths);
    }

    private void getPathRecursively(FileSystem fs, Path rootDir, List<Path> listOfPaths, String shareLibKey, Map<String, Map<Path, Configuration>> shareLibConfigMap) throws IOException {
        if (rootDir == null) {
            return;
        }
        try {
            if (fs.isFile(new Path(new URI(rootDir.toString()).getPath()))) {
                Path filePath = new Path(new URI(rootDir.toString()).getPath());
                if (this.isFilePartOfConfList(rootDir)) {
                    this.cachePropertyFile(filePath, shareLibKey, shareLibConfigMap);
                }
                listOfPaths.add(rootDir);
                return;
            }
            FileStatus[] status = fs.listStatus(rootDir);
            if (status == null) {
                LOG.info("Shared lib " + rootDir + " doesn't exist, not adding to cache");
                return;
            }
            for (FileStatus file : status) {
                if (file.isDir()) {
                    this.getPathRecursively(fs, file.getPath(), listOfPaths, shareLibKey, shareLibConfigMap);
                    continue;
                }
                if (this.isFilePartOfConfList(file.getPath())) {
                    this.cachePropertyFile(file.getPath(), shareLibKey, shareLibConfigMap);
                }
                listOfPaths.add(file.getPath());
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        catch (JDOMException e) {
            throw new IOException(e);
        }
    }

    public Map<String, List<Path>> getShareLib() {
        return this.shareLibMap;
    }

    private Map<String, Map<Path, Path>> getSymlinkMapping() {
        return this.symlinkMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public List<Path> getShareLibJars(String shareLibKey) throws IOException {
        if (this.shareLibMap.isEmpty() && !this.shareLibLoadAttempted) {
            Class<ShareLibService> clazz = ShareLibService.class;
            // MONITORENTER : org.apache.oozie.service.ShareLibService.class
            if (this.shareLibMap.isEmpty()) {
                this.updateShareLib();
                this.shareLibLoadAttempted = true;
            }
            // MONITOREXIT : clazz
        }
        this.checkSymlink(shareLibKey);
        return this.shareLibMap.get(shareLibKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSymlink(String shareLibKey) throws IOException {
        if (!HadoopShims.isSymlinkSupported() || this.symlinkMapping.get(shareLibKey) == null || this.symlinkMapping.get(shareLibKey).isEmpty()) {
            return;
        }
        HadoopShims fileSystem = new HadoopShims(this.fs);
        for (Path path : this.symlinkMapping.get(shareLibKey).keySet()) {
            if (this.symlinkMapping.get(shareLibKey).get(path).equals((Object)fileSystem.getSymLinkTarget(path))) continue;
            Class<ShareLibService> clazz = ShareLibService.class;
            synchronized (ShareLibService.class) {
                HashMap<String, List<Path>> tmpShareLibMap = new HashMap<String, List<Path>>(this.shareLibMap);
                HashMap<String, Map<Path, Configuration>> tmpShareLibConfigMap = new HashMap<String, Map<Path, Configuration>>(this.shareLibConfigMap);
                HashMap<String, Map<Path, Path>> tmpSymlinkMapping = new HashMap<String, Map<Path, Path>>(this.symlinkMapping);
                LOG.info(MessageFormat.format("Symlink target for [{0}] has changed, was [{1}], now [{2}]", shareLibKey, path, fileSystem.getSymLinkTarget(path)));
                this.loadShareLibMetaFile(tmpShareLibMap, tmpSymlinkMapping, tmpShareLibConfigMap, this.sharelibMappingFile, shareLibKey);
                this.shareLibMap = tmpShareLibMap;
                this.symlinkMapping = tmpSymlinkMapping;
                this.shareLibConfigMap = tmpShareLibConfigMap;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public List<Path> getSystemLibJars(String shareLibKey) throws IOException {
        ArrayList<Path> returnList = new ArrayList<Path>();
        if (this.isShipLauncherEnabled) {
            if (this.launcherLibMap.isEmpty()) {
                Class<ShareLibService> clazz = ShareLibService.class;
                // MONITORENTER : org.apache.oozie.service.ShareLibService.class
                if (this.launcherLibMap.isEmpty()) {
                    this.updateLauncherLib();
                }
                // MONITOREXIT : clazz
            }
            if (this.launcherLibMap.get(shareLibKey) != null) {
                returnList.addAll((Collection<Path>)this.launcherLibMap.get(shareLibKey));
            }
        }
        if (!shareLibKey.equals("oozie")) return returnList;
        List<Path> sharelibList = this.getShareLibJars(shareLibKey);
        if (sharelibList == null) return returnList;
        returnList.addAll(sharelibList);
        return returnList;
    }

    @VisibleForTesting
    protected String findContainingJar(Class clazz) {
        ClassLoader loader = clazz.getClassLoader();
        String classFile = clazz.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = loader.getResources(classFile);
            while (itr.hasMoreElements()) {
                String toReturn;
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol()) || !(toReturn = url.getPath()).startsWith("file:")) continue;
                toReturn = toReturn.substring("file:".length());
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                toReturn = toReturn.replaceAll("!.*$", "");
                return toReturn;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return null;
    }

    private void purgeLibs(FileSystem fs, final String prefix, final Date current) throws IOException {
        Path executorLibBasePath = this.services.get(WorkflowAppService.class).getSystemLibPath();
        PathFilter directoryFilter = new PathFilter(){

            public boolean accept(Path path) {
                if (path.getName().startsWith(prefix)) {
                    String name = path.getName();
                    String time = name.substring(prefix.length());
                    Date d = null;
                    try {
                        d = dateFormat.parse(time);
                    }
                    catch (ParseException e) {
                        return false;
                    }
                    return current.getTime() - d.getTime() > ShareLibService.this.retentionTime;
                }
                return false;
            }
        };
        FileStatus[] dirList = fs.listStatus(executorLibBasePath, directoryFilter);
        Arrays.sort(dirList, new Comparator<FileStatus>(){

            @Override
            public int compare(FileStatus o1, FileStatus o2) {
                return o2.getPath().getName().compareTo(o1.getPath().getName());
            }
        });
        for (int i = 1; i < dirList.length; ++i) {
            Path dirPath = dirList[i].getPath();
            fs.delete(dirPath, true);
            LOG.info("Deleted old launcher jar lib directory {0}", dirPath.getName());
        }
    }

    @Override
    public void destroy() {
        this.shareLibMap.clear();
        this.launcherLibMap.clear();
    }

    @Override
    public Class<? extends Service> getInterface() {
        return ShareLibService.class;
    }

    public Map<String, String> updateShareLib() throws IOException {
        HashMap<String, String> status = new HashMap<String, String>();
        if (this.fs == null) {
            Path launcherlibPath = this.getLauncherlibPath();
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            URI uri = launcherlibPath.toUri();
            this.fs = FileSystem.get((Configuration)has.createJobConf(uri.getAuthority()));
        }
        HashMap<String, List<Path>> tempShareLibMap = new HashMap<String, List<Path>>();
        HashMap<String, Map<Path, Path>> tmpSymlinkMapping = new HashMap<String, Map<Path, Path>>();
        HashMap<String, Map<Path, Configuration>> tmpShareLibConfigMap = new HashMap<String, Map<Path, Configuration>>();
        if (!StringUtils.isEmpty((String)this.sharelibMappingFile.trim())) {
            String sharelibMetaFileNewTimeStamp = JsonUtils.formatDateRfc822((Date)new Date(this.fs.getFileStatus(new Path(this.sharelibMappingFile)).getModificationTime()), (String)"GMT");
            this.loadShareLibMetaFile(tempShareLibMap, tmpSymlinkMapping, tmpShareLibConfigMap, this.sharelibMappingFile, null);
            status.put("sharelibMetaFile", this.sharelibMappingFile);
            status.put("sharelibMetaFileNewTimeStamp", sharelibMetaFileNewTimeStamp);
            status.put("sharelibMetaFileOldTimeStamp", this.sharelibMetaFileOldTimeStamp);
            this.sharelibMetaFileOldTimeStamp = sharelibMetaFileNewTimeStamp;
        } else {
            Path shareLibpath = this.getLatestLibPath(this.services.get(WorkflowAppService.class).getSystemLibPath(), SHARE_LIB_PREFIX);
            this.loadShareLibfromDFS(tempShareLibMap, shareLibpath, tmpShareLibConfigMap);
            if (shareLibpath != null) {
                status.put("sharelibDirNew", shareLibpath.toString());
                status.put("sharelibDirOld", this.sharelibDirOld);
                this.sharelibDirOld = shareLibpath.toString();
            }
        }
        this.shareLibMap = tempShareLibMap;
        this.symlinkMapping = tmpSymlinkMapping;
        this.shareLibConfigMap = tmpShareLibConfigMap;
        return status;
    }

    private void loadShareLibfromDFS(Map<String, List<Path>> shareLibMap, Path shareLibpath, Map<String, Map<Path, Configuration>> shareLibConfigMap) throws IOException {
        if (shareLibpath == null) {
            LOG.info("No share lib directory found");
            return;
        }
        FileStatus[] dirList = this.fs.listStatus(shareLibpath);
        if (dirList == null) {
            return;
        }
        for (FileStatus dir : dirList) {
            if (!dir.isDir()) continue;
            ArrayList<Path> listOfPaths = new ArrayList<Path>();
            this.getPathRecursively(this.fs, dir.getPath(), listOfPaths, dir.getPath().getName(), shareLibConfigMap);
            shareLibMap.put(dir.getPath().getName(), listOfPaths);
            LOG.info("Share lib for " + dir.getPath().getName() + ":" + listOfPaths);
        }
    }

    private void loadShareLibMetaFile(Map<String, List<Path>> shareLibMap, Map<String, Map<Path, Path>> symlinkMapping, Map<String, Map<Path, Configuration>> shareLibConfigMap, String sharelibFileMapping, String shareLibKey) throws IOException {
        Path shareFileMappingPath = new Path(sharelibFileMapping);
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        FileSystem filesystem = FileSystem.get((Configuration)has.createJobConf(shareFileMappingPath.toUri().getAuthority()));
        Properties prop = new Properties();
        prop.load((InputStream)filesystem.open(new Path(sharelibFileMapping)));
        for (Object keyObject : prop.keySet()) {
            String key = (String)keyObject;
            String mapKey = key.substring(SHARE_LIB_CONF_PREFIX.length() + 1);
            if (!key.toLowerCase().startsWith(SHARE_LIB_CONF_PREFIX) || shareLibKey != null && !shareLibKey.equals(mapKey)) continue;
            this.loadSharelib(shareLibMap, symlinkMapping, shareLibConfigMap, mapKey, ((String)prop.get(key)).split(","));
        }
    }

    private void loadSharelib(Map<String, List<Path>> tmpShareLibMap, Map<String, Map<Path, Path>> tmpSymlinkMapping, Map<String, Map<Path, Configuration>> shareLibConfigMap, String shareLibKey, String[] pathList) throws IOException {
        ArrayList<Path> listOfPaths = new ArrayList<Path>();
        HashMap<Path, Path> symlinkMappingforAction = new HashMap<Path, Path>();
        HadoopShims fileSystem = new HadoopShims(this.fs);
        for (String dfsPath : pathList) {
            Path path = new Path(dfsPath);
            this.getPathRecursively(this.fs, new Path(dfsPath), listOfPaths, shareLibKey, shareLibConfigMap);
            if (!HadoopShims.isSymlinkSupported() || !fileSystem.isSymlink(path)) continue;
            symlinkMappingforAction.put(path, fileSystem.getSymLinkTarget(path));
        }
        if (HadoopShims.isSymlinkSupported()) {
            LOG.info("symlink for " + shareLibKey + ":" + symlinkMappingforAction);
            tmpSymlinkMapping.put(shareLibKey, symlinkMappingforAction);
        }
        tmpShareLibMap.put(shareLibKey, listOfPaths);
        LOG.info("Share lib for " + shareLibKey + ":" + listOfPaths);
    }

    private Path getLauncherlibPath() {
        String formattedDate = dateFormat.format(Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime());
        Path tmpLauncherLibPath = new Path(this.services.get(WorkflowAppService.class).getSystemLibPath(), LAUNCHER_LIB_PREFIX + formattedDate);
        return tmpLauncherLibPath;
    }

    public Path getLatestLibPath(Path rootDir, final String prefix) throws IOException {
        FileStatus[] files;
        Date max = new Date(0L);
        Path path = null;
        PathFilter directoryFilter = new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith(prefix);
            }
        };
        for (FileStatus file : files = this.fs.listStatus(rootDir, directoryFilter)) {
            String name = file.getPath().getName().toString();
            String time = name.substring(prefix.length());
            Date d = null;
            try {
                d = dateFormat.parse(time);
            }
            catch (ParseException e) {
                continue;
            }
            if (d.compareTo(max) <= 0) continue;
            path = file.getPath();
            max = d;
        }
        if (path == null) {
            path = rootDir;
        }
        return path;
    }

    @Override
    public void instrument(Instrumentation instr) {
        instr.addVariable("libs", "sharelib.source", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                if (!StringUtils.isEmpty((String)ShareLibService.this.sharelibMappingFile.trim())) {
                    return ShareLibService.SHARELIB_MAPPING_FILE;
                }
                return "oozie.service.WorkflowAppService.system.libpath";
            }
        });
        instr.addVariable("libs", "sharelib.mapping.file", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                if (!StringUtils.isEmpty((String)ShareLibService.this.sharelibMappingFile.trim())) {
                    return ShareLibService.this.sharelibMappingFile;
                }
                return "(none)";
            }
        });
        instr.addVariable("libs", "sharelib.system.libpath", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                String sharelibPath = "(unavailable)";
                try {
                    Path libPath = ShareLibService.this.getLatestLibPath(ShareLibService.this.services.get(WorkflowAppService.class).getSystemLibPath(), ShareLibService.SHARE_LIB_PREFIX);
                    if (libPath != null) {
                        sharelibPath = libPath.toUri().toString();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return sharelibPath;
            }
        });
        instr.addVariable("libs", "sharelib.mapping.file.timestamp", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                if (!StringUtils.isEmpty((String)ShareLibService.this.sharelibMetaFileOldTimeStamp)) {
                    return ShareLibService.this.sharelibMetaFileOldTimeStamp;
                }
                return "(none)";
            }
        });
        instr.addVariable("libs", "sharelib.keys", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                Map<String, List<Path>> shareLib = ShareLibService.this.getShareLib();
                if (shareLib != null && !shareLib.isEmpty()) {
                    Set<String> keySet = shareLib.keySet();
                    return keySet.toString();
                }
                return "(unavailable)";
            }
        });
        instr.addVariable("libs", "launcherlib.system.libpath", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                return ShareLibService.this.getLauncherlibPath().toUri().toString();
            }
        });
        instr.addVariable("libs", "sharelib.symlink.mapping", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                Map shareLibSymlinkMapping = ShareLibService.this.getSymlinkMapping();
                if (shareLibSymlinkMapping != null && !shareLibSymlinkMapping.isEmpty() && shareLibSymlinkMapping.values() != null && !shareLibSymlinkMapping.values().isEmpty()) {
                    StringBuffer bf = new StringBuffer();
                    for (Map.Entry key : shareLibSymlinkMapping.entrySet()) {
                        if (key.getKey() == null || ((Map)key.getValue()).isEmpty()) continue;
                        for (Path path : ((Map)key.getValue()).keySet()) {
                            bf.append(path).append("(").append(key).append(")").append("=>").append(((Map)shareLibSymlinkMapping.get(key)).get(path)).append(",");
                        }
                    }
                    return bf.toString();
                }
                return "(none)";
            }
        });
        instr.addVariable("libs", "sharelib.cached.config.file", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                Map<String, Map<Path, Configuration>> shareLibConfigMap = ShareLibService.this.getShareLibConfigMap();
                if (shareLibConfigMap != null && !shareLibConfigMap.isEmpty()) {
                    StringBuffer bf = new StringBuffer();
                    for (String path : shareLibConfigMap.keySet()) {
                        bf.append(path).append(";");
                    }
                    return bf.toString();
                }
                return "(none)";
            }
        });
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    private void cachePropertyFile(Path hdfsPath, String shareLibKey, Map<String, Map<Path, Configuration>> shareLibConfigMap) throws IOException, JDOMException {
        Map<Path, Configuration> confMap = shareLibConfigMap.get(shareLibKey);
        if (confMap == null) {
            confMap = new HashMap<Path, Configuration>();
            shareLibConfigMap.put(shareLibKey, confMap);
        }
        XConfiguration xmlConf = new XConfiguration((InputStream)this.fs.open(hdfsPath));
        confMap.put(hdfsPath, xmlConf);
    }

    private void cacheActionKeySharelibConfList() {
        ActionService actionService = Services.get().get(ActionService.class);
        Set<String> actionTypes = actionService.getActionTypes();
        for (String key : actionTypes) {
            ActionExecutor executor = actionService.getExecutor(key);
            if (!(executor instanceof JavaActionExecutor)) continue;
            JavaActionExecutor jexecutor = (JavaActionExecutor)executor;
            this.actionConfSet.addAll(new HashSet<String>(Arrays.asList(jexecutor.getShareLibFilesForActionConf() == null ? new String[]{} : jexecutor.getShareLibFilesForActionConf())));
        }
    }

    public Configuration getShareLibConf(String inputKey, Path path) {
        if (this.shareLibConfigMap.containsKey(inputKey)) {
            return this.shareLibConfigMap.get(inputKey).get(path);
        }
        return null;
    }

    @VisibleForTesting
    public Map<String, Map<Path, Configuration>> getShareLibConfigMap() {
        return this.shareLibConfigMap;
    }

    private boolean isFilePartOfConfList(Path path) throws URISyntaxException {
        String fragmentName = new URI(path.toString()).getFragment();
        String fileName = fragmentName == null ? path.getName() : fragmentName;
        return this.actionConfSet.contains(fileName);
    }
}

