/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.util.DateUtils;

public class XLogUserFilterParam {
    public static final String START_TIME = "START";
    public static final String END_TIME = "END";
    public static final String SEARCH_TEXT = "TEXT";
    public static final String LOG_LEVEL = "LOGLEVEL";
    public static final String LIMIT = "LIMIT";
    public static final String RECENT_LOG_OFFSET = "RECENT";
    public static final String DEBUG = "DEBUG";
    private Date startTime;
    private Date endTime;
    private int startOffset;
    private int endOffset = -1;
    private int recent = -1;
    private String logLevel;
    private int limit = -1;
    private boolean isDebug = false;
    private String searchText;
    private String params;
    public static final ThreadLocal<SimpleDateFormat> dt = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    static final HashSet<String> LOG_LEVELS = new HashSet();

    public XLogUserFilterParam() {
    }

    public XLogUserFilterParam(Map<String, String[]> params) throws CommandException {
        if (params != null && params.get("logfilter") != null && params.get("logfilter").length > 0) {
            try {
                this.parseFilterParam(params.get("logfilter")[0]);
            }
            catch (Exception e) {
                throw new CommandException(ErrorCode.E0302, e.getMessage());
            }
        }
    }

    private void parseFilterParam(String param) throws Exception {
        this.params = param;
        if (StringUtils.isEmpty((String)param)) {
            return;
        }
        for (String keyValue : param.split(";")) {
            String value;
            String[] pairs = keyValue.split("=");
            String key = pairs[0].toUpperCase();
            String string = value = pairs.length == 1 ? "" : pairs[1];
            if (key.equals(START_TIME)) {
                this.startTime = this.getDate(value);
                if (this.startTime != null) continue;
                this.startOffset = this.getOffsetInMinute(value);
                continue;
            }
            if (key.equals(END_TIME)) {
                this.endTime = this.getDate(value);
                if (this.endTime != null) continue;
                this.endOffset = this.getOffsetInMinute(value);
                continue;
            }
            if (key.equals(RECENT_LOG_OFFSET)) {
                this.recent = this.getOffsetInMinute(value);
                continue;
            }
            if (key.equals(LIMIT)) {
                this.limit = Integer.parseInt(value);
                continue;
            }
            if (key.equals(LOG_LEVEL)) {
                this.logLevel = value;
                this.validateLogLevel(this.logLevel);
                continue;
            }
            if (key.equals(DEBUG)) {
                this.isDebug = true;
                continue;
            }
            if (key.equals(SEARCH_TEXT)) {
                this.searchText = value;
                continue;
            }
            throw new Exception("Unsupported log filter " + key);
        }
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public Date getStartDate() {
        return this.startTime;
    }

    public Date getEndDate() {
        return this.endTime;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void validateLogLevel(String loglevel) throws CommandException {
        if (StringUtils.isEmpty((String)loglevel)) {
            return;
        }
        for (String level : this.getLogLevel().split("\\|")) {
            if (LOG_LEVELS.contains(level)) continue;
            throw new CommandException(ErrorCode.E0302, "Supported log level are " + LOG_LEVELS.toString());
        }
    }

    public void validateSearchText() throws CommandException {
    }

    public Date getDate(String date) {
        try {
            return DateUtils.parseDateOozieTZ(date);
        }
        catch (ParseException e) {
            try {
                return dt.get().parse(date);
            }
            catch (ParseException e1) {
                return null;
            }
        }
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getRecent() {
        return this.recent;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public String toString() {
        return this.params;
    }

    private int getOffsetInMinute(String offset) throws IOException {
        if (Character.isLetter(offset.charAt(offset.length() - 1))) {
            switch (offset.charAt(offset.length() - 1)) {
                case 'h': {
                    return Integer.parseInt(offset.substring(0, offset.length() - 1)) * 60;
                }
                case 'm': {
                    return Integer.parseInt(offset.substring(0, offset.length() - 1));
                }
            }
            throw new IOException("Unsupported offset " + offset);
        }
        if (StringUtils.isNumeric((String)offset)) {
            return Integer.parseInt(offset) * 60;
        }
        throw new IOException("Unsupported time : " + offset);
    }

    static {
        LOG_LEVELS.add("ALL");
        LOG_LEVELS.add(DEBUG);
        LOG_LEVELS.add("ERROR");
        LOG_LEVELS.add("INFO");
        LOG_LEVELS.add("TRACE");
        LOG_LEVELS.add("WARN");
        LOG_LEVELS.add("FATAL");
    }
}

