/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyDictionary<S, T>
extends Dictionary<S, T>
implements Map<S, T>,
Comparable<ReadOnlyDictionary<S, T>> {
    private final Hashtable<S, T> m_delegate;
    private final ServiceReference<?> m_serviceReference;

    public ReadOnlyDictionary(Map<S, T> delegate) {
        if (delegate instanceof Hashtable) {
            this.m_delegate = (Hashtable)delegate;
        } else {
            this.m_delegate = new Hashtable();
            for (Map.Entry<S, T> entry : delegate.entrySet()) {
                this.m_delegate.put(entry.getKey(), entry.getValue());
            }
        }
        this.m_serviceReference = null;
    }

    public ReadOnlyDictionary(ServiceReference<?> serviceReference) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] keys = serviceReference.getPropertyKeys();
        if (keys != null) {
            for (int j = 0; j < keys.length; ++j) {
                String key = keys[j];
                properties.put(key, serviceReference.getProperty(key));
            }
        }
        this.m_delegate = properties;
        this.m_serviceReference = serviceReference;
    }

    @Override
    public Enumeration<T> elements() {
        return this.m_delegate.elements();
    }

    @Override
    public T get(Object key) {
        return this.m_delegate.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.m_delegate.isEmpty();
    }

    @Override
    public Enumeration<S> keys() {
        return this.m_delegate.keys();
    }

    @Override
    public T put(S key, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.m_delegate.size();
    }

    public String toString() {
        return this.m_delegate.toString();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m_delegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<S, T>> entrySet() {
        return Collections.unmodifiableSet(this.m_delegate.entrySet());
    }

    @Override
    public Set<S> keySet() {
        return Collections.unmodifiableSet(this.m_delegate.keySet());
    }

    @Override
    public void putAll(Map<? extends S, ? extends T> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<T> values() {
        return Collections.unmodifiableCollection(this.m_delegate.values());
    }

    @Override
    public int compareTo(ReadOnlyDictionary<S, T> o) {
        if (this.m_serviceReference == null) {
            if (o.m_serviceReference == null) {
                return 0;
            }
            return 1;
        }
        if (o.m_serviceReference == null) {
            return -1;
        }
        return this.m_serviceReference.compareTo(o.m_serviceReference);
    }
}

