/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.RMHAUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.http.client.utils.URLEncodedUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class WebAppUtils {
    public static final String WEB_APP_TRUSTSTORE_PASSWORD_KEY = "ssl.server.truststore.password";
    public static final String WEB_APP_KEYSTORE_PASSWORD_KEY = "ssl.server.keystore.password";
    public static final String WEB_APP_KEY_PASSWORD_KEY = "ssl.server.keystore.keypassword";
    public static final String HTTPS_PREFIX = "https://";
    public static final String HTTP_PREFIX = "http://";

    public static void setRMWebAppPort(Configuration conf, int port) {
        String hostname = WebAppUtils.getRMWebAppURLWithoutScheme(conf);
        hostname = hostname.contains(":") ? hostname.substring(0, hostname.indexOf(":")) : hostname;
        WebAppUtils.setRMWebAppHostnameAndPort(conf, hostname, port);
    }

    public static void setRMWebAppHostnameAndPort(Configuration conf, String hostname, int port) {
        String resolvedAddress = hostname + ":" + port;
        if (YarnConfiguration.useHttps((Configuration)conf)) {
            conf.set("yarn.resourcemanager.webapp.https.address", resolvedAddress);
        } else {
            conf.set("yarn.resourcemanager.webapp.address", resolvedAddress);
        }
    }

    public static void setNMWebAppHostNameAndPort(Configuration conf, String hostName, int port) {
        if (YarnConfiguration.useHttps((Configuration)conf)) {
            conf.set("yarn.nodemanager.webapp.https.address", hostName + ":" + port);
        } else {
            conf.set("yarn.nodemanager.webapp.address", hostName + ":" + port);
        }
    }

    public static String getRMWebAppURLWithScheme(Configuration conf) {
        return WebAppUtils.getHttpSchemePrefix(conf) + WebAppUtils.getRMWebAppURLWithoutScheme(conf);
    }

    public static String getRMWebAppURLWithoutScheme(Configuration conf) {
        if (YarnConfiguration.useHttps((Configuration)conf)) {
            return conf.get("yarn.resourcemanager.webapp.https.address", "0.0.0.0:8090");
        }
        return conf.get("yarn.resourcemanager.webapp.address", "0.0.0.0:8088");
    }

    public static List<String> getProxyHostsAndPortsForAmFilter(Configuration conf) {
        ArrayList<String> addrs = new ArrayList<String>();
        String proxyAddr = conf.get("yarn.web-proxy.address");
        if (proxyAddr == null || proxyAddr.isEmpty()) {
            if (HAUtil.isHAEnabled((Configuration)conf)) {
                List<String> haAddrs = RMHAUtils.getRMHAWebappAddresses(new YarnConfiguration(conf));
                for (String addr : haAddrs) {
                    try {
                        InetSocketAddress socketAddr = NetUtils.createSocketAddr((String)addr);
                        addrs.add(WebAppUtils.getResolvedAddress(socketAddr));
                    }
                    catch (IllegalArgumentException e) {}
                }
            }
            if (addrs.isEmpty()) {
                addrs.add(WebAppUtils.getResolvedRMWebAppURLWithoutScheme(conf));
            }
        } else {
            addrs.add(proxyAddr);
        }
        return addrs;
    }

    public static String getProxyHostAndPort(Configuration conf) {
        String addr = conf.get("yarn.web-proxy.address");
        if (addr == null || addr.isEmpty()) {
            addr = WebAppUtils.getResolvedRMWebAppURLWithoutScheme(conf);
        }
        return addr;
    }

    public static String getResolvedRemoteRMWebAppURLWithScheme(Configuration conf) {
        return WebAppUtils.getHttpSchemePrefix(conf) + WebAppUtils.getResolvedRemoteRMWebAppURLWithoutScheme(conf);
    }

    public static String getResolvedRMWebAppURLWithScheme(Configuration conf) {
        return WebAppUtils.getHttpSchemePrefix(conf) + WebAppUtils.getResolvedRMWebAppURLWithoutScheme(conf);
    }

    public static String getResolvedRemoteRMWebAppURLWithoutScheme(Configuration conf) {
        return WebAppUtils.getResolvedRemoteRMWebAppURLWithoutScheme(conf, YarnConfiguration.useHttps((Configuration)conf) ? HttpConfig.Policy.HTTPS_ONLY : HttpConfig.Policy.HTTP_ONLY);
    }

    public static String getResolvedRMWebAppURLWithoutScheme(Configuration conf) {
        return WebAppUtils.getResolvedRMWebAppURLWithoutScheme(conf, YarnConfiguration.useHttps((Configuration)conf) ? HttpConfig.Policy.HTTPS_ONLY : HttpConfig.Policy.HTTP_ONLY);
    }

    public static String getResolvedRMWebAppURLWithoutScheme(Configuration conf, HttpConfig.Policy httpPolicy) {
        InetSocketAddress address = null;
        address = httpPolicy == HttpConfig.Policy.HTTPS_ONLY ? conf.getSocketAddr("yarn.resourcemanager.webapp.https.address", "0.0.0.0:8090", 8090) : conf.getSocketAddr("yarn.resourcemanager.webapp.address", "0.0.0.0:8088", 8088);
        return WebAppUtils.getResolvedAddress(address);
    }

    public static String getResolvedRemoteRMWebAppURLWithoutScheme(Configuration conf, HttpConfig.Policy httpPolicy) {
        InetSocketAddress address = null;
        String rmId = null;
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            rmId = (String)HAUtil.getRMHAIds((Configuration)conf).toArray()[0];
        }
        address = httpPolicy == HttpConfig.Policy.HTTPS_ONLY ? conf.getSocketAddr(rmId == null ? "yarn.resourcemanager.webapp.https.address" : HAUtil.addSuffix((String)"yarn.resourcemanager.webapp.https.address", (String)rmId), "0.0.0.0:8090", 8090) : conf.getSocketAddr(rmId == null ? "yarn.resourcemanager.webapp.address" : HAUtil.addSuffix((String)"yarn.resourcemanager.webapp.address", (String)rmId), "0.0.0.0:8088", 8088);
        return WebAppUtils.getResolvedAddress(address);
    }

    private static String getResolvedAddress(InetSocketAddress address) {
        address = NetUtils.getConnectAddress((InetSocketAddress)address);
        StringBuilder sb = new StringBuilder();
        InetAddress resolved = address.getAddress();
        if (resolved == null || resolved.isAnyLocalAddress() || resolved.isLoopbackAddress()) {
            String lh = address.getHostName();
            try {
                lh = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            sb.append(lh);
        } else {
            sb.append(address.getHostName());
        }
        sb.append(":").append(address.getPort());
        return sb.toString();
    }

    public static String getWebAppBindURL(Configuration conf, String hostProperty, String webAppURLWithoutScheme) {
        String host = conf.getTrimmed(hostProperty);
        if (host != null && !host.isEmpty()) {
            if (webAppURLWithoutScheme.contains(":")) {
                webAppURLWithoutScheme = host + ":" + webAppURLWithoutScheme.split(":")[1];
            } else {
                throw new YarnRuntimeException("webAppURLWithoutScheme must include port specification but doesn't: " + webAppURLWithoutScheme);
            }
        }
        return webAppURLWithoutScheme;
    }

    public static String getNMWebAppURLWithoutScheme(Configuration conf) {
        if (YarnConfiguration.useHttps((Configuration)conf)) {
            return conf.get("yarn.nodemanager.webapp.https.address", "0.0.0.0:8044");
        }
        return conf.get("yarn.nodemanager.webapp.address", "0.0.0.0:8042");
    }

    public static String getAHSWebAppURLWithoutScheme(Configuration conf) {
        if (YarnConfiguration.useHttps((Configuration)conf)) {
            return conf.get("yarn.timeline-service.webapp.https.address", "0.0.0.0:8190");
        }
        return conf.get("yarn.timeline-service.webapp.address", "0.0.0.0:8188");
    }

    public static String getURLWithScheme(String schemePrefix, String url) {
        if (url.indexOf("://") > 0) {
            return url;
        }
        return schemePrefix + url;
    }

    public static String getRunningLogURL(String nodeHttpAddress, String containerId, String user) {
        if (nodeHttpAddress == null || nodeHttpAddress.isEmpty() || containerId == null || containerId.isEmpty() || user == null || user.isEmpty()) {
            return null;
        }
        return StringHelper.PATH_JOINER.join((Object)nodeHttpAddress, (Object)"node", new Object[]{"containerlogs", containerId, user});
    }

    public static String getAggregatedLogURL(String serverHttpAddress, String allocatedNode, String containerId, String entity, String user) {
        if (serverHttpAddress == null || serverHttpAddress.isEmpty() || allocatedNode == null || allocatedNode.isEmpty() || containerId == null || containerId.isEmpty() || entity == null || entity.isEmpty() || user == null || user.isEmpty()) {
            return null;
        }
        return StringHelper.PATH_JOINER.join((Object)serverHttpAddress, (Object)"applicationhistory", new Object[]{"logs", allocatedNode, containerId, entity, user});
    }

    public static String getHttpSchemePrefix(Configuration conf) {
        return YarnConfiguration.useHttps((Configuration)conf) ? HTTPS_PREFIX : HTTP_PREFIX;
    }

    public static HttpServer2.Builder loadSslConfiguration(HttpServer2.Builder builder) {
        return WebAppUtils.loadSslConfiguration(builder, null);
    }

    public static HttpServer2.Builder loadSslConfiguration(HttpServer2.Builder builder, Configuration sslConf) {
        if (sslConf == null) {
            sslConf = new Configuration(false);
        }
        boolean needsClientAuth = false;
        sslConf.addResource("ssl-server.xml");
        return builder.needsClientAuth(needsClientAuth).keyPassword(WebAppUtils.getPassword(sslConf, WEB_APP_KEY_PASSWORD_KEY)).keyStore(sslConf.get("ssl.server.keystore.location"), WebAppUtils.getPassword(sslConf, WEB_APP_KEYSTORE_PASSWORD_KEY), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), WebAppUtils.getPassword(sslConf, WEB_APP_TRUSTSTORE_PASSWORD_KEY), sslConf.get("ssl.server.truststore.type", "jks")).excludeCiphers(sslConf.get("ssl.server.exclude.cipher.list"));
    }

    static String getPassword(Configuration conf, String alias) {
        String password = null;
        try {
            char[] passchars = conf.getPassword(alias);
            if (passchars != null) {
                password = new String(passchars);
            }
        }
        catch (IOException ioe) {
            password = null;
        }
        return password;
    }

    public static ApplicationId parseApplicationId(RecordFactory recordFactory, String appId) {
        if (appId == null || appId.isEmpty()) {
            throw new NotFoundException("appId, " + appId + ", is empty or null");
        }
        ApplicationId aid = null;
        try {
            aid = ConverterUtils.toApplicationId(recordFactory, appId);
        }
        catch (Exception e) {
            throw new BadRequestException(e);
        }
        if (aid == null) {
            throw new NotFoundException("app with id " + appId + " not found");
        }
        return aid;
    }

    public static String getSupportedLogContentType(String format) {
        if (format.equalsIgnoreCase("text")) {
            return "text/plain";
        }
        if (format.equalsIgnoreCase("octet-stream")) {
            return "application/octet-stream";
        }
        return null;
    }

    public static String getDefaultLogContentType() {
        return "text/plain";
    }

    public static List<String> listSupportedLogContentType() {
        return Arrays.asList("text", "octet-stream");
    }

    private static String getURLEncodedQueryString(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            String reqEncoding = request.getCharacterEncoding();
            if (reqEncoding == null || reqEncoding.isEmpty()) {
                reqEncoding = "ISO-8859-1";
            }
            Charset encoding = Charset.forName(reqEncoding);
            List params = URLEncodedUtils.parse((String)queryString, (Charset)encoding);
            return URLEncodedUtils.format((Iterable)params, (Charset)encoding);
        }
        return null;
    }

    public static String getHtmlEscapedURIWithQueryString(HttpServletRequest request) {
        String urlEncodedQueryString = WebAppUtils.getURLEncodedQueryString(request);
        if (urlEncodedQueryString != null) {
            return HtmlQuoting.quoteHtmlChars((String)(request.getRequestURI() + "?" + urlEncodedQueryString));
        }
        return HtmlQuoting.quoteHtmlChars((String)request.getRequestURI());
    }

    public static String appendQueryParams(HttpServletRequest request, String targetUri) {
        String ret = targetUri;
        String urlEncodedQueryString = WebAppUtils.getURLEncodedQueryString(request);
        if (urlEncodedQueryString != null) {
            ret = ret + "?" + urlEncodedQueryString;
        }
        return ret;
    }
}

