/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.logic;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.coord.input.dependency.CoordInputInstance;
import org.apache.oozie.coord.input.dependency.CoordPullInputDependency;
import org.apache.oozie.coord.input.dependency.CoordPushInputDependency;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluator;
import org.apache.oozie.coord.input.logic.CoordInputLogicEvaluatorResult;

public class CoordInputLogicEvaluatorPhaseValidate
implements CoordInputLogicEvaluator {
    CoordPullInputDependency coordPullInputDependency;
    CoordPushInputDependency coordPushInputDependency;
    protected Map<String, List<CoordInputInstance>> dependencyMap;
    protected CoordinatorActionBean coordAction = null;
    protected CoordinatorJob coordJob = null;

    public CoordInputLogicEvaluatorPhaseValidate(CoordinatorActionBean coordAction) {
        this.coordAction = coordAction;
        this.coordPullInputDependency = (CoordPullInputDependency)coordAction.getPullInputDependencies();
        this.coordPushInputDependency = (CoordPushInputDependency)coordAction.getPushInputDependencies();
    }

    @Override
    public CoordInputLogicEvaluatorResult evalInput(String dataSet, int min, int wait) {
        this.getDataSetLen(dataSet);
        return new CoordInputLogicEvaluatorResult(CoordInputLogicEvaluatorResult.STATUS.FALSE);
    }

    @Override
    public CoordInputLogicEvaluatorResult evalCombineInput(String[] inputSets, int min, int wait) {
        if (inputSets.length <= 1) {
            throw new RuntimeException("Combine should have at least two input sets. DataSets : " + Arrays.toString(inputSets));
        }
        int firstInputSetLen = this.getDataSetLen(inputSets[0]);
        for (int i = 1; i < inputSets.length; ++i) {
            if (this.getDataSetLen(inputSets[i]) != firstInputSetLen) {
                throw new RuntimeException("Combine should have same range. DataSets : " + Arrays.toString(inputSets));
            }
            if (this.coordPullInputDependency.getUnResolvedDependency(inputSets[i]) == null) continue;
            throw new RuntimeException("Combine is not supported for latest/future");
        }
        return new CoordInputLogicEvaluatorResult(CoordInputLogicEvaluatorResult.STATUS.FALSE);
    }

    private int getDataSetLen(String dataset) {
        if (this.coordAction.getPullInputDependencies() != null) {
            if (this.coordPullInputDependency.getDependencyMap().get(dataset) != null) {
                return this.coordPullInputDependency.getDependencyMap().get(dataset).size();
            }
            if (this.coordPullInputDependency.getUnResolvedDependency(dataset) != null) {
                return 1;
            }
        }
        if (this.coordAction.getPushInputDependencies() != null && this.coordPushInputDependency.getDependencyMap().get(dataset) != null) {
            return this.coordPushInputDependency.getDependencyMap().get(dataset).size();
        }
        throw new RuntimeException(" Data set not found : " + dataset);
    }
}

