/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.apache.oozie.AppType;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.util.DateUtils;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Index;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Entity
@Table(name="SLA_SUMMARY")
@NamedQueries(value={@NamedQuery(name="UPDATE_SLA_SUMMARY_FOR_SLA_STATUS", query="update  SLASummaryBean w set w.slaStatus = :slaStatus, w.eventStatus = :eventStatus, w.eventProcessed = :eventProcessed, w.lastModifiedTS = :lastModifiedTS where w.jobId = :jobId"), @NamedQuery(name="UPDATE_SLA_SUMMARY_FOR_STATUS_ACTUAL_TIMES", query="update SLASummaryBean w set w.slaStatus = :slaStatus, w.eventStatus = :eventStatus, w.eventProcessed = :eventProcessed, w.jobStatus = :jobStatus, w.lastModifiedTS = :lastModifiedTS, w.actualStartTS = :actualStartTS, w.actualEndTS = :actualEndTS, w.actualDuration = :actualDuration where w.jobId = :jobId"), @NamedQuery(name="UPDATE_SLA_SUMMARY_FOR_EXPECTED_TIMES", query="update SLASummaryBean w set w.nominalTimeTS = :nominalTime, w.expectedStartTS = :expectedStartTime, w.expectedEndTS = :expectedEndTime, w.expectedDuration = :expectedDuration , w.lastModifiedTS = :lastModTime where w.jobId = :jobId"), @NamedQuery(name="UPDATE_SLA_SUMMARY_EVENTPROCESSED", query="update SLASummaryBean w set w.eventProcessed = :eventProcessed where w.jobId = :jobId"), @NamedQuery(name="UPDATE_SLA_SUMMARY_LAST_MODIFIED_TIME", query="update SLASummaryBean w set w.lastModifiedTS = :lastModifiedTS where w.jobId = :jobId"), @NamedQuery(name="UPDATE_SLA_SUMMARY_ALL", query="update SLASummaryBean w set w.jobId = :jobId, w.appName = :appName, w.appType = :appType, w.nominalTimeTS = :nominalTime, w.expectedStartTS = :expectedStartTime, w.expectedEndTS = :expectedEndTime, w.expectedDuration = :expectedDuration, w.jobStatus = :jobStatus, w.slaStatus = :slaStatus, w.eventStatus = :eventStatus, w.lastModifiedTS = :lastModTime, w.user = :user, w.parentId = :parentId, w.eventProcessed = :eventProcessed, w.actualDuration = :actualDuration, w.actualEndTS = :actualEndTS, w.actualStartTS = :actualStartTS where w.jobId = :jobId"), @NamedQuery(name="GET_SLA_SUMMARY", query="select OBJECT(w) from SLASummaryBean w where w.jobId = :id"), @NamedQuery(name="GET_SLA_SUMMARY_RECORDS_RESTART", query="select OBJECT(w) from SLASummaryBean w where w.eventProcessed <= 7 AND w.lastModifiedTS >= :lastModifiedTime"), @NamedQuery(name="GET_SLA_SUMMARY_EVENTPROCESSED", query="select w.eventProcessed from SLASummaryBean w where w.jobId = :id"), @NamedQuery(name="GET_SLA_SUMMARY_EVENTPROCESSED_LAST_MODIFIED", query="select w.eventProcessed, w.lastModifiedTS from SLASummaryBean w where w.jobId = :id")})
public class SLASummaryBean
implements JsonBean,
PersistenceCapable {
    @Id
    @Basic
    @Column(name="job_id")
    private String jobId;
    @Basic
    @Index
    @Column(name="parent_id")
    private String parentId;
    @Basic
    @Index
    @Column(name="app_name")
    private String appName;
    @Basic
    @Column(name="app_type")
    private String appType;
    @Basic
    @Column(name="user_name")
    private String user;
    @Basic
    @Column(name="created_time")
    private Timestamp createdTimeTS = null;
    @Basic
    @Index
    @Column(name="nominal_time")
    private Timestamp nominalTimeTS = null;
    @Basic
    @Column(name="expected_start")
    private Timestamp expectedStartTS = null;
    @Basic
    @Column(name="expected_end")
    private Timestamp expectedEndTS = null;
    @Basic
    @Column(name="expected_duration")
    private long expectedDuration = -1L;
    @Basic
    @Column(name="actual_start")
    private Timestamp actualStartTS = null;
    @Basic
    @Column(name="actual_end")
    private Timestamp actualEndTS = null;
    @Basic
    @Column(name="actual_duration")
    private long actualDuration = -1L;
    @Basic
    @Column(name="job_status")
    private String jobStatus;
    @Basic
    @Column(name="event_status")
    private String eventStatus;
    @Basic
    @Column(name="sla_status")
    private String slaStatus;
    @Basic
    @Index
    @Column(name="event_processed")
    private byte eventProcessed = 0;
    @Basic
    @Index
    @Column(name="last_modified")
    private Timestamp lastModifiedTS = null;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$oozie$sla$SLASummaryBean;
    private transient Object pcDetachedState;

    public SLASummaryBean() {
    }

    public SLASummaryBean(SLACalcStatus slaCalc) {
        SLARegistrationBean reg = slaCalc.getSLARegistrationBean();
        this.setId(slaCalc.getId());
        this.setAppName(reg.getAppName());
        this.setAppType(reg.getAppType());
        this.setNominalTime(reg.getNominalTime());
        this.setExpectedStart(reg.getExpectedStart());
        this.setExpectedEnd(reg.getExpectedEnd());
        this.setExpectedDuration(reg.getExpectedDuration());
        this.setJobStatus(slaCalc.getJobStatus());
        this.setSLAStatus(slaCalc.getSLAStatus());
        this.setEventStatus(slaCalc.getEventStatus());
        this.setLastModifiedTime(slaCalc.getLastModifiedTime());
        this.setUser(reg.getUser());
        this.setParentId(reg.getParentId());
        this.setEventProcessed(slaCalc.getEventProcessed());
        this.setActualDuration(slaCalc.getActualDuration());
        this.setActualEnd(slaCalc.getActualEnd());
        this.setActualStart(slaCalc.getActualStart());
    }

    public String getId() {
        return SLASummaryBean.pcGetjobId(this);
    }

    public void setId(String jobId) {
        SLASummaryBean.pcSetjobId(this, jobId);
    }

    public String getParentId() {
        return SLASummaryBean.pcGetparentId(this);
    }

    public void setParentId(String parentId) {
        SLASummaryBean.pcSetparentId(this, parentId);
    }

    public Timestamp getCreatedTimestamp() {
        return SLASummaryBean.pcGetcreatedTimeTS(this);
    }

    public void setCreatedTimestamp(Timestamp createdTime) {
        SLASummaryBean.pcSetcreatedTimeTS(this, createdTime);
    }

    public Date getCreatedTime() {
        return DateUtils.toDate(SLASummaryBean.pcGetcreatedTimeTS(this));
    }

    public void setCreatedTime(Date createdTime) {
        SLASummaryBean.pcSetcreatedTimeTS(this, DateUtils.convertDateToTimestamp(createdTime));
    }

    public Date getNominalTime() {
        return DateUtils.toDate(SLASummaryBean.pcGetnominalTimeTS(this));
    }

    public Timestamp getNominalTimestamp() {
        return SLASummaryBean.pcGetnominalTimeTS(this);
    }

    public void setNominalTime(Date nominalTime) {
        SLASummaryBean.pcSetnominalTimeTS(this, DateUtils.convertDateToTimestamp(nominalTime));
    }

    public Date getExpectedStart() {
        return DateUtils.toDate(SLASummaryBean.pcGetexpectedStartTS(this));
    }

    public Timestamp getExpectedStartTimestamp() {
        return SLASummaryBean.pcGetexpectedStartTS(this);
    }

    public void setExpectedStart(Date expectedStart) {
        SLASummaryBean.pcSetexpectedStartTS(this, DateUtils.convertDateToTimestamp(expectedStart));
    }

    public Date getExpectedEnd() {
        return DateUtils.toDate(SLASummaryBean.pcGetexpectedEndTS(this));
    }

    public Timestamp getExpectedEndTimestamp() {
        return SLASummaryBean.pcGetexpectedEndTS(this);
    }

    public void setExpectedEnd(Date expectedEnd) {
        SLASummaryBean.pcSetexpectedEndTS(this, DateUtils.convertDateToTimestamp(expectedEnd));
    }

    public long getExpectedDuration() {
        return SLASummaryBean.pcGetexpectedDuration(this);
    }

    public void setExpectedDuration(long expectedDuration) {
        SLASummaryBean.pcSetexpectedDuration(this, expectedDuration);
    }

    public Date getActualStart() {
        return DateUtils.toDate(SLASummaryBean.pcGetactualStartTS(this));
    }

    public Timestamp getActualStartTimestamp() {
        return SLASummaryBean.pcGetactualStartTS(this);
    }

    public void setActualStart(Date actualStart) {
        SLASummaryBean.pcSetactualStartTS(this, DateUtils.convertDateToTimestamp(actualStart));
    }

    public Date getActualEnd() {
        return DateUtils.toDate(SLASummaryBean.pcGetactualEndTS(this));
    }

    public Timestamp getActualEndTimestamp() {
        return SLASummaryBean.pcGetactualEndTS(this);
    }

    public void setActualEnd(Date actualEnd) {
        SLASummaryBean.pcSetactualEndTS(this, DateUtils.convertDateToTimestamp(actualEnd));
    }

    public long getActualDuration() {
        return SLASummaryBean.pcGetactualDuration(this);
    }

    public void setActualDuration(long actualDuration) {
        SLASummaryBean.pcSetactualDuration(this, actualDuration);
    }

    public String getJobStatus() {
        return SLASummaryBean.pcGetjobStatus(this);
    }

    public void setJobStatus(String status) {
        SLASummaryBean.pcSetjobStatus(this, status);
    }

    public SLAEvent.EventStatus getEventStatus() {
        return SLASummaryBean.pcGeteventStatus(this) != null ? SLAEvent.EventStatus.valueOf((String)SLASummaryBean.pcGeteventStatus(this)) : null;
    }

    public void setEventStatus(SLAEvent.EventStatus eventStatus) {
        SLASummaryBean.pcSeteventStatus(this, eventStatus != null ? eventStatus.name() : null);
    }

    public SLAEvent.SLAStatus getSLAStatus() {
        return SLASummaryBean.pcGetslaStatus(this) != null ? SLAEvent.SLAStatus.valueOf((String)SLASummaryBean.pcGetslaStatus(this)) : null;
    }

    public String getSLAStatusString() {
        return SLASummaryBean.pcGetslaStatus(this);
    }

    public String getEventStatusString() {
        return SLASummaryBean.pcGeteventStatus(this);
    }

    public void setSLAStatus(SLAEvent.SLAStatus stage) {
        SLASummaryBean.pcSetslaStatus(this, stage != null ? stage.name() : null);
    }

    public String getUser() {
        return SLASummaryBean.pcGetuser(this);
    }

    public void setUser(String user) {
        SLASummaryBean.pcSetuser(this, user);
    }

    public String getAppName() {
        return SLASummaryBean.pcGetappName(this);
    }

    public void setAppName(String appName) {
        SLASummaryBean.pcSetappName(this, appName);
    }

    public AppType getAppType() {
        return AppType.valueOf((String)SLASummaryBean.pcGetappType(this));
    }

    public void setAppType(AppType appType) {
        SLASummaryBean.pcSetappType(this, appType.toString());
    }

    public byte getEventProcessed() {
        return SLASummaryBean.pcGeteventProcessed(this);
    }

    public void setEventProcessed(int eventProcessed) {
        SLASummaryBean.pcSeteventProcessed(this, (byte)eventProcessed);
    }

    public Date getLastModifiedTime() {
        return DateUtils.toDate(SLASummaryBean.pcGetlastModifiedTS(this));
    }

    public Timestamp getLastModifiedTimestamp() {
        return SLASummaryBean.pcGetlastModifiedTS(this);
    }

    public void setLastModifiedTime(Date lastModified) {
        SLASummaryBean.pcSetlastModifiedTS(this, DateUtils.convertDateToTimestamp(lastModified));
    }

    @Override
    public JSONObject toJSONObject() {
        return this.toJSONObject(null);
    }

    @Override
    public JSONObject toJSONObject(String timeZoneId) {
        Long durationDelay;
        Long endDelay;
        Long startDelay;
        JSONObject json = new JSONObject();
        Map<SLAEvent.EventStatus, Long> eventMap = this.calculateEventStatus();
        StringBuilder eventStatusStr = new StringBuilder();
        boolean first = true;
        for (SLAEvent.EventStatus e : eventMap.keySet()) {
            if (!first) {
                eventStatusStr.append(",");
            }
            eventStatusStr.append(e.toString());
            first = false;
        }
        json.put((Object)"id", (Object)SLASummaryBean.pcGetjobId(this));
        if (SLASummaryBean.pcGetparentId(this) != null) {
            json.put((Object)"parentId", (Object)SLASummaryBean.pcGetparentId(this));
        }
        json.put((Object)"appName", (Object)SLASummaryBean.pcGetappName(this));
        json.put((Object)"appType", (Object)SLASummaryBean.pcGetappType(this));
        json.put((Object)"user", (Object)SLASummaryBean.pcGetuser(this));
        json.put((Object)"nominalTime", this.getTimeOnTimeZone(SLASummaryBean.pcGetnominalTimeTS(this), timeZoneId));
        if (SLASummaryBean.pcGetexpectedStartTS(this) != null) {
            json.put((Object)"expectedStart", this.getTimeOnTimeZone(SLASummaryBean.pcGetexpectedStartTS(this), timeZoneId));
        } else {
            json.put((Object)"expectedStart", null);
        }
        if (SLASummaryBean.pcGetactualStartTS(this) != null) {
            json.put((Object)"actualStart", this.getTimeOnTimeZone(SLASummaryBean.pcGetactualStartTS(this), timeZoneId));
        } else {
            json.put((Object)"actualStart", null);
        }
        Long l = startDelay = eventMap.get(SLAEvent.EventStatus.START_MET) != null ? eventMap.get(SLAEvent.EventStatus.START_MET) : eventMap.get(SLAEvent.EventStatus.START_MISS);
        if (startDelay != null) {
            json.put((Object)"startDelay", (Object)startDelay);
        }
        if (SLASummaryBean.pcGetexpectedEndTS(this) != null) {
            json.put((Object)"expectedEnd", this.getTimeOnTimeZone(SLASummaryBean.pcGetexpectedEndTS(this), timeZoneId));
        } else {
            json.put((Object)"actualEnd", null);
        }
        if (SLASummaryBean.pcGetactualEndTS(this) != null) {
            json.put((Object)"actualEnd", this.getTimeOnTimeZone(SLASummaryBean.pcGetactualEndTS(this), timeZoneId));
        } else {
            json.put((Object)"actualEnd", null);
        }
        Long l2 = endDelay = eventMap.get(SLAEvent.EventStatus.END_MET) != null ? eventMap.get(SLAEvent.EventStatus.END_MET) : eventMap.get(SLAEvent.EventStatus.END_MISS);
        if (endDelay != null) {
            json.put((Object)"endDelay", (Object)endDelay);
        }
        json.put((Object)"expectedDuration", (Object)SLASummaryBean.pcGetexpectedDuration(this));
        if (SLASummaryBean.pcGetactualDuration(this) == -1L && SLASummaryBean.pcGetexpectedDuration(this) != -1L && SLASummaryBean.pcGetactualStartTS(this) != null) {
            long currentDur = (new Date().getTime() - SLASummaryBean.pcGetactualStartTS(this).getTime()) / 60000L;
            json.put((Object)"actualDuration", (Object)currentDur);
        } else {
            json.put((Object)"actualDuration", (Object)SLASummaryBean.pcGetactualDuration(this));
        }
        Long l3 = durationDelay = eventMap.get(SLAEvent.EventStatus.DURATION_MET) != null ? eventMap.get(SLAEvent.EventStatus.DURATION_MET) : eventMap.get(SLAEvent.EventStatus.DURATION_MISS);
        if (durationDelay != null) {
            json.put((Object)"durationDelay", (Object)durationDelay);
        }
        json.put((Object)"jobStatus", (Object)SLASummaryBean.pcGetjobStatus(this));
        json.put((Object)"slaStatus", (Object)SLASummaryBean.pcGetslaStatus(this));
        json.put((Object)"eventStatus", (Object)eventStatusStr.toString());
        json.put((Object)"lastModified", this.getTimeOnTimeZone(SLASummaryBean.pcGetlastModifiedTS(this), timeZoneId));
        return json;
    }

    private Object getTimeOnTimeZone(Timestamp ts, String timeZoneId) {
        Object ret = null;
        ret = timeZoneId == null ? new Long(String.valueOf(ts.getTime())) : JsonUtils.formatDateRfc822((Date)ts, (String)timeZoneId);
        return ret;
    }

    private Map<SLAEvent.EventStatus, Long> calculateEventStatus() {
        long diff;
        HashMap<SLAEvent.EventStatus, Long> events = new HashMap<SLAEvent.EventStatus, Long>();
        if (SLASummaryBean.pcGetexpectedStartTS(this) != null) {
            if (SLASummaryBean.pcGetactualStartTS(this) != null) {
                diff = (SLASummaryBean.pcGetactualStartTS(this).getTime() - SLASummaryBean.pcGetexpectedStartTS(this).getTime()) / 60000L;
                if (diff > 0L) {
                    events.put(SLAEvent.EventStatus.START_MISS, diff);
                } else {
                    events.put(SLAEvent.EventStatus.START_MET, diff);
                }
            } else {
                diff = (new Date().getTime() - SLASummaryBean.pcGetexpectedStartTS(this).getTime()) / 60000L;
                if (diff > 0L) {
                    events.put(SLAEvent.EventStatus.START_MISS, diff);
                }
            }
        }
        if (SLASummaryBean.pcGetexpectedDuration(this) != -1L) {
            if (SLASummaryBean.pcGetactualDuration(this) != -1L) {
                diff = SLASummaryBean.pcGetactualDuration(this) - SLASummaryBean.pcGetexpectedDuration(this);
                if (diff > 0L) {
                    events.put(SLAEvent.EventStatus.DURATION_MISS, diff);
                } else {
                    events.put(SLAEvent.EventStatus.DURATION_MET, diff);
                }
            } else if (SLASummaryBean.pcGetactualStartTS(this) != null) {
                long currentDur = (new Date().getTime() - SLASummaryBean.pcGetactualStartTS(this).getTime()) / 60000L;
                if (SLASummaryBean.pcGetexpectedDuration(this) < currentDur) {
                    events.put(SLAEvent.EventStatus.DURATION_MISS, currentDur - SLASummaryBean.pcGetexpectedDuration(this));
                }
            }
        }
        if (SLASummaryBean.pcGetexpectedEndTS(this) != null) {
            if (SLASummaryBean.pcGetactualEndTS(this) != null) {
                diff = (SLASummaryBean.pcGetactualEndTS(this).getTime() - SLASummaryBean.pcGetexpectedEndTS(this).getTime()) / 60000L;
                if (diff > 0L) {
                    events.put(SLAEvent.EventStatus.END_MISS, diff);
                } else {
                    events.put(SLAEvent.EventStatus.END_MET, diff);
                }
            } else {
                diff = (new Date().getTime() - SLASummaryBean.pcGetexpectedEndTS(this).getTime()) / 60000L;
                if (diff > 0L) {
                    events.put(SLAEvent.EventStatus.END_MISS, diff);
                }
            }
        }
        return events;
    }

    public static JSONObject toJSONObject(List<? extends SLASummaryBean> slaSummaryList, String timeZoneId) {
        JSONObject json = new JSONObject();
        JSONArray array = new JSONArray();
        if (slaSummaryList != null) {
            for (SLASummaryBean sLASummaryBean : slaSummaryList) {
                array.add((Object)sLASummaryBean.toJSONObject(timeZoneId));
            }
        }
        json.put((Object)"slaSummaryList", (Object)array);
        return json;
    }

    public static JSONObject toJSONObject(List<? extends SLASummaryBean> slaSummaryList, Map<String, Map<String, String>> slaConfigMap, String timeZoneId) {
        JSONObject json = new JSONObject();
        JSONArray array = new JSONArray();
        if (slaSummaryList != null) {
            for (SLASummaryBean sLASummaryBean : slaSummaryList) {
                JSONObject slaJson = sLASummaryBean.toJSONObject(timeZoneId);
                String slaAlertStatus = "";
                if (slaConfigMap.containsKey(sLASummaryBean.getId())) {
                    slaAlertStatus = slaConfigMap.get(sLASummaryBean.getId()).containsKey("oozie.sla.disable.alerts") ? "Disabled" : "Enabled";
                }
                slaJson.put((Object)"slaAlertStatus", (Object)slaAlertStatus);
                array.add((Object)slaJson);
            }
        }
        json.put((Object)"slaSummaryList", (Object)array);
        return json;
    }

    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        pcFieldNames = new String[]{"actualDuration", "actualEndTS", "actualStartTS", "appName", "appType", "createdTimeTS", "eventProcessed", "eventStatus", "expectedDuration", "expectedEndTS", "expectedStartTS", "jobId", "jobStatus", "lastModifiedTS", "nominalTimeTS", "parentId", "slaStatus", "user"};
        Class[] classArray = new Class[18];
        classArray[0] = Long.TYPE;
        Class clazz = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = SLASummaryBean.class$("java.sql.Timestamp"));
        classArray[1] = clazz;
        classArray[2] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = SLASummaryBean.class$("java.sql.Timestamp"));
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SLASummaryBean.class$("java.lang.String"));
        classArray[3] = clazz2;
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SLASummaryBean.class$("java.lang.String"));
        classArray[5] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = SLASummaryBean.class$("java.sql.Timestamp"));
        classArray[6] = Byte.TYPE;
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SLASummaryBean.class$("java.lang.String"));
        classArray[8] = Long.TYPE;
        classArray[9] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = SLASummaryBean.class$("java.sql.Timestamp"));
        classArray[10] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = SLASummaryBean.class$("java.sql.Timestamp"));
        classArray[11] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SLASummaryBean.class$("java.lang.String"));
        classArray[12] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SLASummaryBean.class$("java.lang.String"));
        classArray[13] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = SLASummaryBean.class$("java.sql.Timestamp"));
        classArray[14] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = SLASummaryBean.class$("java.sql.Timestamp"));
        classArray[15] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SLASummaryBean.class$("java.lang.String"));
        classArray[16] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SLASummaryBean.class$("java.lang.String"));
        classArray[17] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SLASummaryBean.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz3 = class$Lorg$apache$oozie$sla$SLASummaryBean != null ? class$Lorg$apache$oozie$sla$SLASummaryBean : (class$Lorg$apache$oozie$sla$SLASummaryBean = SLASummaryBean.class$("org.apache.oozie.sla.SLASummaryBean"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"SLASummaryBean", (PersistenceCapable)new SLASummaryBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.actualDuration = 0L;
        this.actualEndTS = null;
        this.actualStartTS = null;
        this.appName = null;
        this.appType = null;
        this.createdTimeTS = null;
        this.eventProcessed = 0;
        this.eventStatus = null;
        this.expectedDuration = 0L;
        this.expectedEndTS = null;
        this.expectedStartTS = null;
        this.jobId = null;
        this.jobStatus = null;
        this.lastModifiedTS = null;
        this.nominalTimeTS = null;
        this.parentId = null;
        this.slaStatus = null;
        this.user = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        SLASummaryBean sLASummaryBean = new SLASummaryBean();
        if (bl) {
            sLASummaryBean.pcClearFields();
        }
        sLASummaryBean.pcStateManager = stateManager;
        sLASummaryBean.pcCopyKeyFieldsFromObjectId(object);
        return sLASummaryBean;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        SLASummaryBean sLASummaryBean = new SLASummaryBean();
        if (bl) {
            sLASummaryBean.pcClearFields();
        }
        sLASummaryBean.pcStateManager = stateManager;
        return sLASummaryBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 18;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.actualDuration = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.actualEndTS = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.actualStartTS = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.appName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.appType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.createdTimeTS = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.eventProcessed = this.pcStateManager.replaceByteField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.eventStatus = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.expectedDuration = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.expectedEndTS = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.expectedStartTS = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.jobId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.jobStatus = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.lastModifiedTS = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.nominalTimeTS = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.parentId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.slaStatus = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.user = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.actualDuration);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.actualEndTS);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.actualStartTS);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appName);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appType);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createdTimeTS);
                return;
            }
            case 6: {
                this.pcStateManager.providedByteField((PersistenceCapable)this, n, this.eventProcessed);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.eventStatus);
                return;
            }
            case 8: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.expectedDuration);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.expectedEndTS);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.expectedStartTS);
                return;
            }
            case 11: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.jobId);
                return;
            }
            case 12: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.jobStatus);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastModifiedTS);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.nominalTimeTS);
                return;
            }
            case 15: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.parentId);
                return;
            }
            case 16: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.slaStatus);
                return;
            }
            case 17: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.user);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(SLASummaryBean sLASummaryBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.actualDuration = sLASummaryBean.actualDuration;
                return;
            }
            case 1: {
                this.actualEndTS = sLASummaryBean.actualEndTS;
                return;
            }
            case 2: {
                this.actualStartTS = sLASummaryBean.actualStartTS;
                return;
            }
            case 3: {
                this.appName = sLASummaryBean.appName;
                return;
            }
            case 4: {
                this.appType = sLASummaryBean.appType;
                return;
            }
            case 5: {
                this.createdTimeTS = sLASummaryBean.createdTimeTS;
                return;
            }
            case 6: {
                this.eventProcessed = sLASummaryBean.eventProcessed;
                return;
            }
            case 7: {
                this.eventStatus = sLASummaryBean.eventStatus;
                return;
            }
            case 8: {
                this.expectedDuration = sLASummaryBean.expectedDuration;
                return;
            }
            case 9: {
                this.expectedEndTS = sLASummaryBean.expectedEndTS;
                return;
            }
            case 10: {
                this.expectedStartTS = sLASummaryBean.expectedStartTS;
                return;
            }
            case 11: {
                this.jobId = sLASummaryBean.jobId;
                return;
            }
            case 12: {
                this.jobStatus = sLASummaryBean.jobStatus;
                return;
            }
            case 13: {
                this.lastModifiedTS = sLASummaryBean.lastModifiedTS;
                return;
            }
            case 14: {
                this.nominalTimeTS = sLASummaryBean.nominalTimeTS;
                return;
            }
            case 15: {
                this.parentId = sLASummaryBean.parentId;
                return;
            }
            case 16: {
                this.slaStatus = sLASummaryBean.slaStatus;
                return;
            }
            case 17: {
                this.user = sLASummaryBean.user;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        SLASummaryBean sLASummaryBean = (SLASummaryBean)object;
        if (sLASummaryBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(sLASummaryBean, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(11 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.jobId = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$oozie$sla$SLASummaryBean != null ? class$Lorg$apache$oozie$sla$SLASummaryBean : (class$Lorg$apache$oozie$sla$SLASummaryBean = SLASummaryBean.class$("org.apache.oozie.sla.SLASummaryBean"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$oozie$sla$SLASummaryBean != null ? class$Lorg$apache$oozie$sla$SLASummaryBean : (class$Lorg$apache$oozie$sla$SLASummaryBean = SLASummaryBean.class$("org.apache.oozie.sla.SLASummaryBean"));
        return new StringId(clazz, this.jobId);
    }

    private static final long pcGetactualDuration(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.actualDuration;
        }
        int n = pcInheritedFieldCount + 0;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.actualDuration;
    }

    private static final void pcSetactualDuration(SLASummaryBean sLASummaryBean, long l) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.actualDuration = l;
            return;
        }
        sLASummaryBean.pcStateManager.settingLongField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 0, sLASummaryBean.actualDuration, l, 0);
    }

    private static final Timestamp pcGetactualEndTS(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.actualEndTS;
        }
        int n = pcInheritedFieldCount + 1;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.actualEndTS;
    }

    private static final void pcSetactualEndTS(SLASummaryBean sLASummaryBean, Timestamp timestamp) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.actualEndTS = timestamp;
            return;
        }
        sLASummaryBean.pcStateManager.settingObjectField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 1, (Object)sLASummaryBean.actualEndTS, (Object)timestamp, 0);
    }

    private static final Timestamp pcGetactualStartTS(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.actualStartTS;
        }
        int n = pcInheritedFieldCount + 2;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.actualStartTS;
    }

    private static final void pcSetactualStartTS(SLASummaryBean sLASummaryBean, Timestamp timestamp) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.actualStartTS = timestamp;
            return;
        }
        sLASummaryBean.pcStateManager.settingObjectField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 2, (Object)sLASummaryBean.actualStartTS, (Object)timestamp, 0);
    }

    private static final String pcGetappName(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.appName;
        }
        int n = pcInheritedFieldCount + 3;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.appName;
    }

    private static final void pcSetappName(SLASummaryBean sLASummaryBean, String string) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.appName = string;
            return;
        }
        sLASummaryBean.pcStateManager.settingStringField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 3, sLASummaryBean.appName, string, 0);
    }

    private static final String pcGetappType(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.appType;
        }
        int n = pcInheritedFieldCount + 4;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.appType;
    }

    private static final void pcSetappType(SLASummaryBean sLASummaryBean, String string) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.appType = string;
            return;
        }
        sLASummaryBean.pcStateManager.settingStringField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 4, sLASummaryBean.appType, string, 0);
    }

    private static final Timestamp pcGetcreatedTimeTS(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.createdTimeTS;
        }
        int n = pcInheritedFieldCount + 5;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.createdTimeTS;
    }

    private static final void pcSetcreatedTimeTS(SLASummaryBean sLASummaryBean, Timestamp timestamp) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.createdTimeTS = timestamp;
            return;
        }
        sLASummaryBean.pcStateManager.settingObjectField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 5, (Object)sLASummaryBean.createdTimeTS, (Object)timestamp, 0);
    }

    private static final byte pcGeteventProcessed(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.eventProcessed;
        }
        int n = pcInheritedFieldCount + 6;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.eventProcessed;
    }

    private static final void pcSeteventProcessed(SLASummaryBean sLASummaryBean, byte by) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.eventProcessed = by;
            return;
        }
        sLASummaryBean.pcStateManager.settingByteField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 6, sLASummaryBean.eventProcessed, by, 0);
    }

    private static final String pcGeteventStatus(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.eventStatus;
        }
        int n = pcInheritedFieldCount + 7;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.eventStatus;
    }

    private static final void pcSeteventStatus(SLASummaryBean sLASummaryBean, String string) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.eventStatus = string;
            return;
        }
        sLASummaryBean.pcStateManager.settingStringField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 7, sLASummaryBean.eventStatus, string, 0);
    }

    private static final long pcGetexpectedDuration(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.expectedDuration;
        }
        int n = pcInheritedFieldCount + 8;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.expectedDuration;
    }

    private static final void pcSetexpectedDuration(SLASummaryBean sLASummaryBean, long l) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.expectedDuration = l;
            return;
        }
        sLASummaryBean.pcStateManager.settingLongField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 8, sLASummaryBean.expectedDuration, l, 0);
    }

    private static final Timestamp pcGetexpectedEndTS(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.expectedEndTS;
        }
        int n = pcInheritedFieldCount + 9;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.expectedEndTS;
    }

    private static final void pcSetexpectedEndTS(SLASummaryBean sLASummaryBean, Timestamp timestamp) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.expectedEndTS = timestamp;
            return;
        }
        sLASummaryBean.pcStateManager.settingObjectField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 9, (Object)sLASummaryBean.expectedEndTS, (Object)timestamp, 0);
    }

    private static final Timestamp pcGetexpectedStartTS(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.expectedStartTS;
        }
        int n = pcInheritedFieldCount + 10;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.expectedStartTS;
    }

    private static final void pcSetexpectedStartTS(SLASummaryBean sLASummaryBean, Timestamp timestamp) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.expectedStartTS = timestamp;
            return;
        }
        sLASummaryBean.pcStateManager.settingObjectField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 10, (Object)sLASummaryBean.expectedStartTS, (Object)timestamp, 0);
    }

    private static final String pcGetjobId(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.jobId;
        }
        int n = pcInheritedFieldCount + 11;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.jobId;
    }

    private static final void pcSetjobId(SLASummaryBean sLASummaryBean, String string) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.jobId = string;
            return;
        }
        sLASummaryBean.pcStateManager.settingStringField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 11, sLASummaryBean.jobId, string, 0);
    }

    private static final String pcGetjobStatus(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.jobStatus;
        }
        int n = pcInheritedFieldCount + 12;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.jobStatus;
    }

    private static final void pcSetjobStatus(SLASummaryBean sLASummaryBean, String string) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.jobStatus = string;
            return;
        }
        sLASummaryBean.pcStateManager.settingStringField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 12, sLASummaryBean.jobStatus, string, 0);
    }

    private static final Timestamp pcGetlastModifiedTS(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.lastModifiedTS;
        }
        int n = pcInheritedFieldCount + 13;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.lastModifiedTS;
    }

    private static final void pcSetlastModifiedTS(SLASummaryBean sLASummaryBean, Timestamp timestamp) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.lastModifiedTS = timestamp;
            return;
        }
        sLASummaryBean.pcStateManager.settingObjectField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 13, (Object)sLASummaryBean.lastModifiedTS, (Object)timestamp, 0);
    }

    private static final Timestamp pcGetnominalTimeTS(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.nominalTimeTS;
        }
        int n = pcInheritedFieldCount + 14;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.nominalTimeTS;
    }

    private static final void pcSetnominalTimeTS(SLASummaryBean sLASummaryBean, Timestamp timestamp) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.nominalTimeTS = timestamp;
            return;
        }
        sLASummaryBean.pcStateManager.settingObjectField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 14, (Object)sLASummaryBean.nominalTimeTS, (Object)timestamp, 0);
    }

    private static final String pcGetparentId(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.parentId;
        }
        int n = pcInheritedFieldCount + 15;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.parentId;
    }

    private static final void pcSetparentId(SLASummaryBean sLASummaryBean, String string) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.parentId = string;
            return;
        }
        sLASummaryBean.pcStateManager.settingStringField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 15, sLASummaryBean.parentId, string, 0);
    }

    private static final String pcGetslaStatus(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.slaStatus;
        }
        int n = pcInheritedFieldCount + 16;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.slaStatus;
    }

    private static final void pcSetslaStatus(SLASummaryBean sLASummaryBean, String string) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.slaStatus = string;
            return;
        }
        sLASummaryBean.pcStateManager.settingStringField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 16, sLASummaryBean.slaStatus, string, 0);
    }

    private static final String pcGetuser(SLASummaryBean sLASummaryBean) {
        if (sLASummaryBean.pcStateManager == null) {
            return sLASummaryBean.user;
        }
        int n = pcInheritedFieldCount + 17;
        sLASummaryBean.pcStateManager.accessingField(n);
        return sLASummaryBean.user;
    }

    private static final void pcSetuser(SLASummaryBean sLASummaryBean, String string) {
        if (sLASummaryBean.pcStateManager == null) {
            sLASummaryBean.user = string;
            return;
        }
        sLASummaryBean.pcStateManager.settingStringField((PersistenceCapable)sLASummaryBean, pcInheritedFieldCount + 17, sLASummaryBean.user, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

