/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.repository2.unified;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RepositoryFile
implements Comparable<RepositoryFile>,
Serializable {
    private static final long serialVersionUID = -6955142003557786114L;
    public static final String SEPARATOR = "/";
    public static final String DEFAULT_LOCALE = "default";
    public static final String ROOT_LOCALE = "default";
    public static final String TITLE = "title";
    public static final String FILE_TITLE = "file.title";
    public static final String DESCRIPTION = "description";
    public static final String FILE_DESCRIPTION = "file.description";
    public static final boolean HIDDEN_BY_DEFAULT = false;
    public static final boolean SCHEDULABLE_BY_DEFAULT = true;
    public static final String HIDDEN_KEY = "_PERM_HIDDEN";
    public static final String SCHEDULABLE_KEY = "_PERM_SCHEDULABLE";
    private final String name;
    private final Serializable id;
    private final Date createdDate;
    private final String creatorId;
    private final Date lastModifiedDate;
    private final boolean folder;
    private final String path;
    private final Boolean hidden;
    private final Boolean schedulable;
    private final boolean versioned;
    private final long fileSize;
    private final Serializable versionId;
    private final boolean locked;
    private final String lockOwner;
    private final String lockMessage;
    private final Date lockDate;
    private final String title;
    private final String description;
    private final String locale;
    private final String originalParentFolderPath;
    private final Date deletedDate;
    private final Map<String, Properties> localePropertiesMap;
    private final boolean aclNode;

    public RepositoryFile(Serializable id, String name, boolean folder, Boolean hidden, Boolean schedulable, boolean versioned, Serializable versionId, String path, Date createdDate, Date lastModifiedDate, boolean locked, String lockOwner, String lockMessage, Date lockDate, String locale, String title, String description, String originalParentFolderPath, Date deletedDate, long fileSize, String creatorId, Map<String, Properties> localePropertiesMap, boolean aclNode) {
        this.id = id;
        this.name = name;
        this.folder = folder;
        this.hidden = hidden;
        this.schedulable = schedulable;
        this.versioned = versioned;
        this.versionId = versionId;
        this.path = path;
        this.createdDate = createdDate != null ? new Date(createdDate.getTime()) : null;
        this.lastModifiedDate = lastModifiedDate != null ? new Date(lastModifiedDate.getTime()) : null;
        this.locked = locked;
        this.lockOwner = lockOwner;
        this.lockMessage = lockMessage;
        this.lockDate = lockDate != null ? new Date(lockDate.getTime()) : null;
        this.locale = locale;
        this.title = title;
        this.description = description;
        this.originalParentFolderPath = originalParentFolderPath;
        this.deletedDate = deletedDate != null ? new Date(deletedDate.getTime()) : null;
        this.fileSize = fileSize;
        this.creatorId = creatorId;
        this.localePropertiesMap = localePropertiesMap != null ? new HashMap<String, Properties>(localePropertiesMap) : null;
        this.aclNode = aclNode;
    }

    public RepositoryFile(Serializable id, String name, boolean folder, Boolean hidden, Boolean schedulable, boolean versioned, Serializable versionId, String path, Date createdDate, Date lastModifiedDate, boolean locked, String lockOwner, String lockMessage, Date lockDate, String locale, String title, String description, String originalParentFolderPath, Date deletedDate, long fileSize, String creatorId, Map<String, Properties> localePropertiesMap) {
        this(id, name, folder, hidden, schedulable, versioned, versionId, path, createdDate, lastModifiedDate, locked, lockOwner, lockMessage, lockDate, locale, title, description, originalParentFolderPath, deletedDate, fileSize, creatorId, localePropertiesMap, false);
    }

    @Deprecated
    public RepositoryFile(Serializable id, String name, boolean folder, Boolean hidden, boolean versioned, Serializable versionId, String path, Date createdDate, Date lastModifiedDate, boolean locked, String lockOwner, String lockMessage, Date lockDate, String locale, String title, String description, String originalParentFolderPath, Date deletedDate, long fileSize, String creatorId, Map<String, Properties> localePropertiesMap) {
        this(id, name, folder, hidden, true, versioned, versionId, path, createdDate, lastModifiedDate, locked, lockOwner, lockMessage, lockDate, locale, title, description, originalParentFolderPath, deletedDate, fileSize, creatorId, localePropertiesMap, false);
    }

    public String getName() {
        return this.name;
    }

    public Serializable getId() {
        return this.id;
    }

    public Date getCreatedDate() {
        return this.createdDate != null ? new Date(this.createdDate.getTime()) : null;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate != null ? new Date(this.lastModifiedDate.getTime()) : null;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public boolean isFolder() {
        return this.folder;
    }

    public String getPath() {
        return this.path;
    }

    public Boolean isHidden() {
        return this.hidden;
    }

    public Boolean isSchedulable() {
        return this.schedulable;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public Serializable getVersionId() {
        return this.versionId;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public String getLockMessage() {
        return this.lockMessage;
    }

    public Date getLockDate() {
        return this.lockDate != null ? new Date(this.lockDate.getTime()) : null;
    }

    public String getTitle() {
        return this.title != null ? this.title : this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Properties> getLocalePropertiesMap() {
        return this.localePropertiesMap == null ? null : new HashMap<String, Properties>(this.localePropertiesMap);
    }

    public String getLocale() {
        return this.locale;
    }

    public String getOriginalParentFolderPath() {
        return this.originalParentFolderPath;
    }

    public Date getDeletedDate() {
        return this.deletedDate != null ? new Date(this.deletedDate.getTime()) : null;
    }

    public boolean isAclNode() {
        return this.aclNode;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public int compareTo(RepositoryFile other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this.equals(other)) {
            return 0;
        }
        return this.getTitle().compareTo(other.getTitle());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.versionId == null ? 0 : this.versionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryFile other = (RepositoryFile)obj;
        if (this.id == null) {
            if (other.id != null) {
                return false;
            }
            if (this.path != null && !other.path.equals(this.path)) {
                return false;
            }
        } else if (!this.id.equals(other.id)) {
            return false;
        }
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        return !(this.versionId == null ? other.versionId != null : !this.versionId.equals(other.versionId));
    }

    public RepositoryFile clone() {
        Builder builder = new Builder(this);
        builder.localePropertiesMap((Map<String, Properties>)(this.localePropertiesMap != null ? new HashMap<String, Properties>(this.localePropertiesMap) : null));
        return builder.build();
    }

    public static class Builder {
        private String name;
        private Serializable id;
        private Date createdDate;
        private String creatorId;
        private Date lastModifiedDate;
        private long fileSize;
        private boolean folder;
        private String path;
        private boolean hidden = false;
        private boolean schedulable = true;
        private boolean versioned;
        private Serializable versionId;
        private boolean locked;
        private String lockOwner;
        private String lockMessage;
        private Date lockDate;
        private String title;
        private String description;
        private Map<String, Properties> localePropertiesMap;
        private String locale;
        private String originalParentFolderPath;
        private Date deletedDate;
        private boolean aclNode;

        public Builder(String name) {
            this.name = name;
        }

        public Builder(Serializable id, String name) {
            this.notNull(id);
            this.name = name;
            this.id = id;
        }

        public Builder(RepositoryFile other) {
            this(other.getName());
            this.id(other.getId()).path(other.getPath()).createdDate(other.getCreatedDate()).creatorId(other.getCreatorId()).fileSize(other.getFileSize()).folder(other.isFolder()).lastModificationDate(other.getLastModifiedDate()).versioned(other.isVersioned()).hidden(other.isHidden()).schedulable(other.isSchedulable()).versionId(other.getVersionId()).locked(other.isLocked()).lockDate(other.getLockDate()).lockOwner(other.getLockOwner()).lockMessage(other.getLockMessage()).title(other.getTitle()).description(other.getDescription()).locale(other.getLocale()).originalParentFolderPath(other.getOriginalParentFolderPath()).deletedDate(other.getDeletedDate()).localePropertiesMap(other.getLocalePropertiesMap()).aclNode(other.isAclNode());
        }

        public RepositoryFile build() {
            return new RepositoryFile(this.id, this.name, this.folder, this.hidden, this.schedulable, this.versioned, this.versionId, this.path, this.createdDate, this.lastModifiedDate, this.locked, this.lockOwner, this.lockMessage, this.lockDate, this.locale, this.title, this.description, this.originalParentFolderPath, this.deletedDate, this.fileSize, this.creatorId, this.localePropertiesMap, this.aclNode);
        }

        public Builder createdDate(Date createdDate1) {
            this.createdDate = createdDate1;
            return this;
        }

        public Builder creatorId(String creatorId1) {
            this.creatorId = creatorId1;
            return this;
        }

        public Builder lastModificationDate(Date lastModifiedDate1) {
            this.lastModifiedDate = lastModifiedDate1;
            return this;
        }

        public Builder fileSize(long fileSize1) {
            this.fileSize = fileSize1;
            return this;
        }

        public Builder folder(boolean folder1) {
            this.folder = folder1;
            return this;
        }

        public Builder id(Serializable id1) {
            this.id = id1;
            return this;
        }

        public Builder name(String name1) {
            this.name = name1;
            return this;
        }

        public Builder path(String path1) {
            this.path = path1;
            return this;
        }

        public Builder hidden(boolean hidden1) {
            this.hidden = hidden1;
            return this;
        }

        public Builder schedulable(boolean schedulable1) {
            this.schedulable = schedulable1;
            return this;
        }

        public Builder versioned(boolean versioned1) {
            this.versioned = versioned1;
            return this;
        }

        public Builder versionId(Serializable versionId1) {
            this.versionId = versionId1;
            return this;
        }

        public Builder locked(boolean locked1) {
            this.locked = locked1;
            return this;
        }

        public Builder lockOwner(String lockOwner1) {
            this.lockOwner = lockOwner1;
            return this;
        }

        public Builder lockMessage(String lockMessage1) {
            this.lockMessage = lockMessage1;
            return this;
        }

        public Builder lockDate(Date lockDate1) {
            this.lockDate = lockDate1;
            return this;
        }

        public Builder originalParentFolderPath(String originalParentFolderPath1) {
            this.originalParentFolderPath = originalParentFolderPath1;
            return this;
        }

        public Builder deletedDate(Date deletedDate1) {
            this.deletedDate = deletedDate1;
            return this;
        }

        public Builder title(String title1) {
            this.title = title1;
            return this;
        }

        public Builder description(String description1) {
            this.description = description1;
            return this;
        }

        public Builder localePropertiesMap(Map<String, Properties> localePropertiesMap) {
            this.localePropertiesMap = localePropertiesMap;
            if (this.localePropertiesMap != null && !this.localePropertiesMap.containsKey("default")) {
                this.localePropertiesMap.put("default", new Properties());
            }
            return this;
        }

        public Builder clearLocalePropertiesMap() {
            if (this.localePropertiesMap != null) {
                this.localePropertiesMap.clear();
                this.localePropertiesMap.put("default", new Properties());
            }
            return this;
        }

        public Builder localeProperties(String locale, Properties localeProperties) {
            this.initLocalePropertiesMap();
            this.localePropertiesMap.put(locale, localeProperties);
            return this;
        }

        private void initLocalePropertiesMap() {
            if (this.localePropertiesMap == null) {
                this.localePropertiesMap = new HashMap<String, Properties>();
                this.localePropertiesMap.put("default", new Properties());
            }
        }

        public Builder title(String localeString, String title1) {
            this.initLocalePropertiesMap();
            Properties properties = this.localePropertiesMap.get(localeString);
            if (properties == null) {
                properties = new Properties();
            }
            properties.put(RepositoryFile.FILE_TITLE, title1);
            properties.put(RepositoryFile.TITLE, title1);
            this.localePropertiesMap.put(localeString, properties);
            return this;
        }

        public Builder description(String localeString, String description1) {
            this.initLocalePropertiesMap();
            Properties properties = this.localePropertiesMap.get(localeString);
            if (properties == null) {
                properties = new Properties();
            }
            properties.put(RepositoryFile.FILE_DESCRIPTION, description1);
            properties.put(RepositoryFile.DESCRIPTION, description1);
            this.localePropertiesMap.put(localeString, properties);
            return this;
        }

        public Builder locale(String locale1) {
            this.locale = locale1;
            return this;
        }

        public Builder aclNode(boolean aclNode1) {
            this.aclNode = aclNode1;
            return this;
        }

        private void notNull(Object in) {
            if (in == null) {
                throw new IllegalArgumentException();
            }
        }
    }
}

