/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.outputs;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.output.FileContentItem;
import org.pentaho.platform.engine.services.outputhandler.BaseOutputHandler;
import org.pentaho.platform.plugin.services.messages.Messages;

public class FileOutputHandler
extends BaseOutputHandler {
    protected static final Log logger = LogFactory.getLog(FileOutputHandler.class);

    public IContentItem getFileOutputContentItem() {
        boolean result;
        String contentRef = this.getContentRef();
        File file = new File(contentRef);
        File dir = file.getParentFile();
        if (dir != null && !dir.exists() && !(result = dir.mkdirs())) {
            try {
                URI uri = new URI(contentRef);
                file = new File(uri);
                dir = file.getParentFile();
            }
            catch (URISyntaxException e) {
                logger.error((Object)Messages.getInstance().getErrorString("FileOutputHandler.ERROR_0001_COULD_NOT_CREATE_DIRECTORY", new Object[]{dir.getAbsolutePath()}));
                return null;
            }
        }
        try {
            FileContentItem content = new FileContentItem(file);
            return content;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)Messages.getInstance().getErrorString("FileOutputHandler.ERROR_0002_COULD_NOT_CREATE_OUTPUT_FILE", new Object[]{file.getAbsolutePath()}), (Throwable)e);
            return null;
        }
    }
}

