/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.web.MimeHelper;
import org.pentaho.platform.web.http.messages.Messages;

@Path(value="/plugins/{pluginId}")
public class PluginResource {
    private static final String CACHE_FILE = "file";
    private static ICacheManager cache = PentahoSystem.getCacheManager(null);
    protected File systemFolder;
    protected IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
    private static final Log logger = LogFactory.getLog(PluginResource.class);
    protected IPluginManager pluginMgr = (IPluginManager)PentahoSystem.get(IPluginManager.class);
    @Context
    protected HttpServletResponse httpServletResponse;

    public PluginResource() {
        this.systemFolder = new File(PentahoSystem.getApplicationContext().getSolutionRootPath(), "system");
    }

    public PluginResource(HttpServletResponse httpServletResponse) {
        this();
        this.httpServletResponse = httpServletResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getCacheBackedStream(String pluginId, String path, boolean useCache) throws IOException {
        byte[] bytes;
        InputStream inputStream = null;
        String canonicalPath = pluginId + "/" + path;
        if (useCache && (bytes = (byte[])cache.getFromRegionCache(CACHE_FILE, (Object)canonicalPath)) != null) {
            return new ByteArrayInputStream(bytes);
        }
        ClassLoader loader = this.pluginManager.getClassLoader(pluginId);
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class);
        inputStream = resLoader.getResourceAsStream(loader, path);
        if (inputStream == null) {
            throw new FileNotFoundException(Messages.getInstance().getString("PluginFileResource.COULD_NOT_READ_FILE", new Object[]{path}));
        }
        if (useCache) {
            ByteArrayOutputStream bos = null;
            try {
                bos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)bos);
                byte[] bytes2 = bos.toByteArray();
                cache.putInRegionCache(CACHE_FILE, (Object)canonicalPath, (Object)bytes2);
                inputStream = new ByteArrayInputStream(bytes2);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)bos);
            }
        }
        return inputStream;
    }

    @GET
    @Path(value="/files/{path : .+}")
    @Produces(value={"*/*"})
    @Facet(name="Unsupported")
    public Response readFile(@PathParam(value="pluginId") String pluginId, @PathParam(value="path") String path) throws IOException {
        InputStream isTmp;
        List pluginRestPerspectives = this.pluginManager.getPluginRESTPerspectivesForId(pluginId);
        boolean useCache = "true".equals(this.pluginManager.getPluginSetting(pluginId, "settings/cache", "false"));
        String maxAge = (String)this.pluginManager.getPluginSetting(pluginId, "settings/max-age", null);
        if (!pluginRestPerspectives.contains(path) && maxAge != null && !"0".equals(maxAge)) {
            this.httpServletResponse.setHeader("Cache-Control", "max-age=" + maxAge);
        }
        if (!this.pluginManager.getRegisteredPlugins().contains(pluginId)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.pluginManager.isPublic(pluginId, path)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            isTmp = this.getCacheBackedStream(pluginId, path, useCache);
        }
        catch (FileNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        final InputStream is = isTmp;
        StreamingOutput streamingOutput = new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)output);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        };
        MediaType mediaType = MediaType.WILDCARD_TYPE;
        String mimeType = MimeHelper.getMimeTypeFromFileName((String)path);
        if (mimeType != null) {
            try {
                mediaType = MediaType.valueOf((String)mimeType);
            }
            catch (IllegalArgumentException iae) {
                logger.warn((Object)MessageFormat.format("PluginFileResource.UNDETERMINED_MIME_TYPE", path));
            }
        }
        return Response.ok((Object)streamingOutput, (MediaType)mediaType).build();
    }

    static {
        if (cache != null) {
            cache.addCacheRegion(CACHE_FILE);
        }
    }
}

