/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.IOUtils;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.util.ITempFileDeleter;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.servlet.messages.Messages;

public class UploadFileUtils {
    private static final long MAX_FILE_SIZE = 10000000L;
    private static final long MAX_FOLDER_SIZE = 500000000L;
    private static final long MAX_TMP_FOLDER_SIZE = 500000000L;
    private static final String DEFAULT_EXTENSIONS = "csv,dat,txt,tar,zip,tgz,gz,gzip";
    public static final String DEFAULT_RELATIVE_UPLOAD_FILE_PATH = File.separatorChar + "system" + File.separatorChar + "metadata" + File.separatorChar + "csvfiles" + File.separatorChar;
    private String fileName;
    private boolean shouldUnzip;
    private boolean temporary;
    private Writer writer;
    private FileItem uploadedItem;
    private IPentahoSession session;
    private long maxFileSize;
    private long maxFolderSize;
    private long maxTmpFolderSize;
    private String relativePath;
    private String path;
    private File pathDir;
    private File tmpPathDir;
    private Set<String> allowedExtensions;
    private String allowedExtensionsString;
    private boolean allowsNoExtension;

    public UploadFileUtils(IPentahoSession sessionValue) {
        this.session = sessionValue;
        this.relativePath = PentahoSystem.getSystemSetting((String)"file-upload-defaults/relative-path", (String)String.valueOf(DEFAULT_RELATIVE_UPLOAD_FILE_PATH));
        String maxFileLimit = PentahoSystem.getSystemSetting((String)"file-upload-defaults/max-file-limit", (String)String.valueOf(10000000L));
        String maxFolderLimit = PentahoSystem.getSystemSetting((String)"file-upload-defaults/max-folder-limit", (String)String.valueOf(500000000L));
        String maxTmpFolderLimit = PentahoSystem.getSystemSetting((String)"file-upload-defaults/max-tmp-folder-limit", (String)String.valueOf(500000000L));
        String tmpAllowedExtensions = PentahoSystem.getSystemSetting((String)"file-upload-defaults/allowed-extensions", (String)DEFAULT_EXTENSIONS);
        this.setAllowedExtensionsString(tmpAllowedExtensions);
        String allowsNoExtensionString = PentahoSystem.getSystemSetting((String)"file-upload-defaults/allow-files-without-extension", (String)"true");
        this.allowsNoExtension = Boolean.valueOf(allowsNoExtensionString);
        this.maxFileSize = Long.parseLong(maxFileLimit);
        this.maxFolderSize = Long.parseLong(maxFolderLimit);
        this.maxTmpFolderSize = Long.parseLong(maxTmpFolderLimit);
    }

    protected boolean checkExtension(String fileName, boolean emitMessage) throws IOException {
        if (fileName == null || fileName.length() == 0) {
            if (emitMessage) {
                this.getWriter().write(Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0010_FILE_NAME_INVALID"));
            }
            return false;
        }
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 0) {
            if (!this.allowsNoExtension) {
                if (emitMessage) {
                    this.getWriter().write(Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0010_FILE_NAME_INVALID"));
                }
                return false;
            }
            return true;
        }
        String ext = fileName.substring(lastDot + 1);
        if (ext.length() == 0) {
            if (emitMessage) {
                this.getWriter().write(Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0010_FILE_NAME_INVALID"));
            }
            return false;
        }
        if (!this.allowedExtensions.contains(ext)) {
            if (emitMessage) {
                this.getWriter().write(Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0011_ILLEGAL_FILE_TYPE", new Object[]{this.allowedExtensionsString}));
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process() throws Exception {
        this.path = PentahoSystem.getApplicationContext().getSolutionPath(this.relativePath);
        this.pathDir = new File(this.path);
        if (!this.pathDir.exists()) {
            this.pathDir.mkdirs();
        }
        this.tmpPathDir = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/tmp"));
        if (!this.tmpPathDir.exists()) {
            this.tmpPathDir.mkdirs();
        }
        if (!this.checkLimits(this.getUploadedFileItem().getSize())) {
            return false;
        }
        if (this.fileName == null) {
            this.getWriter().write(Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0010_FILE_NAME_INVALID"));
            return false;
        }
        if (!this.checkExtension(this.fileName, true)) {
            return false;
        }
        File file = null;
        if (this.isTemporary()) {
            file = PentahoSystem.getApplicationContext().createTempFile(this.session, "", ".tmp", true);
        } else {
            String relPath;
            file = new File(this.getPath() + File.separatorChar + this.fileName);
            String cp = file.getCanonicalPath();
            if (!cp.startsWith(relPath = this.getPathDir().getCanonicalPath())) {
                this.getWriter().write(Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0008_FILE_LOCATION_INVALID"));
                return false;
            }
        }
        InputStream itemInputStream = this.getUploadedFileItem().getInputStream();
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
            try {
                IOUtils.copy((InputStream)itemInputStream, (OutputStream)outputStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)itemInputStream);
        }
        this.getUploadedFileItem().delete();
        if (this.shouldUnzip) {
            return this.handleUnzip(file);
        }
        this.writer.write(file.getName());
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean handleUnzip(File file) throws IOException {
        String fileNames = file.getName();
        ITempFileDeleter fileDeleter = null;
        if (this.session != null && (fileDeleter = (ITempFileDeleter)this.session.getAttribute("PENTAHO_TMP_DELETER")) != null) {
            fileDeleter.trackTempFile(file);
        }
        if (this.getUploadedFileItem().getName().toLowerCase().endsWith(".zip") || this.getUploadedFileItem().getContentType().equals("application/zip")) {
            if (!this.checkLimits(this.getUncompressedZipFileSize(file), true)) {
                file.delete();
                return false;
            }
            fileNames = this.handleZip(file);
        } else if (this.getUploadedFileItem().getName().toLowerCase().endsWith(".tgz") || this.getUploadedFileItem().getName().toLowerCase().endsWith(".tar.gz") || this.getUploadedFileItem().getContentType().equals("application/x-compressed") || this.getUploadedFileItem().getContentType().equals("application/tgz")) {
            long tarSize = this.getUncompressedGZipFileSize(file);
            if (!this.checkLimits(tarSize, true)) {
                file.delete();
                return false;
            }
            if (!this.isTemporary() && !this.checkLimits(tarSize * 2L, true)) {
                return false;
            }
            fileNames = this.handleTarGZ(file);
        } else if (this.getUploadedFileItem().getName().toLowerCase().endsWith(".gzip") || this.getUploadedFileItem().getName().toLowerCase().endsWith(".gz")) {
            if (!this.checkLimits(this.getUncompressedGZipFileSize(file), true)) {
                file.delete();
                return false;
            }
            fileNames = this.handleGZip(file, false);
        } else if (this.getUploadedFileItem().getName().toLowerCase().endsWith(".tar") || this.getUploadedFileItem().getContentType().equals("application/x-tar")) {
            if (!this.isTemporary() && !this.checkLimits(this.getUploadedFileItem().getSize(), true)) {
                file.delete();
                return false;
            }
            fileNames = this.handleTar(file);
        }
        this.writer.write(fileNames);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUncompressedZipFileSize(File theFile) throws IOException {
        long rtn = 0L;
        ZipFile zf = new ZipFile(theFile);
        try {
            Enumeration<? extends ZipEntry> zfEntries = zf.entries();
            ZipEntry ze = null;
            while (zfEntries.hasMoreElements()) {
                ze = zfEntries.nextElement();
                rtn += ze.getSize();
            }
        }
        finally {
            try {
                zf.close();
            }
            catch (Exception exception) {}
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUncompressedGZipFileSize(File file) throws IOException {
        long rtn = 0L;
        RandomAccessFile gzipFile = new RandomAccessFile(file, "r");
        try {
            gzipFile.seek(gzipFile.length() - 4L);
            byte[] intelSize = new byte[4];
            gzipFile.read(intelSize);
            rtn = (long)((intelSize[3] & 0xFF) << 24 | ((intelSize[2] & 0xFF) << 16) + ((intelSize[1] & 0xFF) << 8) + (intelSize[0] & 0xFF)) & 0xFFFFFFFFL;
        }
        finally {
            try {
                gzipFile.close();
            }
            catch (Exception exception) {}
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleZip(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        FileInputStream fileStream = new FileInputStream(file.getAbsolutePath());
        try {
            ZipInputStream zipStream = new ZipInputStream(new BufferedInputStream(fileStream));
            try {
                ZipEntry entry = zipStream.getNextEntry();
                while (entry != null) {
                    if (!(entry.isDirectory() || entry.getName().startsWith(".") || entry.getName().startsWith("__MACOSX/"))) {
                        File entryFile = null;
                        if (this.checkExtension(entry.getName(), false)) {
                            if (this.isTemporary()) {
                                String extension = ".tmp";
                                int idx = entry.getName().lastIndexOf(46);
                                if (idx != -1) {
                                    extension = entry.getName().substring(idx) + extension;
                                }
                                entryFile = PentahoSystem.getApplicationContext().createTempFile(this.session, "", extension, true);
                            } else {
                                entryFile = new File(this.getPath() + File.separatorChar + entry.getName());
                            }
                            if (sb.length() > 0) {
                                sb.append("\n");
                            }
                            sb.append(entryFile.getName());
                            FileOutputStream entryOutputStream = new FileOutputStream(entryFile);
                            try {
                                IOUtils.copy((InputStream)zipStream, (OutputStream)entryOutputStream);
                            }
                            finally {
                                IOUtils.closeQuietly((OutputStream)entryOutputStream);
                            }
                        }
                    }
                    entry = zipStream.getNextEntry();
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)zipStream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileStream);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0012_ILLEGAL_CONTENTS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleGZip(File file, boolean fullPath) throws IOException {
        FileInputStream fileStream = new FileInputStream(file.getAbsolutePath());
        try {
            String string;
            String gzFile = file.getCanonicalPath();
            int idx = gzFile.lastIndexOf(46);
            String endFileName = null;
            endFileName = gzFile.substring(0, idx);
            idx = endFileName.lastIndexOf(46);
            if (!this.checkExtension(endFileName, true)) {
                String string2 = "";
                return string2;
            }
            GZIPInputStream zipStream = new GZIPInputStream(new BufferedInputStream(fileStream));
            File entryFile = null;
            if (this.isTemporary() || fullPath) {
                entryFile = PentahoSystem.getApplicationContext().createTempFile(this.session, "", ".tmp", true);
            } else if (idx > 0) {
                entryFile = new File(endFileName);
            } else {
                File parentFolder = file.getParentFile();
                entryFile = File.createTempFile("upload_gzip", ".tmp", parentFolder);
            }
            try {
                FileOutputStream entryOutputStream = new FileOutputStream(entryFile);
                try {
                    IOUtils.copy((InputStream)zipStream, (OutputStream)entryOutputStream);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)entryOutputStream);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)zipStream);
            }
            if (fullPath) {
                string = entryFile.getCanonicalPath();
                return string;
            }
            string = entryFile.getName();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleTar(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        FileInputStream fileStream = new FileInputStream(file);
        try {
            TarInputStream zipStream = new TarInputStream((InputStream)new BufferedInputStream(fileStream));
            try {
                TarEntry entry = zipStream.getNextEntry();
                while (entry != null) {
                    if (!(entry.isDirectory() || entry.getName().startsWith(".") || entry.getName().startsWith("__MACOSX/"))) {
                        File entryFile = null;
                        if (this.checkExtension(entry.getName(), false)) {
                            if (this.isTemporary()) {
                                String extension = ".tmp";
                                int idx = entry.getName().lastIndexOf(46);
                                if (idx != -1) {
                                    extension = entry.getName().substring(idx) + extension;
                                }
                                entryFile = PentahoSystem.getApplicationContext().createTempFile(this.session, "", extension, true);
                            } else {
                                entryFile = new File(this.getPath() + File.separatorChar + entry.getName());
                            }
                            if (sb.length() > 0) {
                                sb.append("\n");
                            }
                            sb.append(entryFile.getName());
                            FileOutputStream entryOutputStream = new FileOutputStream(entryFile);
                            try {
                                IOUtils.copy((InputStream)zipStream, (OutputStream)entryOutputStream);
                            }
                            finally {
                                IOUtils.closeQuietly((OutputStream)entryOutputStream);
                            }
                        }
                    }
                    entry = zipStream.getNextEntry();
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)zipStream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileStream);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0012_ILLEGAL_CONTENTS");
    }

    protected String handleTarGZ(File file) throws IOException {
        ITempFileDeleter fileDeleter;
        String filename = this.handleGZip(file, true);
        File tarFile = new File(filename);
        if (this.session != null && (fileDeleter = (ITempFileDeleter)this.session.getAttribute("PENTAHO_TMP_DELETER")) != null) {
            fileDeleter.trackTempFile(tarFile);
        }
        return this.handleTar(tarFile);
    }

    public boolean checkLimits(long itemSize) throws IOException {
        return this.checkLimits(itemSize, false);
    }

    public boolean checkLimits(long itemSize, boolean compressed) throws IOException {
        long folderLimit;
        File checkDir;
        if (itemSize > this.maxFileSize) {
            String error = compressed ? Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0006_FILE_TOO_BIG") : Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0003_FILE_TOO_BIG");
            this.writer.write(error);
            return false;
        }
        if (!this.isTemporary()) {
            checkDir = this.pathDir;
            folderLimit = this.maxFolderSize;
        } else {
            checkDir = this.tmpPathDir;
            folderLimit = this.maxTmpFolderSize;
        }
        long actualDirSize = this.getFolderSize(checkDir);
        if (itemSize + actualDirSize > folderLimit) {
            String error = compressed ? Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0007_FOLDER_SIZE_LIMIT_REACHED") : Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0004_FOLDER_SIZE_LIMIT_REACHED");
            this.writer.write(error);
            return false;
        }
        return true;
    }

    private long getFolderSize(File folder) {
        long foldersize = 0L;
        File[] filelist = folder.listFiles();
        for (int i = 0; i < filelist.length; ++i) {
            if (filelist[i].isDirectory()) {
                foldersize += this.getFolderSize(filelist[i]);
                continue;
            }
            foldersize += filelist[i].length();
        }
        return foldersize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String value) {
        this.fileName = value;
    }

    public boolean isShouldUnzip() {
        return this.shouldUnzip;
    }

    public void setShouldUnzip(boolean value) {
        this.shouldUnzip = value;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean value) {
        this.temporary = value;
    }

    public void setWriter(Writer value) {
        this.writer = value;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setUploadedFileItem(FileItem value) {
        this.uploadedItem = value;
    }

    public FileItem getUploadedFileItem() {
        return this.uploadedItem;
    }

    public String getPath() {
        return this.path;
    }

    public File getPathDir() {
        return this.pathDir;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    void setAllowsNoExtension(boolean value) {
        this.allowsNoExtension = value;
    }

    boolean getAllowsNoExtension() {
        return this.allowsNoExtension;
    }

    void setAllowedExtensionsString(String value) {
        this.allowedExtensionsString = value;
        String[] extensions = value.split(",");
        HashSet<String> theSet = new HashSet<String>(extensions.length);
        for (int i = 0; i < extensions.length; ++i) {
            theSet.add(extensions[i]);
        }
        this.allowedExtensions = theSet;
    }

    String getAllowedExtensionsString() {
        return this.allowedExtensionsString;
    }
}

