/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;

@InterfaceAudience.Private
public class HiveConfUtil {
    public static boolean isEmbeddedMetaStore(String msUri) {
        return msUri == null ? true : msUri.trim().isEmpty();
    }

    public static StringBuilder dumpConfig(HiveConf conf) {
        StringBuilder sb = new StringBuilder("START========\"HiveConf()\"========\n");
        sb.append("hiveDefaultUrl=").append(conf.getHiveDefaultLocation()).append('\n');
        sb.append("hiveSiteURL=").append(HiveConf.getHiveSiteLocation()).append('\n');
        sb.append("hiveServer2SiteUrl=").append(HiveConf.getHiveServer2SiteLocation()).append('\n');
        sb.append("hivemetastoreSiteUrl=").append(HiveConf.getMetastoreSiteLocation()).append('\n');
        HiveConfUtil.dumpConfig(conf, sb);
        return sb.append("END========\"new HiveConf()\"========\n");
    }

    public static void dumpConfig(Configuration conf, StringBuilder sb) {
        Iterator configIter = conf.iterator();
        ArrayList configVals = new ArrayList();
        while (configIter.hasNext()) {
            configVals.add(configIter.next());
        }
        Collections.sort(configVals, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> ent, Map.Entry<String, String> ent2) {
                return ent.getKey().compareTo(ent2.getKey());
            }
        });
        for (Map.Entry entry : configVals) {
            if (((String)entry.getKey()).toLowerCase().contains("path")) {
                StringTokenizer st = new StringTokenizer(conf.get((String)entry.getKey()), File.pathSeparator);
                sb.append((String)entry.getKey()).append("=\n");
                while (st.hasMoreTokens()) {
                    sb.append("    ").append(st.nextToken()).append(File.pathSeparator).append('\n');
                }
                continue;
            }
            sb.append((String)entry.getKey()).append('=').append(conf.get((String)entry.getKey())).append('\n');
        }
    }
}

