/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import mondrian.rolap.CellKey;
import mondrian.spi.SegmentBody;
import mondrian.util.Pair;

abstract class AbstractSegmentBody
implements SegmentBody {
    private static final long serialVersionUID = -7094121704771005640L;
    protected final SortedSet<Comparable>[] axisValueSets;
    private final boolean[] nullAxisFlags;

    public AbstractSegmentBody(List<Pair<SortedSet<Comparable>, Boolean>> axes) {
        this.axisValueSets = new SortedSet[axes.size()];
        this.nullAxisFlags = new boolean[axes.size()];
        for (int i = 0; i < axes.size(); ++i) {
            Pair<SortedSet<Comparable>, Boolean> pair = axes.get(i);
            this.axisValueSets[i] = (SortedSet)pair.left;
            this.nullAxisFlags[i] = (Boolean)pair.right;
        }
    }

    @Override
    public SortedSet<Comparable>[] getAxisValueSets() {
        return this.axisValueSets;
    }

    @Override
    public boolean[] getNullAxisFlags() {
        return this.nullAxisFlags;
    }

    @Override
    public Map<CellKey, Object> getValueMap() {
        return new AbstractMap<CellKey, Object>(){

            @Override
            public Set<Map.Entry<CellKey, Object>> entrySet() {
                return new AbstractSet<Map.Entry<CellKey, Object>>(){

                    @Override
                    public Iterator<Map.Entry<CellKey, Object>> iterator() {
                        return new SegmentBodyIterator();
                    }

                    @Override
                    public int size() {
                        return AbstractSegmentBody.this.getEffectiveSize();
                    }
                };
            }
        };
    }

    @Override
    public Object getValueArray() {
        throw new UnsupportedOperationException("This method is only supported for dense segments");
    }

    @Override
    public BitSet getNullValueIndicators() {
        throw new UnsupportedOperationException("This method is only supported for dense segments of native values");
    }

    protected abstract int getSize();

    protected int getEffectiveSize() {
        return this.getSize();
    }

    protected abstract Object getObject(int var1);

    private class SegmentBodyIterator
    implements Iterator<Map.Entry<CellKey, Object>> {
        private int i = -1;
        private final int[] ordinals;
        private final int size = AbstractSegmentBody.this.getSize();
        private boolean hasNext = true;
        private Object next;

        SegmentBodyIterator() {
            this.ordinals = new int[AbstractSegmentBody.this.axisValueSets.length];
            this.ordinals[this.ordinals.length - 1] = -1;
            this.moveToNext();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Map.Entry<CellKey, Object> next() {
            Pair<CellKey, Object> o = Pair.of(CellKey.Generator.newCellKey(this.ordinals), this.next);
            this.moveToNext();
            return o;
        }

        private void moveToNext() {
            do {
                ++this.i;
                if (this.i >= this.size) {
                    this.hasNext = false;
                    return;
                }
                for (int k = this.ordinals.length - 1; k >= 0; --k) {
                    int j = 1;
                    if (AbstractSegmentBody.this.nullAxisFlags[k]) {
                        j = 0;
                    }
                    if (this.ordinals[k] < AbstractSegmentBody.this.axisValueSets[k].size() - j) {
                        int n = k;
                        this.ordinals[n] = this.ordinals[n] + 1;
                        break;
                    }
                    this.ordinals[k] = 0;
                }
                this.next = AbstractSegmentBody.this.getObject(this.i);
            } while (this.next == null);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

