/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.zookeeper.publish;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.aries.rsa.discovery.zookeeper.publish.PublishingEndpointListener;
import org.apache.zookeeper.ZooKeeper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingEndpointListenerFactory
implements ServiceFactory<PublishingEndpointListener> {
    private static final Logger LOG = LoggerFactory.getLogger(PublishingEndpointListenerFactory.class);
    private final BundleContext bctx;
    private final ZooKeeper zk;
    private final List<PublishingEndpointListener> listeners = new ArrayList<PublishingEndpointListener>();
    private ServiceRegistration<?> serviceRegistration;

    public PublishingEndpointListenerFactory(ZooKeeper zk, BundleContext bctx) {
        this.bctx = bctx;
        this.zk = zk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublishingEndpointListener getService(Bundle b, ServiceRegistration<PublishingEndpointListener> sr) {
        LOG.debug("new EndpointListener from factory");
        List<PublishingEndpointListener> list = this.listeners;
        synchronized (list) {
            PublishingEndpointListener pel = new PublishingEndpointListener(this.zk, this.bctx);
            this.listeners.add(pel);
            return pel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(Bundle b, ServiceRegistration<PublishingEndpointListener> sr, PublishingEndpointListener pel) {
        LOG.debug("remove EndpointListener");
        List<PublishingEndpointListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.remove(pel)) {
                pel.close();
            }
        }
    }

    public synchronized void start() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        String uuid = this.bctx.getProperty("org.osgi.framework.uuid");
        ((Dictionary)props).put("endpoint.listener.scope", String.format("(&(%s=*)(%s=%s))", "objectClass", "endpoint.framework.uuid", uuid));
        ((Dictionary)props).put("org.apache.cxf.dosgi.discovery.zookeeper", "true");
        this.serviceRegistration = this.bctx.registerService(EndpointListener.class.getName(), (Object)this, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        List<PublishingEndpointListener> list = this.listeners;
        synchronized (list) {
            for (PublishingEndpointListener pel : this.listeners) {
                pel.close();
            }
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PublishingEndpointListener> getListeners() {
        List<PublishingEndpointListener> list = this.listeners;
        synchronized (list) {
            return this.listeners;
        }
    }
}

