/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.daemon.spark.installer;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkInstallerMain {
    private static final Logger LOG = LoggerFactory.getLogger(SparkInstallerMain.class);

    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("SparkDriver").getOrCreate();
        FileSystem fs = SparkInstallerMain.createFileSystem(spark);
        String function = args[0];
        System.out.println("********************************************************************************");
        LOG.info("Function: {}", (Object)function);
        switch (function) {
            case "copyFromLocalFile": {
                SparkInstallerMain.copyFromLocalFile(fs, args[1], args[2]);
                break;
            }
            case "delete": {
                SparkInstallerMain.delete(fs, args[1]);
                break;
            }
            default: {
                LOG.error("Unsupported function: ", (Object)function);
            }
        }
        System.out.println("********************************************************************************");
        spark.stop();
    }

    private static FileSystem createFileSystem(SparkSession spark) {
        try {
            Configuration configuration = spark.sparkContext().hadoopConfiguration();
            return FileSystem.get((Configuration)configuration);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create Hadoop FileSystem object.", e);
        }
    }

    private static void delete(FileSystem fs, String file) {
        try {
            LOG.info("Delete @ {}", (Object)file);
            fs.delete(new Path(file), false);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error while trying to delete file on HDFS.", e);
        }
    }

    private static void copyFromLocalFile(FileSystem fs, String sourceZip, String destinationFolder) {
        try {
            LOG.info("Copy From Local File @ {} to HDFS @ {}", (Object)sourceZip, (Object)destinationFolder);
            fs.copyFromLocalFile(new Path(sourceZip), new Path(destinationFolder, new File(sourceZip).getName()));
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error while trying to copy from local file to HDFS.", e);
        }
    }
}

