/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table.columns;

import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.AbstractColumnModel;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.TableColumn;

public class SeparateColumnModel
extends AbstractColumnModel {
    private long validationTrack = -1L;
    private long cachedSize;

    @Override
    public long getCachedSize() {
        return this.cachedSize;
    }

    @Override
    public void validateSizes(TableRenderBox table) {
        long cachedSize;
        if (this.isValidated() && this.validationTrack == table.getChangeTracker()) {
            return;
        }
        int maxColSpan = 0;
        TableColumn[] columns = this.getColumns();
        int colCount = columns.length;
        for (int i = 0; i < colCount; ++i) {
            TableColumn column = columns[i];
            int cs = column.getMaxColspan();
            if (cs <= maxColSpan) continue;
            maxColSpan = cs;
        }
        if (colCount == 0) {
            this.validationTrack = table.getChangeTracker();
            return;
        }
        long[] cachedSizes = new long[colCount];
        for (int colIdx = 0; colIdx < colCount; ++colIdx) {
            long cachedSize2;
            TableColumn column = columns[colIdx];
            cachedSizes[colIdx] = cachedSize2 = column.getCachedSize(1);
        }
        for (int colspan = 2; colspan <= maxColSpan; ++colspan) {
            for (int colIdx = 0; colIdx < colCount; ++colIdx) {
                TableColumn column = columns[colIdx];
                cachedSize = column.getCachedSize(colspan);
                this.distribute(cachedSize, cachedSizes, colIdx, colspan);
            }
        }
        this.cachedSize = 0L;
        int variableColumns = 0;
        for (int i = 0; i < colCount; ++i) {
            TableColumn column = columns[i];
            if (column.isValidated()) {
                this.cachedSize += column.getEffectiveSize();
                continue;
            }
            ++variableColumns;
            cachedSize = cachedSizes[i];
            this.cachedSize += cachedSize;
            column.setEffectiveSize(cachedSize);
        }
        if (variableColumns > 0) {
            long tableSize = Math.max(table.getContentAreaX2() - table.getContentAreaX1(), this.cachedSize);
            long extraSpace = tableSize - this.cachedSize;
            long extraSpacePerCol = extraSpace / (long)variableColumns;
            for (int i = 0; i < colCount; ++i) {
                TableColumn column = columns[i];
                if (column.isValidated()) continue;
                long colSize = column.getEffectiveSize() + extraSpacePerCol;
                column.setEffectiveSize(colSize);
                column.setValidated(true);
            }
            this.cachedSize = tableSize;
        }
        this.validationTrack = table.getChangeTracker();
    }

    private void distribute(long usedSpace, long[] allSpaces, int colIdx, int colspan) {
        int maxColspan = Math.min(colIdx + colspan, allSpaces.length) - colIdx;
        int maxSize = Math.min(allSpaces.length, colIdx + maxColspan);
        long usedPrev = 0L;
        for (int i = colIdx; i < maxSize; ++i) {
            usedPrev += allSpaces[i];
        }
        if (usedSpace <= usedPrev) {
            return;
        }
        long distSpace = usedSpace - usedPrev;
        long delta = distSpace / (long)maxColspan;
        for (int i = 0; i < maxColspan - 1; ++i) {
            int n = colIdx + i;
            allSpaces[n] = allSpaces[n] + delta;
        }
        int n = colIdx + maxColspan - 1;
        allSpaces[n] = allSpaces[n] + (distSpace - (long)(maxColspan - 1) * delta);
    }
}

