/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table.rows;

import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.PreferredRowSizeCache;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRow;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRowImpl;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRowModel;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.ValidatedRowSizeCache;
import org.pentaho.reporting.engine.classic.core.util.BulkArrayList;

public abstract class AbstractRowModel
implements TableRowModel {
    private BulkArrayList<TableRowImpl> rows = new BulkArrayList(2000);
    private ValidatedRowSizeCache validatedSizesCache = new ValidatedRowSizeCache();
    private PreferredRowSizeCache preferredSizesCache = new PreferredRowSizeCache();

    @Override
    public void addRow() {
        this.rows.add(new TableRowImpl());
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public TableRow getRow(int i) {
        return this.rows.get(i);
    }

    protected TableRowImpl internalGetRow(int i) {
        return this.rows.get(i);
    }

    protected TableRowImpl[] getRows() {
        return this.rows.toArray((TableRowImpl[])new TableRowImpl[this.rows.size()]);
    }

    @Override
    public void prune(int rows) {
        if (rows <= 1) {
            return;
        }
        long validatedSize = 0L;
        long preferredSize = 0L;
        int split = 0;
        int runningMaxRowSpan = 0;
        for (int r = 0; r < rows; ++r) {
            --runningMaxRowSpan;
            TableRowImpl row = this.internalGetRow(r);
            validatedSize += row.getValidateSize();
            preferredSize += row.getPreferredSize();
            if ((runningMaxRowSpan = Math.max(runningMaxRowSpan, row.getMaximumRowSpan())) != 1) continue;
            split = r;
        }
        if (split == 0) {
            return;
        }
        TableRowImpl newRow = new TableRowImpl();
        newRow.updateDefinedSize(1, preferredSize);
        newRow.updateValidatedSize(1, 0L, validatedSize);
        newRow.setPreferredSize(preferredSize);
        newRow.setValidateSize(validatedSize);
        this.rows.set(0, newRow);
        this.rows.removeRange(1, rows - 1);
    }

    public long getRowSpacing() {
        return 0L;
    }

    @Override
    public void updateDefinedSize(int rowNumber, int rowSpan, long preferredSize) {
        this.internalGetRow(rowNumber).updateDefinedSize(rowSpan, preferredSize);
    }

    @Override
    public void updateValidatedSize(int rowNumber, int rowSpan, long leading, long height) {
        this.internalGetRow(rowNumber).updateValidatedSize(rowSpan, leading, height);
    }

    @Override
    public long getValidatedRowSize(int rowNumber) {
        return this.internalGetRow(rowNumber).getValidateSize();
    }

    @Override
    public long getPreferredRowSize(int rowNumber) {
        return this.internalGetRow(rowNumber).getPreferredSize();
    }

    @Override
    public int getMaximumRowSpan(int rowNumber) {
        return this.internalGetRow(rowNumber).getMaximumRowSpan();
    }

    protected long[] getPreferredSizes(int limit) {
        return this.preferredSizesCache.get(limit, this.rows);
    }

    protected void applyPreferredSizes(long[] preferredSizes, int start, int end) {
        this.preferredSizesCache.apply(preferredSizes, start, end, this.rows);
    }

    protected long[] getValidateSizes(int limit) {
        return this.validatedSizesCache.get(limit, this.rows);
    }

    protected void applyValidateSizes(long[] trailingSizes, int start, int end) {
        this.validatedSizesCache.apply(trailingSizes, start, end, this.rows);
    }
}

