/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.html;

import java.awt.Window;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractExportActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.html.HtmlExportGUIModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.html.HtmlZipExportTask;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class HtmlZipExportPlugin
extends AbstractExportActionPlugin {
    private static final Log logger = LogFactory.getLog(HtmlZipExportPlugin.class);
    private final ResourceBundleSupport resources = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.html.messages.messages", ObjectUtilities.getClassLoader(HtmlExportGUIModule.class));

    @Override
    public boolean initialize(SwingGuiContext context) {
        if (!super.initialize(context)) {
            return false;
        }
        return ClassicEngineBoot.getInstance().isModuleAvailable(HtmlExportGUIModule.class.getName());
    }

    @Override
    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.html.export.zip.";
    }

    @Override
    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setMessage(this.resources.getString("html-export.progressdialog.message"));
        progressDialog.pack();
        LibSwingUtil.positionFrameRandomly((Window)progressDialog);
        return progressDialog;
    }

    @Override
    public boolean performExport(MasterReport report) {
        ReportProgressDialog progressDialog;
        boolean result = this.performShowExportDialog(report, "org.pentaho.reporting.engine.classic.core.modules.gui.html.zip.Dialog");
        if (!result) {
            return false;
        }
        if (this.isProgressDialogEnabled(report, "org.pentaho.reporting.engine.classic.core.modules.gui.html.zip.ProgressDialogEnabled")) {
            progressDialog = this.createProgressDialog();
            if (report.getTitle() == null) {
                progressDialog.setTitle(this.getResources().getString("ProgressDialog.EMPTY_TITLE"));
            } else {
                progressDialog.setTitle(this.getResources().formatMessage("ProgressDialog.TITLE", (Object)report.getTitle()));
            }
        } else {
            progressDialog = null;
        }
        try {
            HtmlZipExportTask task = new HtmlZipExportTask(report, progressDialog, this.getContext());
            Thread worker = new Thread(task);
            worker.start();
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Failure while preparing the HTML export", (Throwable)e);
            this.getContext().getStatusListener().setStatus(StatusType.ERROR, this.getResources().getString("HtmlZipExportPlugin.USER_FAILED"), e);
            return false;
        }
    }

    @Override
    public String getDisplayName() {
        return this.resources.getString("action.export-to-html.zip.name");
    }

    @Override
    public String getShortDescription() {
        return this.resources.getString("action.export-to-html.zip.description");
    }

    @Override
    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.export-to-html.zip.small-icon");
    }

    @Override
    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.export-to-html.zip.icon");
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return this.resources.getOptionalKeyStroke("action.export-to-html.zip.accelerator");
    }

    @Override
    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.export-to-html.zip.mnemonic");
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }
}

