/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportParameterValidationException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.PageState;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.PageDrawable;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.DrawablePrintable;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.GraphicsOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.QueryPhysicalPageInterceptor;

public class PrintReportProcessor
extends PageableReportProcessor
implements Pageable {
    private static final Log logger = LogFactory.getLog(PrintReportProcessor.class);
    private Throwable error;

    public PrintReportProcessor(MasterReport report) throws ReportProcessingException {
        super(report, new GraphicsOutputProcessor(report.getConfiguration(), report.getResourceManager()));
        this.setFullStreamingProcessor(false);
    }

    protected GraphicsOutputProcessor getGraphicsProcessor() {
        return (GraphicsOutputProcessor)this.getOutputProcessor();
    }

    @Override
    public synchronized int getNumberOfPages() {
        if (this.isError()) {
            return 0;
        }
        if (!this.isPaginated()) {
            try {
                this.prepareReportProcessing();
                logger.debug((Object)("After pagination, we have " + this.getGraphicsProcessor().getPhysicalPageCount() + " physical pages."));
            }
            catch (ReportParameterValidationException e) {
                this.error = e;
                return 0;
            }
            catch (Exception e) {
                logger.error((Object)"PrintReportProcessor: ", (Throwable)e);
                this.error = e;
                return 0;
            }
        }
        return this.getGraphicsProcessor().getPhysicalPageCount();
    }

    @Override
    public synchronized boolean paginate() {
        if (this.isError()) {
            return false;
        }
        if (!this.isPaginated()) {
            try {
                this.prepareReportProcessing();
                return true;
            }
            catch (Exception e) {
                this.error = e;
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (this.isError()) {
            return null;
        }
        if (!this.isPaginated()) {
            try {
                this.prepareReportProcessing();
            }
            catch (Exception e) {
                this.error = e;
                return null;
            }
        }
        try {
            PageDrawable pageDrawable = this.processPage(pageIndex);
            return pageDrawable.getPageFormat();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to return a valid pageformat: ", (Throwable)e);
            throw new IllegalStateException("Unable to return a valid pageformat.");
        }
    }

    @Override
    public synchronized Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (this.isError()) {
            return null;
        }
        if (!this.isPaginated()) {
            try {
                this.prepareReportProcessing();
            }
            catch (Exception e) {
                this.error = e;
                return null;
            }
        }
        try {
            PageDrawable pageDrawable = this.processPage(pageIndex);
            return new DrawablePrintable(pageDrawable);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to return a valid pageable object: ", (Throwable)e);
            throw new IllegalStateException("Unable to return a valid pageformat.");
        }
    }

    public synchronized PageDrawable getPageDrawable(int pageIndex) {
        if (this.isError()) {
            return null;
        }
        if (!this.isPaginated()) {
            try {
                this.prepareReportProcessing();
            }
            catch (Exception e) {
                this.error = e;
                logger.error((Object)"Failed to paginate", (Throwable)e);
                return null;
            }
        }
        try {
            return this.processPage(pageIndex);
        }
        catch (Exception e) {
            this.error = e;
            logger.error((Object)"Failed to process the page", (Throwable)e);
            throw new IllegalStateException("Unable to return a valid pageformat.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PageDrawable processPage(int page) throws ReportProcessingException {
        GraphicsOutputProcessor outputProcessor = this.getGraphicsProcessor();
        try {
            PageState state = this.getPhysicalPageState(page);
            QueryPhysicalPageInterceptor interceptor = new QueryPhysicalPageInterceptor(outputProcessor.getPhysicalPage(page));
            outputProcessor.setInterceptor(interceptor);
            while (interceptor.isMoreContentNeeded()) {
                state = this.processPage(state, true);
            }
            PageDrawable pageDrawable = interceptor.getDrawable();
            return pageDrawable;
        }
        finally {
            outputProcessor.setInterceptor(null);
        }
    }

    public boolean isError() {
        return this.error != null;
    }

    @Override
    public void processReport() throws ReportProcessingException {
        throw new UnsupportedOperationException("Printing is a passive process.");
    }

    public void fireProcessingStarted() {
        this.fireProcessingStarted(new ReportProgressEvent(this));
    }

    public void fireProcessingFinished() {
        this.fireProcessingFinished(new ReportProgressEvent(this));
    }

    @Override
    protected synchronized void fireStateUpdate(ReportProgressEvent state) {
        super.fireStateUpdate(state);
    }

    @Override
    protected synchronized void fireProcessingStarted(ReportProgressEvent state) {
        super.fireProcessingStarted(state);
    }

    @Override
    protected synchronized void fireProcessingFinished(ReportProgressEvent state) {
        super.fireProcessingFinished(state);
    }

    @Override
    public synchronized void addReportProgressListener(ReportProgressListener l) {
        super.addReportProgressListener(l);
    }

    @Override
    public synchronized void removeReportProgressListener(ReportProgressListener l) {
        super.removeReportProgressListener(l);
    }

    public Throwable getErrorReason() {
        return this.error;
    }
}

