/*
 * Decompiled with CFR 0.152.
 */
package javolution.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import javolution.JavolutionError;
import javolution.io.UTF8ByteBufferReader;
import javolution.io.UTF8ByteBufferWriter;
import javolution.lang.Configurable;
import javolution.lang.MathLib;
import javolution.lang.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Struct {
    public static final Configurable<Integer> MAXIMUM_ALIGNMENT = new Configurable<Integer>(new Integer(4));
    private Struct _outer;
    private ByteBuffer _byteBuffer;
    private int _outerOffset;
    private int _bitsUsed;
    private int _alignment = 1;
    private int _bitIndex;
    private boolean _resetIndex = this.isUnion();
    private byte[] _bytes;
    private static final Reflection.Method ADDRESS_METHOD = Reflection.getMethod("sun.nio.ch.DirectBuffer.address()");
    private static final char[] HEXA = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Class BOOL = new Bool[0].getClass();
    private static final Class SIGNED_8 = new Signed8[0].getClass();
    private static final Class UNSIGNED_8 = new Unsigned8[0].getClass();
    private static final Class SIGNED_16 = new Signed16[0].getClass();
    private static final Class UNSIGNED_16 = new Unsigned16[0].getClass();
    private static final Class SIGNED_32 = new Signed32[0].getClass();
    private static final Class UNSIGNED_32 = new Unsigned32[0].getClass();
    private static final Class SIGNED_64 = new Signed64[0].getClass();
    private static final Class FLOAT_32 = new Float32[0].getClass();
    private static final Class FLOAT_64 = new Float64[0].getClass();

    public final int size() {
        int n = this._bitsUsed + 7 >> 3;
        return n % this._alignment == 0 ? n : n + this._alignment - n % this._alignment;
    }

    public final ByteBuffer getByteBuffer() {
        if (this._outer != null) {
            return this._outer.getByteBuffer();
        }
        return this._byteBuffer != null ? this._byteBuffer : this.newBuffer();
    }

    private synchronized ByteBuffer newBuffer() {
        if (this._byteBuffer != null) {
            return this._byteBuffer;
        }
        int n = this.size();
        int n2 = this.isPacked() ? ((n & 7) == 0 ? n : n + 8 - (n & 7)) : n;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
        byteBuffer.order(this.byteOrder());
        this.setByteBuffer(byteBuffer, 0);
        return this._byteBuffer;
    }

    public final Struct setByteBuffer(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.order() != this.byteOrder()) {
            throw new IllegalArgumentException("The byte order of the specified byte buffer is different from this struct byte order");
        }
        if (this._outer != null) {
            throw new UnsupportedOperationException("Inner struct byte buffer is inherited from outer");
        }
        this._byteBuffer = byteBuffer;
        this._outerOffset = n;
        return this;
    }

    public final Struct setByteBufferPosition(int n) {
        return this.setByteBuffer(this.getByteBuffer(), n);
    }

    public final int getByteBufferPosition() {
        return this._outer != null ? this._outer.getByteBufferPosition() + this._outerOffset : this._outerOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(InputStream inputStream) throws IOException {
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (byteBuffer.hasArray()) {
            int n = byteBuffer.arrayOffset() + this.getByteBufferPosition();
            return inputStream.read(byteBuffer.array(), n, this.size());
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        synchronized (byteBuffer2) {
            if (this._bytes == null) {
                this._bytes = new byte[this.size()];
            }
            int n = inputStream.read(this._bytes);
            byteBuffer.position(this.getByteBufferPosition());
            byteBuffer.put(this._bytes);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream) throws IOException {
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (byteBuffer.hasArray()) {
            int n = byteBuffer.arrayOffset() + this.getByteBufferPosition();
            outputStream.write(byteBuffer.array(), n, this.size());
        } else {
            ByteBuffer byteBuffer2 = byteBuffer;
            synchronized (byteBuffer2) {
                if (this._bytes == null) {
                    this._bytes = new byte[this.size()];
                }
                byteBuffer.position(this.getByteBufferPosition());
                byteBuffer.get(this._bytes);
                outputStream.write(this._bytes);
            }
        }
    }

    public final long address() {
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (ADDRESS_METHOD != null) {
            Long l = (Long)ADDRESS_METHOD.invoke(byteBuffer);
            return l + (long)this.getByteBufferPosition();
        }
        throw new UnsupportedOperationException("Operation not supported for " + byteBuffer.getClass());
    }

    public String toString() {
        int n = this.size();
        StringBuffer stringBuffer = new StringBuffer(n * 3);
        ByteBuffer byteBuffer = this.getByteBuffer();
        int n2 = this.getByteBufferPosition();
        for (int i = 0; i < n; ++i) {
            int n3 = byteBuffer.get(n2 + i) & 0xFF;
            stringBuffer.append(HEXA[n3 >> 4]);
            stringBuffer.append(HEXA[n3 & 0xF]);
            stringBuffer.append((i & 0xF) == 15 ? (char)'\n' : ' ');
        }
        return stringBuffer.toString();
    }

    public boolean isUnion() {
        return false;
    }

    public ByteOrder byteOrder() {
        return this._outer != null ? this._outer.byteOrder() : ByteOrder.BIG_ENDIAN;
    }

    public boolean isPacked() {
        return this._outer != null ? this._outer.isPacked() : false;
    }

    protected <S extends Struct> S inner(S s) {
        if (s._outer != null) {
            throw new IllegalArgumentException("struct: Already an inner struct");
        }
        s._outer = this;
        int n = s.size() << 3;
        this.updateIndexes(s._alignment, n, n);
        s._outerOffset = this._bitIndex - n >> 3;
        return s;
    }

    protected <S extends Struct> S[] array(S[] SArray) {
        Class clazz = null;
        boolean bl = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        int n = 0;
        while (n < SArray.length) {
            Object object = SArray[n];
            if (object == null) {
                try {
                    String string;
                    String string2;
                    if (clazz == null && (clazz = Reflection.getClass(string2 = (string = SArray.getClass().getName()).substring(2, string.length() - 1))) == null) {
                        throw new JavolutionError("Struct class: " + string2 + " not found");
                    }
                    object = (Struct)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new JavolutionError(exception);
                }
            }
            SArray[n++] = this.inner(object);
        }
        this._resetIndex = bl;
        return (Struct[])SArray;
    }

    protected <S extends Struct> S[][] array(S[][] SArray) {
        boolean bl = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < SArray.length; ++i) {
            this.array((Struct[])SArray[i]);
        }
        this._resetIndex = bl;
        return (Struct[][])SArray;
    }

    protected <S extends Struct> S[][][] array(S[][][] SArray) {
        boolean bl = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < SArray.length; ++i) {
            this.array((Struct[][])SArray[i]);
        }
        this._resetIndex = bl;
        return (Struct[][][])SArray;
    }

    protected <M extends Member> M[] array(M[] MArray) {
        boolean bl = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        if (BOOL.isInstance(MArray)) {
            int n = 0;
            while (n < MArray.length) {
                MArray[n++] = new Bool();
            }
        } else if (SIGNED_8.isInstance(MArray)) {
            int n = 0;
            while (n < MArray.length) {
                MArray[n++] = new Signed8();
            }
        } else if (UNSIGNED_8.isInstance(MArray)) {
            int n = 0;
            while (n < MArray.length) {
                MArray[n++] = new Unsigned8();
            }
        } else if (SIGNED_16.isInstance(MArray)) {
            int n = 0;
            while (n < MArray.length) {
                MArray[n++] = new Signed16();
            }
        } else if (UNSIGNED_16.isInstance(MArray)) {
            int n = 0;
            while (n < MArray.length) {
                MArray[n++] = new Unsigned16();
            }
        } else if (SIGNED_32.isInstance(MArray)) {
            int n = 0;
            while (n < MArray.length) {
                MArray[n++] = new Signed32();
            }
        } else if (UNSIGNED_32.isInstance(MArray)) {
            int n = 0;
            while (n < MArray.length) {
                MArray[n++] = new Unsigned32();
            }
        } else if (SIGNED_64.isInstance(MArray)) {
            int n = 0;
            while (n < MArray.length) {
                MArray[n++] = new Signed64();
            }
        } else if (FLOAT_32.isInstance(MArray)) {
            int n = 0;
            while (n < MArray.length) {
                MArray[n++] = new Float32();
            }
        } else if (FLOAT_64.isInstance(MArray)) {
            int n = 0;
            while (n < MArray.length) {
                MArray[n++] = new Float64();
            }
        } else {
            throw new UnsupportedOperationException("Cannot create member elements, the arrayMember should contain the member instances instead of null");
        }
        this._resetIndex = bl;
        return (Member[])MArray;
    }

    protected <M extends Member> M[][] array(M[][] MArray) {
        boolean bl = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < MArray.length; ++i) {
            this.array((Member[])MArray[i]);
        }
        this._resetIndex = bl;
        return (Member[][])MArray;
    }

    protected <M extends Member> M[][][] array(M[][][] MArray) {
        boolean bl = this._resetIndex;
        if (this._resetIndex) {
            this._bitIndex = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < MArray.length; ++i) {
            this.array((Member[][])MArray[i]);
        }
        this._resetIndex = bl;
        return (Member[][][])MArray;
    }

    protected UTF8String[] array(UTF8String[] uTF8StringArray, int n) {
        for (int i = 0; i < uTF8StringArray.length; ++i) {
            uTF8StringArray[i] = new UTF8String(n);
        }
        return uTF8StringArray;
    }

    private int updateIndexes(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n2 > n3) {
            throw new IllegalArgumentException("nbrOfBits: " + n2 + " exceeds capacity: " + n3);
        }
        if (this._resetIndex) {
            this._bitIndex = 0;
        }
        this._bitIndex = n3 < (n5 = this._bitIndex - ((n4 = this._bitIndex / ((n = this.isPacked() ? 1 : n) << 3) * n) << 3)) + n2 || n2 == 0 && n5 != 0 ? ((n4 += n) << 3) + n2 : (this._bitIndex += n2);
        if (this._bitsUsed < this._bitIndex) {
            this._bitsUsed = this._bitIndex;
        }
        if (this._alignment < n) {
            this._alignment = MathLib.min(n, MAXIMUM_ALIGNMENT.get());
        }
        return n4;
    }

    public class Enum64
    extends Member {
        private final long _mask;
        private final int _shift;
        private final int _signShift;
        private final List _enumValues;

        public Enum64(List list) {
            this(list, 64);
        }

        public Enum64(List list, int n) {
            super(8, n, 64);
            this._enumValues = list;
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 64 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = n == 64 ? -1L : (1L << n) - 1L << this._shift;
            this._signShift = 64 - this._shift - n;
        }

        public Enum get() {
            if (this._mask == -1L) {
                return (Enum)this._enumValues.get((int)Struct.this.getByteBuffer().getLong(this.position()));
            }
            long l = Struct.this.getByteBuffer().getLong(this.position());
            l &= this._mask;
            l <<= this._signShift;
            return (Enum)this._enumValues.get((int)(l >>= this._signShift + this._shift));
        }

        public void set(Enum enum_) {
            int n = enum_.ordinal();
            if (this._enumValues.get(n) != enum_) {
                throw new IllegalArgumentException("enum: " + enum_ + ", ordinal value does not reflect enum values position");
            }
            long l = n;
            if (this._mask == -1L) {
                Struct.this.getByteBuffer().putLong(this.position(), l);
            } else {
                l <<= this._shift;
                long l2 = Struct.this.getByteBuffer().getLong(this.position()) & (this._mask ^ 0xFFFFFFFFFFFFFFFFL);
                Struct.this.getByteBuffer().putLong(this.position(), l2 | (l &= this._mask));
            }
        }
    }

    public class Enum32
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;
        private final List _enumValues;

        public Enum32(List list) {
            this(list, 32);
        }

        public Enum32(List list, int n) {
            super(4, n, 32);
            this._enumValues = list;
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 32 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = n == 32 ? -1 : (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public Enum get() {
            if (this._mask == -1) {
                return (Enum)this._enumValues.get(Struct.this.getByteBuffer().getInt(this.position()));
            }
            int n = Struct.this.getByteBuffer().getInt(this.position());
            n &= this._mask;
            n <<= this._signShift;
            return (Enum)this._enumValues.get(n >>= this._signShift + this._shift);
        }

        public void set(Enum enum_) {
            int n = enum_.ordinal();
            if (this._enumValues.get(n) != enum_) {
                throw new IllegalArgumentException("enum: " + enum_ + ", ordinal value does not reflect enum values position");
            }
            int n2 = n;
            if (this._mask == -1) {
                Struct.this.getByteBuffer().putInt(this.position(), n2);
            } else {
                n2 <<= this._shift;
                int n3 = Struct.this.getByteBuffer().getInt(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putInt(this.position(), n3 | (n2 &= this._mask));
            }
        }
    }

    public class Enum16
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;
        private final List _enumValues;

        public Enum16(List list) {
            this(list, 16);
        }

        public Enum16(List list, int n) {
            super(2, n, 16);
            this._enumValues = list;
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 16 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public Enum get() {
            if (this._mask == 65535) {
                return (Enum)this._enumValues.get(Struct.this.getByteBuffer().getShort(this.position()));
            }
            int n = Struct.this.getByteBuffer().getShort(this.position());
            n &= this._mask;
            n <<= this._signShift;
            return (Enum)this._enumValues.get(n >>= this._signShift + this._shift);
        }

        public void set(Enum enum_) {
            int n = enum_.ordinal();
            if (this._enumValues.get(n) != enum_) {
                throw new IllegalArgumentException("enum: " + enum_ + ", ordinal value does not reflect enum values position");
            }
            short s = (short)n;
            if (this._mask == 65535) {
                Struct.this.getByteBuffer().putShort(this.position(), s);
            } else {
                s = (short)(s << this._shift);
                s = (short)(s & this._mask);
                int n2 = Struct.this.getByteBuffer().getShort(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putShort(this.position(), (short)(n2 | s));
            }
        }
    }

    public class Enum8
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;
        private final List _enumValues;

        public Enum8(List list) {
            this(list, 8);
        }

        public Enum8(List list, int n) {
            super(1, n, 8);
            this._enumValues = list;
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public Enum get() {
            if (this._mask == 255) {
                return (Enum)this._enumValues.get(Struct.this.getByteBuffer().get(this.position()));
            }
            int n = Struct.this.getByteBuffer().get(this.position());
            n &= this._mask;
            n <<= this._signShift;
            return (Enum)this._enumValues.get(n >>= this._signShift + this._shift);
        }

        public void set(Enum enum_) {
            int n = enum_.ordinal();
            if (this._enumValues.get(n) != enum_) {
                throw new IllegalArgumentException("enum: " + enum_ + ", ordinal value does not reflect enum values position");
            }
            byte by = (byte)n;
            if (this._mask == 255) {
                Struct.this.getByteBuffer().put(this.position(), by);
            } else {
                by = (byte)(by << this._shift);
                by = (byte)(by & this._mask);
                int n2 = Struct.this.getByteBuffer().get(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().put(this.position(), (byte)(n2 | by));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Reference64<S extends Struct>
    extends Member {
        private S _struct;

        public Reference64() {
            super(8, 8);
        }

        public void set(S s) {
            if (s != null) {
                Struct.this.getByteBuffer().putLong(this.position(), ((Struct)s).address());
            } else if (s == null) {
                Struct.this.getByteBuffer().putLong(this.position(), 0L);
            }
            this._struct = s;
        }

        public S get() {
            return this._struct;
        }

        public long value() {
            return Struct.this.getByteBuffer().getLong(this.position());
        }

        public boolean isUpToDate() {
            if (this._struct != null) {
                return Struct.this.getByteBuffer().getLong(this.position()) == ((Struct)this._struct).address();
            }
            return Struct.this.getByteBuffer().getLong(this.position()) == 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Reference32<S extends Struct>
    extends Member {
        private S _struct;

        public Reference32() {
            super(4, 4);
        }

        public void set(S s) {
            if (s != null) {
                Struct.this.getByteBuffer().putInt(this.position(), (int)((Struct)s).address());
            } else {
                Struct.this.getByteBuffer().putInt(this.position(), 0);
            }
            this._struct = s;
        }

        public S get() {
            return this._struct;
        }

        public int value() {
            return Struct.this.getByteBuffer().getInt(this.position());
        }

        public boolean isUpToDate() {
            if (this._struct != null) {
                return Struct.this.getByteBuffer().getInt(this.position()) == (int)((Struct)this._struct).address();
            }
            return Struct.this.getByteBuffer().getInt(this.position()) == 0;
        }
    }

    public class Float64
    extends Member {
        public Float64() {
            super(8, 8);
        }

        public void set(double d) {
            Struct.this.getByteBuffer().putDouble(this.position(), d);
        }

        public double get() {
            return Struct.this.getByteBuffer().getDouble(this.position());
        }
    }

    public class Float32
    extends Member {
        public Float32() {
            super(4, 4);
        }

        public void set(float f) {
            Struct.this.getByteBuffer().putFloat(this.position(), f);
        }

        public float get() {
            return Struct.this.getByteBuffer().getFloat(this.position());
        }
    }

    public class Signed64
    extends Member {
        private final long _mask;
        private final int _shift;
        private final int _signShift;

        public Signed64() {
            this(64);
        }

        public Signed64(int n) {
            super(8, n, 64);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 64 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = n == 64 ? -1L : (1L << n) - 1L << this._shift;
            this._signShift = 64 - this._shift - n;
        }

        public long get() {
            if (this._mask == -1L) {
                return Struct.this.getByteBuffer().getLong(this.position());
            }
            long l = Struct.this.getByteBuffer().getLong(this.position());
            l &= this._mask;
            l <<= this._signShift;
            return l >>= this._signShift + this._shift;
        }

        public void set(long l) {
            if (this._mask == -1L) {
                Struct.this.getByteBuffer().putLong(this.position(), l);
            } else {
                l <<= this._shift;
                long l2 = Struct.this.getByteBuffer().getLong(this.position()) & (this._mask ^ 0xFFFFFFFFFFFFFFFFL);
                Struct.this.getByteBuffer().putLong(this.position(), l2 | (l &= this._mask));
            }
        }
    }

    public class Unsigned32
    extends Member {
        private final int _shift;
        private final long _mask;

        public Unsigned32() {
            this(32);
        }

        public Unsigned32(int n) {
            super(4, n, 32);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 32 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = n == 32 ? 0xFFFFFFFFL : (1L << n) - 1L << this._shift;
        }

        public long get() {
            int n = Struct.this.getByteBuffer().getInt(this.position());
            return ((long)n & this._mask) >>> this._shift;
        }

        public void set(long l) {
            if (this._mask == -1L) {
                Struct.this.getByteBuffer().putInt(this.position(), (int)l);
            } else {
                l <<= this._shift;
                int n = Struct.this.getByteBuffer().getInt(this.position()) & ~((int)this._mask);
                Struct.this.getByteBuffer().putInt(this.position(), (int)((long)n | (l &= this._mask)));
            }
        }
    }

    public class Signed32
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;

        public Signed32() {
            this(32);
        }

        public Signed32(int n) {
            super(4, n, 32);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 32 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = n == 32 ? -1 : (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public int get() {
            if (this._mask == -1) {
                return Struct.this.getByteBuffer().getInt(this.position());
            }
            int n = Struct.this.getByteBuffer().getInt(this.position());
            n &= this._mask;
            n <<= this._signShift;
            return n >>= this._signShift + this._shift;
        }

        public void set(int n) {
            if (this._mask == -1) {
                Struct.this.getByteBuffer().putInt(this.position(), n);
            } else {
                n <<= this._shift;
                int n2 = Struct.this.getByteBuffer().getInt(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putInt(this.position(), n2 | (n &= this._mask));
            }
        }
    }

    public class Unsigned16
    extends Member {
        private final int _shift;
        private final int _mask;

        public Unsigned16() {
            this(16);
        }

        public Unsigned16(int n) {
            super(2, n, 16);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 16 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
        }

        public int get() {
            short s = Struct.this.getByteBuffer().getShort(this.position());
            return (s & this._mask) >>> this._shift;
        }

        public void set(int n) {
            if (this._mask == 65535) {
                Struct.this.getByteBuffer().putShort(this.position(), (short)n);
            } else {
                n <<= this._shift;
                int n2 = Struct.this.getByteBuffer().getShort(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putShort(this.position(), (short)(n2 | (n &= this._mask)));
            }
        }
    }

    public class Signed16
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;

        public Signed16() {
            this(16);
        }

        public Signed16(int n) {
            super(2, n, 16);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 16 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public short get() {
            if (this._mask == 65535) {
                return Struct.this.getByteBuffer().getShort(this.position());
            }
            int n = Struct.this.getByteBuffer().getShort(this.position());
            n &= this._mask;
            n <<= this._signShift;
            return (short)(n >>= this._signShift + this._shift);
        }

        public void set(short s) {
            if (this._mask == 65535) {
                Struct.this.getByteBuffer().putShort(this.position(), s);
            } else {
                s = (short)(s << this._shift);
                s = (short)(s & this._mask);
                int n = Struct.this.getByteBuffer().getShort(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().putShort(this.position(), (short)(n | s));
            }
        }
    }

    public class Unsigned8
    extends Member {
        private final int _shift;
        private final int _mask;

        public Unsigned8() {
            this(8);
        }

        public Unsigned8(int n) {
            super(1, n, 8);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
        }

        public short get() {
            byte by = Struct.this.getByteBuffer().get(this.position());
            return (short)((by & this._mask) >>> this._shift);
        }

        public void set(short s) {
            if (this._mask == 255) {
                Struct.this.getByteBuffer().put(this.position(), (byte)s);
            } else {
                s = (short)(s << this._shift);
                s = (short)(s & this._mask);
                int n = Struct.this.getByteBuffer().get(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().put(this.position(), (byte)(n | s));
            }
        }
    }

    public class Signed8
    extends Member {
        private final int _mask;
        private final int _shift;
        private final int _signShift;

        public Signed8() {
            this(8);
        }

        public Signed8(int n) {
            super(1, n, 8);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
            this._signShift = 32 - this._shift - n;
        }

        public byte get() {
            if (this._mask == 255) {
                return Struct.this.getByteBuffer().get(this.position());
            }
            int n = Struct.this.getByteBuffer().get(this.position());
            n &= this._mask;
            n <<= this._signShift;
            return (byte)(n >>= this._signShift + this._shift);
        }

        public void set(byte by) {
            if (this._mask == 255) {
                Struct.this.getByteBuffer().put(this.position(), by);
            } else {
                by = (byte)(by << this._shift);
                by = (byte)(by & this._mask);
                int n = Struct.this.getByteBuffer().get(this.position()) & ~this._mask;
                Struct.this.getByteBuffer().put(this.position(), (byte)(n | by));
            }
        }
    }

    public class Bool
    extends Member {
        private final int _mask;
        private final int _shift;

        public Bool() {
            this(8);
        }

        public Bool(int n) {
            super(1, n, 8);
            int n2 = this.offset() << 3;
            this._shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? 8 - Struct.this._bitIndex + n2 : Struct.this._bitIndex - n2 - n;
            this._mask = (1 << n) - 1 << this._shift;
        }

        public boolean get() {
            return (Struct.this.getByteBuffer().get(this.position()) & this._mask) != 0;
        }

        public void set(boolean bl) {
            if (this._mask == 255) {
                Struct.this.getByteBuffer().put(this.position(), (byte)(bl ? 1 : 0));
            } else {
                int n = Struct.this.getByteBuffer().get(this.position()) & ~this._mask;
                if (bl) {
                    Struct.this.getByteBuffer().put(this.position(), (byte)(n | 1 << this._shift));
                } else {
                    Struct.this.getByteBuffer().put(this.position(), (byte)n);
                }
            }
        }
    }

    public class UTF8String
    extends Member {
        private final UTF8ByteBufferWriter _writer;
        private final UTF8ByteBufferReader _reader;
        private final char[] _chars;
        private final int _length;

        public UTF8String(int n) {
            super(1, n);
            this._writer = new UTF8ByteBufferWriter();
            this._reader = new UTF8ByteBufferReader();
            this._length = n;
            this._chars = new char[n];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(String string) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer = Struct.this.getByteBuffer();
            synchronized (byteBuffer2) {
                try {
                    byteBuffer.position(this.position());
                    this._writer.setOutput(byteBuffer);
                    if (string.length() < this._length) {
                        this._writer.write(string);
                        this._writer.write(0);
                    } else if (string.length() > this._length) {
                        this._writer.write(string.substring(0, this._length));
                    } else {
                        this._writer.write(string);
                    }
                }
                catch (IOException iOException) {
                    throw new JavolutionError(iOException);
                }
                finally {
                    this._writer.reset();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String get() {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer = Struct.this.getByteBuffer();
            synchronized (byteBuffer2) {
                try {
                    byteBuffer.position(this.position());
                    this._reader.setInput(byteBuffer);
                    int n = 0;
                    while (n < this._length) {
                        char c = (char)this._reader.read();
                        if (c == '\u0000') {
                            String string = new String(this._chars, 0, n);
                            return string;
                        }
                        this._chars[n++] = c;
                    }
                    String string = new String(this._chars, 0, this._length);
                    return string;
                }
                catch (IOException iOException) {
                    throw new JavolutionError(iOException);
                }
                finally {
                    this._reader.reset();
                }
            }
        }
    }

    protected class Member {
        private final int _offset;

        protected Member(int n, int n2) {
            int n3 = n2 << 3;
            this._offset = Struct.this.updateIndexes(n, n3, n3);
        }

        Member(int n, int n2, int n3) {
            this._offset = Struct.this.updateIndexes(n, n2, n3);
        }

        public final Struct struct() {
            return Struct.this;
        }

        public final int offset() {
            return this._offset;
        }

        public final int position() {
            return Struct.this.getByteBufferPosition() + this._offset;
        }
    }
}

