/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hbase.shim.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hbase.factory.HBaseClientFactory;
import org.pentaho.hbase.factory.HBaseClientFactoryLocator;
import org.pentaho.hbase.factory.HBasePut;
import org.pentaho.hbase.factory.HBaseTable;
import org.pentaho.hbase.shim.api.ColumnFilter;
import org.pentaho.hbase.shim.api.HBaseValueMeta;
import org.pentaho.hbase.shim.api.Mapping;
import org.pentaho.hbase.shim.common.CommonHBaseBytesUtil;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;
import org.pentaho.hbase.shim.spi.HBaseConnection;

public class CommonHBaseConnection
extends HBaseConnection {
    private static Class<?> PKG = CommonHBaseConnection.class;
    protected org.apache.hadoop.conf.Configuration m_config = null;
    protected org.pentaho.hbase.factory.HBaseAdmin m_admin;
    protected HBaseClientFactory m_factory;
    protected HBaseTable m_sourceTable;
    protected Scan m_sourceScan;
    protected ResultScanner m_resultSet;
    protected Result m_currentResultSetRow;
    protected HBaseTable m_targetTable;
    protected HBasePut m_currentTargetPut;
    protected HBaseBytesUtilShim m_bytesUtil;
    protected LogChannelInterface log = KettleLogStore.getLogChannelInterfaceFactory().create((Object)this);

    public CommonHBaseConnection() {
        try {
            this.getBytesUtil();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureConnection(Properties connProps, List<String> logMessages) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            block15: {
                String defaultConfig = connProps.getProperty("hbase.default");
                String siteConfig = connProps.getProperty("hbase.site");
                String zookeeperQuorum = connProps.getProperty("hbase.zookeeper.quorum");
                String zookeeperPort = connProps.getProperty("hbase.zookeeper.property.clientPort");
                this.m_config = new org.apache.hadoop.conf.Configuration();
                try {
                    if (!CommonHBaseConnection.isEmpty((String)defaultConfig)) {
                        this.m_config.addResource(CommonHBaseConnection.stringToURL((String)defaultConfig));
                    } else {
                        this.m_config.addResource("hbase-default.xml");
                    }
                    if (!CommonHBaseConnection.isEmpty((String)siteConfig)) {
                        this.m_config.addResource(CommonHBaseConnection.stringToURL((String)siteConfig));
                    } else {
                        this.m_config.addResource("hbase-site.xml");
                    }
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(BaseMessages.getString(PKG, (String)"CommonHBaseConnection.Error.MalformedConfigURL", (String[])new String[0]));
                }
                if (!(CommonHBaseConnection.isEmpty((String)zookeeperQuorum) || CommonHBaseConnection.isEmpty((String)this.m_config.get("hbase.zookeeper.quorum")) || this.doZookeeperQuorumInNamedClusterAndConfigMatch(zookeeperQuorum))) {
                    String message = BaseMessages.getString(PKG, (String)"CommonHBaseConnection.Error.MismatchZookeeperNamedClusterVsConfiguration", (String[])new String[]{zookeeperQuorum, this.m_config.get("hbase.zookeeper.quorum")});
                    this.log.logBasic(message);
                }
                if (!CommonHBaseConnection.isEmpty((String)zookeeperQuorum)) {
                    this.m_config.set("hbase.zookeeper.quorum", zookeeperQuorum);
                }
                if (!CommonHBaseConnection.isEmpty((String)zookeeperPort)) {
                    try {
                        int port = Integer.parseInt(zookeeperPort);
                        this.m_config.setInt("hbase.zookeeper.property.clientPort", port);
                    }
                    catch (NumberFormatException e) {
                        if (logMessages == null) break block15;
                        logMessages.add(BaseMessages.getString(PKG, (String)"CommonHBaseConnection.Error.UnableToParseZookeeperPort", (String[])new String[0]));
                    }
                }
            }
            if (this.log.isDebug()) {
                this.log.logDebug("Opening HBase connection ...");
            }
            this.m_factory = this.getHBaseClientFactory(this.m_config);
            this.m_admin = this.m_factory.getHBaseAdmin();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private boolean doZookeeperQuorumInNamedClusterAndConfigMatch(String zookeeperQuorum) {
        return this.allZookeperHostsFromNameNodeInConfigQuorum(zookeeperQuorum) || this.atLeastOneHostFromConfigInNameClusterZookeeperQuorum(zookeeperQuorum);
    }

    private boolean allZookeperHostsFromNameNodeInConfigQuorum(String zookeeperQuorum) {
        String[] quorum = zookeeperQuorum.toLowerCase().split(",");
        String configQuorum = this.m_config.get("hbase.zookeeper.quorum").toLowerCase();
        for (String node : quorum) {
            if ((node = node.trim()).contains(":")) {
                node = node.substring(0, node.indexOf(":"));
            }
            if (configQuorum.contains(node)) continue;
            return false;
        }
        return true;
    }

    private boolean atLeastOneHostFromConfigInNameClusterZookeeperQuorum(String zookeeperQuorum) {
        String[] configZookeeperQuorum = this.m_config.get("hbase.zookeeper.quorum").toLowerCase().split(",");
        String clientZookeeperQuorum = zookeeperQuorum.toLowerCase();
        for (String node : configZookeeperQuorum) {
            if ((node = node.trim()).contains(":")) {
                node = node.substring(0, node.indexOf(":"));
            }
            if (!clientZookeeperQuorum.contains(node)) continue;
            return true;
        }
        return false;
    }

    protected HBaseClientFactory getHBaseClientFactory(org.apache.hadoop.conf.Configuration configuration) {
        return HBaseClientFactoryLocator.getHBaseClientFactory(configuration);
    }

    public HBaseBytesUtilShim getBytesUtil() throws Exception {
        if (this.m_bytesUtil == null) {
            this.m_bytesUtil = new CommonHBaseBytesUtil();
        }
        return this.m_bytesUtil;
    }

    protected void checkConfiguration() throws Exception {
        if (this.m_admin == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CommonHBaseConnection.Error.ConnectionHasNotBeenConfigured", (String[])new String[0]));
        }
    }

    public void checkHBaseAvailable() throws Exception {
        this.checkConfiguration();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            HBaseAdmin.checkHBaseAvailable((org.apache.hadoop.conf.Configuration)this.m_config);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public List<String> listTableNames() throws Exception {
        this.checkConfiguration();
        HTableDescriptor[] tables = this.m_admin.listTables();
        ArrayList<String> tableNames = new ArrayList<String>();
        for (HTableDescriptor h : tables) {
            tableNames.add(h.getNameAsString());
        }
        return tableNames;
    }

    public boolean tableExists(String tableName) throws Exception {
        this.checkConfiguration();
        return this.m_admin.tableExists(tableName);
    }

    public void disableTable(String tableName) throws Exception {
        this.checkConfiguration();
        this.m_admin.disableTable(tableName);
    }

    public void enableTable(String tableName) throws Exception {
        this.checkConfiguration();
        this.m_admin.enableTable(tableName);
    }

    public boolean isTableDisabled(String tableName) throws Exception {
        this.checkConfiguration();
        return this.m_admin.isTableDisabled(tableName);
    }

    public boolean isTableAvailable(String tableName) throws Exception {
        this.checkConfiguration();
        return this.m_admin.isTableAvailable(tableName);
    }

    public void deleteTable(String tableName) throws Exception {
        this.checkConfiguration();
        this.m_admin.deleteTable(tableName);
    }

    public List<String> getTableFamiles(String tableName) throws Exception {
        this.checkConfiguration();
        HTableDescriptor descriptor = this.m_admin.getTableDescriptor(this.m_bytesUtil.toBytes(tableName));
        Collection families = descriptor.getFamilies();
        ArrayList<String> famList = new ArrayList<String>();
        for (HColumnDescriptor h : families) {
            famList.add(h.getNameAsString());
        }
        return famList;
    }

    protected void configureColumnDescriptor(HColumnDescriptor h, Properties p) throws Exception {
        if (p != null) {
            Set<Object> keys = p.keySet();
            for (Object key : keys) {
                Method valueOf;
                String value = p.getProperty(key.toString());
                if (key.toString().equals("col.descriptor.maxVersions")) {
                    h.setMaxVersions(Integer.parseInt(value));
                    continue;
                }
                if (key.toString().equals("col.descriptor.compression")) {
                    Class<?> compressionAlgorithmClass = this.getCompressionAlgorithmClass();
                    valueOf = compressionAlgorithmClass.getMethod("valueOf", String.class);
                    Method setCompressionType = h.getClass().getMethod("setCompressionType", compressionAlgorithmClass);
                    setCompressionType.invoke((Object)h, valueOf.invoke(null, value));
                    continue;
                }
                if (key.toString().equals("col.descriptor.inMemory")) {
                    boolean result = this.toBoolean(value);
                    h.setInMemory(result);
                    continue;
                }
                if (key.toString().equals("col.descriptor.blockCacheEnabled")) {
                    boolean result = this.toBoolean(value);
                    h.setBlockCacheEnabled(result);
                    continue;
                }
                if (key.toString().equals("col.descriptor.blockSize")) {
                    h.setBlocksize(Integer.parseInt(value));
                    continue;
                }
                if (key.toString().equals("col.desciptor.timeToLive")) {
                    h.setTimeToLive(Integer.parseInt(value));
                    continue;
                }
                if (key.toString().equals("col.descriptor.bloomFilter")) {
                    Class<?> bloomTypeClass = this.getBloomTypeClass();
                    valueOf = bloomTypeClass.getMethod("valueOf", String.class);
                    Method setBloomFilterType = h.getClass().getMethod("setBloomFilterType", new Class[0]);
                    setBloomFilterType.invoke((Object)h, valueOf.invoke(null, value));
                    continue;
                }
                if (!key.toString().equals("col.descriptor.scope")) continue;
                h.setScope(Integer.parseInt(value));
            }
        }
    }

    protected void checkSourceTable() throws Exception {
        if (this.m_sourceTable == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CommonHBaseConnection.Error.NoSourceTable", (String[])new String[0]));
        }
    }

    protected void checkSourceScan() throws Exception {
        if (this.m_sourceScan == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CommonHBaseConnection.Error.NoSourceScan", (String[])new String[0]));
        }
    }

    public void createTable(String tableName, List<String> colFamilyNames, Properties creationProps) throws Exception {
        this.checkConfiguration();
        HTableDescriptor tableDescription = this.m_factory.getHBaseTableDescriptor(tableName);
        for (String familyName : colFamilyNames) {
            HColumnDescriptor c = new HColumnDescriptor(familyName);
            this.configureColumnDescriptor(c, creationProps);
            tableDescription.addFamily(c);
        }
        this.m_admin.createTable(tableDescription);
    }

    public void newSourceTable(String tableName) throws Exception {
        this.checkConfiguration();
        this.closeSourceTable();
        this.m_sourceTable = this.m_factory.getHBaseTable(tableName);
    }

    public boolean sourceTableRowExists(byte[] rowKey) throws Exception {
        this.checkConfiguration();
        this.checkSourceTable();
        Get g = new Get(rowKey);
        Result r = this.m_sourceTable.get(g);
        return !r.isEmpty();
    }

    public void newSourceTableScan(byte[] keyLowerBound, byte[] keyUpperBound, int cacheSize) throws Exception {
        this.checkConfiguration();
        this.checkSourceTable();
        this.closeSourceResultSet();
        this.m_sourceScan = keyLowerBound != null ? (keyUpperBound != null ? new Scan(keyLowerBound, keyUpperBound) : new Scan(keyLowerBound)) : new Scan();
        if (cacheSize > 0) {
            this.m_sourceScan.setCaching(cacheSize);
        }
    }

    public void addColumnToScan(String colFamilyName, String colName, boolean colNameIsBinary) throws Exception {
        this.checkSourceScan();
        this.m_sourceScan.addColumn(this.m_bytesUtil.toBytes(colFamilyName), colNameIsBinary ? this.m_bytesUtil.toBytesBinary(colName) : this.m_bytesUtil.toBytes(colName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumnFilterToScan(ColumnFilter cf, HBaseValueMeta columnMeta, VariableSpace vars, boolean matchAny) throws Exception {
        this.checkSourceScan();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.createEmptyFilterIfNull(matchAny);
            FilterList fl = (FilterList)this.m_sourceScan.getFilter();
            ColumnFilter.ComparisonType op = cf.getComparisonOperator();
            CompareFilter.CompareOp comp = this.getCompareOpByComparisonType(op);
            String comparisonString = cf.getConstant().trim();
            comparisonString = vars.environmentSubstitute(comparisonString);
            byte[] comparison = this.m_bytesUtil.toBytes(comparisonString);
            Class<Object> comparatorClass = this.getByteArrayComparableClass();
            Object comparator = null;
            if (comp != null) {
                if (columnMeta.isNumeric()) {
                    if (!cf.getSignedComparison() && columnMeta.isInteger()) {
                        comparatorClass = byte[].class;
                    }
                    comparator = this.getNumericComparator(cf, columnMeta, vars, comparisonString);
                } else if (columnMeta.isDate()) {
                    comparator = this.getDateComparator(cf, vars, comparisonString);
                } else if (columnMeta.isBoolean()) {
                    byte[] tempEncoded = this.m_bytesUtil.toBytes(comparisonString);
                    Boolean decodedB = HBaseValueMeta.decodeBoolFromString((byte[])tempEncoded, (HBaseBytesUtilShim)this.m_bytesUtil);
                    if (decodedB == null) {
                        return;
                    }
                    comparator = this.getBooleanComparator(decodedB);
                }
            } else {
                comp = CompareFilter.CompareOp.EQUAL;
                if (cf.getComparisonOperator() == ColumnFilter.ComparisonType.SUBSTRING) {
                    comparator = new SubstringComparator(comparisonString);
                } else if (cf.getComparisonOperator() == ColumnFilter.ComparisonType.REGEX) {
                    comparator = new RegexStringComparator(comparisonString);
                } else {
                    if (columnMeta.isKey()) {
                        PrefixFilter scf = new PrefixFilter(comparison);
                        fl.addFilter((Filter)scf);
                        return;
                    }
                    comparator = new BinaryPrefixComparator(comparison);
                }
            }
            if (comparator != null) {
                Mapping.TupleMapping tupleMapping = this.getTupleMappingByName(cf.getFieldAlias().toUpperCase());
                if (tupleMapping != null) {
                    this.addFilterByMapping(fl, comp, comparatorClass, comparator, tupleMapping);
                    return;
                }
                byte[] family = this.m_bytesUtil.toBytes(columnMeta.getColumnFamily());
                byte[] qualifier = this.m_bytesUtil.toBytes(columnMeta.getColumnName());
                Constructor scvfCtor = SingleColumnValueFilter.class.getConstructor(byte[].class, byte[].class, CompareFilter.CompareOp.class, comparatorClass);
                SingleColumnValueFilter scf = (SingleColumnValueFilter)scvfCtor.newInstance(family, qualifier, comp, comparator);
                scf.setFilterIfMissing(true);
                fl.addFilter((Filter)scf);
            } else if (columnMeta.isKey()) {
                PrefixFilter scf = new PrefixFilter(comparison);
                fl.addFilter((Filter)scf);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    protected Object getNumericComparator(ColumnFilter cf, HBaseValueMeta columnMeta, VariableSpace vars, String comparisonString) throws Exception {
        DecimalFormat df = new DecimalFormat();
        String formatS = vars.environmentSubstitute(cf.getFormat());
        if (!CommonHBaseConnection.isEmpty((String)formatS)) {
            df.applyPattern(formatS);
        }
        Number num = df.parse(comparisonString);
        Object comparator = cf.getSignedComparison() ? this.getSignedComparisonComparator(columnMeta, num) : (columnMeta.isInteger() ? (!columnMeta.getIsLongOrDouble() ? (Object)this.m_bytesUtil.toBytes(num.intValue()) : (Object)this.m_bytesUtil.toBytes(num.longValue())) : (!columnMeta.getIsLongOrDouble() ? (Object)this.m_bytesUtil.toBytes(num.floatValue()) : (Object)this.m_bytesUtil.toBytes(num.doubleValue())));
        return comparator;
    }

    protected Object getBooleanComparator(Boolean decodedB) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> deserializedBooleanComparatorClass = this.getDeserializedBooleanComparatorClass();
        Constructor<?> ctor = deserializedBooleanComparatorClass.getConstructor(Boolean.TYPE);
        return ctor.newInstance(decodedB);
    }

    protected Object getDateComparator(ColumnFilter cf, VariableSpace vars, String comparisonString) throws ParseException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object comparator;
        SimpleDateFormat sdf = new SimpleDateFormat();
        String formatS = vars.environmentSubstitute(cf.getFormat());
        if (!CommonHBaseConnection.isEmpty((String)formatS)) {
            sdf.applyPattern(formatS);
        }
        Date d = sdf.parse(comparisonString);
        long dateAsMillis = d.getTime();
        if (!cf.getSignedComparison()) {
            comparator = this.m_bytesUtil.toBytes(dateAsMillis);
        } else {
            Class<?> deserializedNumericComparatorClass = this.getDeserializedNumericComparatorClass();
            Constructor<?> ctor = deserializedNumericComparatorClass.getConstructor(Boolean.TYPE, Boolean.TYPE, Long.TYPE);
            comparator = ctor.newInstance(true, true, dateAsMillis);
        }
        return comparator;
    }

    protected Object getSignedComparisonComparator(HBaseValueMeta columnMeta, Number num) throws Exception {
        Object comparator;
        Class<?> deserializedNumericComparatorClass = this.getDeserializedNumericComparatorClass();
        if (columnMeta.isInteger()) {
            Constructor<?> ctor = deserializedNumericComparatorClass.getConstructor(Boolean.TYPE, Boolean.TYPE, Long.TYPE);
            comparator = columnMeta.getIsLongOrDouble() ? ctor.newInstance(columnMeta.isInteger(), columnMeta.getIsLongOrDouble(), num.longValue()) : ctor.newInstance(columnMeta.isInteger(), columnMeta.getIsLongOrDouble(), num.intValue());
        } else {
            Constructor<?> ctor = deserializedNumericComparatorClass.getConstructor(Boolean.TYPE, Boolean.TYPE, Double.TYPE);
            comparator = columnMeta.getIsLongOrDouble() ? ctor.newInstance(columnMeta.isInteger(), columnMeta.getIsLongOrDouble(), num.doubleValue()) : ctor.newInstance(columnMeta.isInteger(), columnMeta.getIsLongOrDouble(), num.floatValue());
        }
        return comparator;
    }

    void addFilterByMapping(FilterList fl, CompareFilter.CompareOp comp, Class<?> comparatorClass, Object comparator, Mapping.TupleMapping tupleMapping) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        switch (tupleMapping) {
            case KEY: {
                this.addFilter(RowFilter.class, fl, comp, comparatorClass, comparator);
                return;
            }
            case FAMILY: {
                this.addFilter(FamilyFilter.class, fl, comp, comparatorClass, comparator);
                return;
            }
            case COLUMN: {
                this.addFilter(QualifierFilter.class, fl, comp, comparatorClass, comparator);
                return;
            }
            case VALUE: {
                this.addFilter(ValueFilter.class, fl, comp, comparatorClass, comparator);
                return;
            }
            case TIMESTAMP: {
                this.addFilter(TimestampsFilter.class, fl, comp, comparatorClass, comparator);
                return;
            }
        }
    }

    protected <T extends Filter> void addFilter(Class<T> filterClass, FilterList fl, CompareFilter.CompareOp comp, Class<?> comparatorClass, Object comparator) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<T> constructor = filterClass.getConstructor(CompareFilter.CompareOp.class, comparatorClass);
        Filter scf = (Filter)constructor.newInstance(comp, comparator);
        fl.addFilter(scf);
    }

    protected Mapping.TupleMapping getTupleMappingByName(String name) {
        Mapping.TupleMapping tupleMapping;
        try {
            tupleMapping = Mapping.TupleMapping.valueOf((String)name);
        }
        catch (IllegalArgumentException ignored) {
            tupleMapping = null;
        }
        return tupleMapping;
    }

    protected void createEmptyFilterIfNull(boolean matchAny) {
        if (this.m_sourceScan.getFilter() == null) {
            FilterList fl = new FilterList(matchAny ? FilterList.Operator.MUST_PASS_ONE : FilterList.Operator.MUST_PASS_ALL);
            this.m_sourceScan.setFilter((Filter)fl);
        }
    }

    protected CompareFilter.CompareOp getCompareOpByComparisonType(ColumnFilter.ComparisonType op) {
        CompareFilter.CompareOp comp;
        switch (op) {
            case EQUAL: {
                comp = CompareFilter.CompareOp.EQUAL;
                break;
            }
            case NOT_EQUAL: {
                comp = CompareFilter.CompareOp.NOT_EQUAL;
                break;
            }
            case GREATER_THAN: {
                comp = CompareFilter.CompareOp.GREATER;
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                comp = CompareFilter.CompareOp.GREATER_OR_EQUAL;
                break;
            }
            case LESS_THAN: {
                comp = CompareFilter.CompareOp.LESS;
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                comp = CompareFilter.CompareOp.LESS_OR_EQUAL;
                break;
            }
            default: {
                comp = null;
            }
        }
        return comp;
    }

    public Class<?> getByteArrayComparableClass() throws ClassNotFoundException {
        return Class.forName("org.apache.hadoop.hbase.filter.WritableByteArrayComparable");
    }

    public Class<?> getCompressionAlgorithmClass() throws ClassNotFoundException {
        return Class.forName("org.apache.hadoop.hbase.io.hfile.Compression$Algorithm");
    }

    public Class<?> getBloomTypeClass() throws ClassNotFoundException {
        return Class.forName("org.apache.hadoop.hbase.regionserver.StoreFile$BloomType");
    }

    public Class<?> getDeserializedNumericComparatorClass() throws ClassNotFoundException {
        return Class.forName("org.pentaho.hbase.shim.common.DeserializedNumericComparator");
    }

    public Class<?> getDeserializedBooleanComparatorClass() throws ClassNotFoundException {
        return Class.forName("org.pentaho.hbase.shim.common.DeserializedBooleanComparator");
    }

    protected void checkResultSet() throws Exception {
        if (this.m_resultSet == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CommonHBaseConnection.Error.NoCurrentResultSet", (String[])new String[0]));
        }
    }

    protected void checkForCurrentResultSetRow() throws Exception {
        if (this.m_currentResultSetRow == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CommonHBaseConnection.Error.NoCurrentResultSetRow", (String[])new String[0]));
        }
    }

    public void executeSourceTableScan() throws Exception {
        this.checkConfiguration();
        this.checkSourceTable();
        this.checkSourceScan();
        if (this.m_sourceScan.getFilter() != null && ((FilterList)this.m_sourceScan.getFilter()).getFilters().size() == 0) {
            this.m_sourceScan.setFilter(null);
        }
        this.m_resultSet = this.m_sourceTable.getScanner(this.m_sourceScan);
    }

    public boolean resultSetNextRow() throws Exception {
        this.checkResultSet();
        this.m_currentResultSetRow = this.m_resultSet.next();
        return this.m_currentResultSetRow != null;
    }

    public boolean checkForHBaseRow(Object rowToCheck) {
        return rowToCheck instanceof Result;
    }

    public byte[] getRowKey(Object aRow) throws Exception {
        if (!this.checkForHBaseRow(aRow)) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CommonHBaseConnection.Error.ObjectIsNotAnHBaseRow", (String[])new String[0]));
        }
        return ((Result)aRow).getRow();
    }

    public byte[] getResultSetCurrentRowKey() throws Exception {
        this.checkSourceScan();
        this.checkResultSet();
        this.checkForCurrentResultSetRow();
        return this.getRowKey(this.m_currentResultSetRow);
    }

    public byte[] getRowColumnLatest(Object aRow, String colFamilyName, String colName, boolean colNameIsBinary) throws Exception {
        if (!this.checkForHBaseRow(aRow)) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CommonHBaseConnection.Error.ObjectIsNotAnHBaseRow", (String[])new String[0]));
        }
        byte[] result = ((Result)aRow).getValue(this.m_bytesUtil.toBytes(colFamilyName), colNameIsBinary ? this.m_bytesUtil.toBytesBinary(colName) : this.m_bytesUtil.toBytes(colName));
        return result;
    }

    public byte[] getResultSetCurrentRowColumnLatest(String colFamilyName, String colName, boolean colNameIsBinary) throws Exception {
        this.checkSourceScan();
        this.checkResultSet();
        this.checkForCurrentResultSetRow();
        return this.getRowColumnLatest(this.m_currentResultSetRow, colFamilyName, colName, colNameIsBinary);
    }

    public NavigableMap<byte[], byte[]> getRowFamilyMap(Object aRow, String familyName) throws Exception {
        if (!this.checkForHBaseRow(aRow)) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CommonHBaseConnection.Error.ObjectIsNotAnHBaseRow", (String[])new String[0]));
        }
        return ((Result)aRow).getFamilyMap(this.m_bytesUtil.toBytes(familyName));
    }

    public NavigableMap<byte[], byte[]> getResultSetCurrentRowFamilyMap(String familyName) throws Exception {
        this.checkSourceScan();
        this.checkResultSet();
        this.checkForCurrentResultSetRow();
        return this.getRowFamilyMap(this.m_currentResultSetRow, familyName);
    }

    public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getRowMap(Object aRow) throws Exception {
        if (!this.checkForHBaseRow(aRow)) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CommonHBaseConnection.Error.ObjectIsNotAnHBaseRow", (String[])new String[0]));
        }
        return ((Result)aRow).getMap();
    }

    public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getResultSetCurrentRowMap() throws Exception {
        this.checkSourceScan();
        this.checkResultSet();
        this.checkForCurrentResultSetRow();
        return this.getRowMap(this.m_currentResultSetRow);
    }

    protected void checkTargetTable() throws Exception {
        if (this.m_targetTable == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CommonHBaseConnection.Error.NoTargetTable", (String[])new String[0]));
        }
    }

    protected void checkTargetPut() throws Exception {
        if (this.m_currentTargetPut == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CommonHBaseConnection.Error.NoTargetPut", (String[])new String[0]));
        }
    }

    public void newTargetTable(String tableName, Properties props) throws Exception {
        this.checkConfiguration();
        this.closeTargetTable();
        this.m_targetTable = this.m_factory.getHBaseTable(tableName);
        if (props != null) {
            Set<Object> keys = props.keySet();
            for (Object key : keys) {
                String value = props.getProperty(key.toString());
                if (!key.toString().equals("htable.writeBufferSize")) continue;
                this.m_targetTable.setWriteBufferSize(Long.parseLong(value));
                this.m_targetTable.setAutoFlush(false);
            }
        }
    }

    public boolean targetTableIsAutoFlush() throws Exception {
        this.checkTargetTable();
        return this.m_targetTable.isAutoFlush();
    }

    public void newTargetTablePut(byte[] key, boolean writeToWAL) throws Exception {
        this.checkTargetTable();
        this.m_currentTargetPut = this.m_factory.getHBasePut(key);
        this.m_currentTargetPut.setWriteToWAL(writeToWAL);
    }

    public void executeTargetTablePut() throws Exception {
        this.checkConfiguration();
        this.checkTargetTable();
        this.checkTargetPut();
        this.m_targetTable.put(this.m_currentTargetPut);
    }

    public void executeTargetTableDelete(byte[] rowKey) throws Exception {
        this.checkConfiguration();
        this.checkTargetTable();
        Delete d = new Delete(rowKey);
        this.m_targetTable.delete(d);
    }

    public void flushCommitsTargetTable() throws Exception {
        this.checkConfiguration();
        this.checkTargetTable();
        this.m_targetTable.flushCommits();
    }

    public void addColumnToTargetPut(String columnFamily, String columnName, boolean colNameIsBinary, byte[] colValue) throws Exception {
        this.checkTargetTable();
        this.checkTargetPut();
        this.m_currentTargetPut.addColumn(this.m_bytesUtil.toBytes(columnFamily), colNameIsBinary ? this.m_bytesUtil.toBytesBinary(columnName) : this.m_bytesUtil.toBytes(columnName), colValue);
    }

    public void closeTargetTable() throws Exception {
        this.checkConfiguration();
        if (this.m_targetTable != null) {
            if (!this.m_targetTable.isAutoFlush()) {
                this.flushCommitsTargetTable();
            }
            this.m_targetTable.close();
            this.m_targetTable = null;
        }
    }

    public void closeSourceResultSet() throws Exception {
        this.checkConfiguration();
        if (this.m_resultSet != null) {
            this.m_resultSet.close();
            this.m_resultSet = null;
            this.m_currentResultSetRow = null;
        }
    }

    public void closeSourceTable() throws Exception {
        this.checkConfiguration();
        this.closeSourceResultSet();
        if (this.m_sourceTable != null) {
            this.m_sourceTable.close();
            this.m_sourceTable = null;
        }
    }

    public boolean isImmutableBytesWritable(Object o) {
        return o instanceof ImmutableBytesWritable;
    }

    public void close() throws Exception {
        if (this.log.isDebug()) {
            this.log.logDebug("Closing HBase connection ...");
        }
        this.closeTargetTable();
        this.closeSourceResultSet();
        this.closeSourceTable();
        this.closeClientFactory();
    }

    void closeClientFactory() {
        if (this.m_factory != null) {
            this.m_factory.close();
        }
        this.m_factory = null;
    }

    protected boolean toBoolean(String value) {
        return value.toLowerCase().equals("y") || value.toLowerCase().equals("yes") || value.toLowerCase().equals("true");
    }

    public void obtainAuthTokenForJob(Configuration conf) throws Exception {
    }
}

