/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.backup.util.BackupClientUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class BackupSystemTableHelper {
    private static final String BACKUP_INFO_PREFIX = "session:";
    private static final String START_CODE_ROW = "startcode:";
    private static final String INCR_BACKUP_SET = "incrbackupset:";
    private static final String TABLE_RS_LOG_MAP_PREFIX = "trslm:";
    private static final String RS_LOG_TS_PREFIX = "rslogts:";
    private static final String WALS_PREFIX = "wals:";
    private static final String SET_KEY_PREFIX = "backupset:";
    private static final byte[] EMPTY_VALUE = new byte[0];
    private static final String NULL = "\u0000";

    private BackupSystemTableHelper() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    static Put createPutForBackupContext(BackupInfo context) throws IOException {
        Put put = new Put(BackupSystemTableHelper.rowkey(BACKUP_INFO_PREFIX, context.getBackupId()));
        put.addColumn(BackupSystemTable.SESSIONS_FAMILY, "context".getBytes(), context.toByteArray());
        return put;
    }

    static Get createGetForBackupContext(String backupId) throws IOException {
        Get get = new Get(BackupSystemTableHelper.rowkey(BACKUP_INFO_PREFIX, backupId));
        get.addFamily(BackupSystemTable.SESSIONS_FAMILY);
        get.setMaxVersions(1);
        return get;
    }

    public static Delete createDeleteForBackupInfo(String backupId) {
        Delete del = new Delete(BackupSystemTableHelper.rowkey(BACKUP_INFO_PREFIX, backupId));
        del.addFamily(BackupSystemTable.SESSIONS_FAMILY);
        return del;
    }

    static BackupInfo resultToBackupInfo(Result res) throws IOException {
        res.advance();
        Cell cell = res.current();
        return BackupSystemTableHelper.cellToBackupInfo(cell);
    }

    static Get createGetForStartCode(String rootPath) throws IOException {
        Get get = new Get(BackupSystemTableHelper.rowkey(START_CODE_ROW, rootPath));
        get.addFamily(BackupSystemTable.META_FAMILY);
        get.setMaxVersions(1);
        return get;
    }

    static Put createPutForStartCode(String startCode, String rootPath) {
        Put put = new Put(BackupSystemTableHelper.rowkey(START_CODE_ROW, rootPath));
        put.addColumn(BackupSystemTable.META_FAMILY, "startcode".getBytes(), startCode.getBytes());
        return put;
    }

    static Get createGetForIncrBackupTableSet(String backupRoot) throws IOException {
        Get get = new Get(BackupSystemTableHelper.rowkey(INCR_BACKUP_SET, backupRoot));
        get.addFamily(BackupSystemTable.META_FAMILY);
        get.setMaxVersions(1);
        return get;
    }

    static Put createPutForIncrBackupTableSet(Set<TableName> tables, String backupRoot) {
        Put put = new Put(BackupSystemTableHelper.rowkey(INCR_BACKUP_SET, backupRoot));
        for (TableName table : tables) {
            put.addColumn(BackupSystemTable.META_FAMILY, Bytes.toBytes((String)table.getNameAsString()), EMPTY_VALUE);
        }
        return put;
    }

    static Scan createScanForBackupHistory() {
        Scan scan = new Scan();
        byte[] startRow = BACKUP_INFO_PREFIX.getBytes();
        byte[] stopRow = Arrays.copyOf(startRow, startRow.length);
        stopRow[stopRow.length - 1] = (byte)(stopRow[stopRow.length - 1] + 1);
        scan.setStartRow(startRow);
        scan.setStopRow(stopRow);
        scan.addFamily(BackupSystemTable.SESSIONS_FAMILY);
        scan.setMaxVersions(1);
        return scan;
    }

    static BackupInfo cellToBackupInfo(Cell current) throws IOException {
        byte[] data = CellUtil.cloneValue((Cell)current);
        return BackupInfo.fromByteArray(data);
    }

    static Put createPutForWriteRegionServerLogTimestamp(TableName table, byte[] smap, String backupRoot) {
        Put put = new Put(BackupSystemTableHelper.rowkey(TABLE_RS_LOG_MAP_PREFIX, backupRoot, NULL, table.getNameAsString()));
        put.addColumn(BackupSystemTable.META_FAMILY, "log-roll-map".getBytes(), smap);
        return put;
    }

    static Scan createScanForReadLogTimestampMap(String backupRoot) {
        Scan scan = new Scan();
        byte[] startRow = BackupSystemTableHelper.rowkey(TABLE_RS_LOG_MAP_PREFIX, backupRoot);
        byte[] stopRow = Arrays.copyOf(startRow, startRow.length);
        stopRow[stopRow.length - 1] = (byte)(stopRow[stopRow.length - 1] + 1);
        scan.setStartRow(startRow);
        scan.setStopRow(stopRow);
        scan.addFamily(BackupSystemTable.META_FAMILY);
        return scan;
    }

    static String getTableNameForReadLogTimestampMap(byte[] cloneRow) {
        String s = new String(cloneRow);
        int index = s.lastIndexOf(NULL);
        return s.substring(index + 1);
    }

    static Put createPutForRegionServerLastLogRollResult(String server, Long timestamp, String backupRoot) {
        Put put = new Put(BackupSystemTableHelper.rowkey(RS_LOG_TS_PREFIX, backupRoot, NULL, server));
        put.addColumn(BackupSystemTable.META_FAMILY, "rs-log-ts".getBytes(), timestamp.toString().getBytes());
        return put;
    }

    static Scan createScanForReadRegionServerLastLogRollResult(String backupRoot) {
        Scan scan = new Scan();
        byte[] startRow = BackupSystemTableHelper.rowkey(RS_LOG_TS_PREFIX, backupRoot);
        byte[] stopRow = Arrays.copyOf(startRow, startRow.length);
        stopRow[stopRow.length - 1] = (byte)(stopRow[stopRow.length - 1] + 1);
        scan.setStartRow(startRow);
        scan.setStopRow(stopRow);
        scan.addFamily(BackupSystemTable.META_FAMILY);
        scan.setMaxVersions(1);
        return scan;
    }

    static String getServerNameForReadRegionServerLastLogRollResult(byte[] row) {
        String s = new String(row);
        int index = s.lastIndexOf(NULL);
        return s.substring(index + 1);
    }

    public static List<Put> createPutsForAddWALFiles(List<String> files, String backupId, String backupRoot) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (String file : files) {
            Put put = new Put(BackupSystemTableHelper.rowkey(WALS_PREFIX, BackupClientUtil.getUniqueWALFileNamePart(file)));
            put.addColumn(BackupSystemTable.META_FAMILY, "backupId".getBytes(), backupId.getBytes());
            put.addColumn(BackupSystemTable.META_FAMILY, "file".getBytes(), file.getBytes());
            put.addColumn(BackupSystemTable.META_FAMILY, "root".getBytes(), backupRoot.getBytes());
            puts.add(put);
        }
        return puts;
    }

    public static Scan createScanForGetWALs(String backupRoot) {
        Scan scan = new Scan();
        byte[] startRow = WALS_PREFIX.getBytes();
        byte[] stopRow = Arrays.copyOf(startRow, startRow.length);
        stopRow[stopRow.length - 1] = (byte)(stopRow[stopRow.length - 1] + 1);
        scan.setStartRow(startRow);
        scan.setStopRow(stopRow);
        scan.addFamily(BackupSystemTable.META_FAMILY);
        return scan;
    }

    public static Get createGetForCheckWALFile(String file) throws IOException {
        Get get = new Get(BackupSystemTableHelper.rowkey(WALS_PREFIX, BackupClientUtil.getUniqueWALFileNamePart(file)));
        get.addFamily(BackupSystemTable.META_FAMILY);
        return get;
    }

    static Scan createScanForBackupSetList() {
        Scan scan = new Scan();
        byte[] startRow = SET_KEY_PREFIX.getBytes();
        byte[] stopRow = Arrays.copyOf(startRow, startRow.length);
        stopRow[stopRow.length - 1] = (byte)(stopRow[stopRow.length - 1] + 1);
        scan.setStartRow(startRow);
        scan.setStopRow(stopRow);
        scan.addFamily(BackupSystemTable.META_FAMILY);
        return scan;
    }

    static Get createGetForBackupSet(String name) {
        Get get = new Get(BackupSystemTableHelper.rowkey(SET_KEY_PREFIX, name));
        get.addFamily(BackupSystemTable.META_FAMILY);
        return get;
    }

    static Delete createDeleteForBackupSet(String name) {
        Delete del = new Delete(BackupSystemTableHelper.rowkey(SET_KEY_PREFIX, name));
        del.addFamily(BackupSystemTable.META_FAMILY);
        return del;
    }

    static Put createPutForBackupSet(String name, String[] tables) {
        Put put = new Put(BackupSystemTableHelper.rowkey(SET_KEY_PREFIX, name));
        byte[] value = BackupSystemTableHelper.convertToByteArray(tables);
        put.addColumn(BackupSystemTable.META_FAMILY, "tables".getBytes(), value);
        return put;
    }

    private static byte[] convertToByteArray(String[] tables) {
        return StringUtils.join((Object[])tables, (String)",").getBytes();
    }

    static String[] cellValueToBackupSet(Cell current) throws IOException {
        byte[] data = CellUtil.cloneValue((Cell)current);
        if (data != null && data.length > 0) {
            return new String(data).split(",");
        }
        return new String[0];
    }

    static String cellKeyToBackupSetName(Cell current) throws IOException {
        byte[] data = CellUtil.cloneRow((Cell)current);
        return new String(data).substring(SET_KEY_PREFIX.length());
    }

    static byte[] rowkey(String s, String ... other) {
        StringBuilder sb = new StringBuilder(s);
        for (String ss : other) {
            sb.append(ss);
        }
        return sb.toString().getBytes();
    }
}

