/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.engine.api.reporting.LogLevel;
import org.pentaho.di.pan.CommandLineOption;

public class CLI {
    private final StringBuilder ktrFile = new StringBuilder();
    private final StringBuilder engine = new StringBuilder();
    private final StringBuilder logLevel = new StringBuilder();
    private final StringBuilder keepAlive = new StringBuilder();
    private final StringBuilder runInDriver = new StringBuilder();
    private final CommandLineOption[] options = new CommandLineOption[]{new CommandLineOption("ktrFile", "ktr file to execute", this.ktrFile), new CommandLineOption("engineId", "plugin id of engine to execute (default: spark)", this.engine), new CommandLineOption("logLevel", "log level for driver kettle environment", this.logLevel), new CommandLineOption("runInDriver", "running in driver or initializing spark context locally", this.runInDriver, true, false), new CommandLineOption("keepAlive", "Keep process running after transformation has run (default: N)", this.keepAlive, true, true)};

    public void printUsage() {
        CommandLineOption.printUsage((CommandLineOption[])this.options);
    }

    public boolean parse(List<String> args) {
        this.reset();
        return CommandLineOption.parseArguments(args, (CommandLineOption[])this.options, (LogChannelInterface)new LogChannel((Object)this));
    }

    private void reset() {
        Stream.of(this.ktrFile, this.engine, this.logLevel, this.runInDriver, this.keepAlive).forEach(builder -> builder.setLength(0));
    }

    public Optional<String> getKtrPath() {
        return Optional.of(this.ktrFile.toString()).map(Strings::emptyToNull);
    }

    public Optional<File> getKtrFile() {
        return this.getKtrPath().map(File::new).filter(File::isFile);
    }

    public String getEngine() {
        return Optional.of(this.engine.toString()).map(Strings::emptyToNull).orElse("spark");
    }

    public LogLevel getLogLevel() {
        return (LogLevel)Enums.getIfPresent(LogLevel.class, (String)Strings.nullToEmpty((String)this.logLevel.toString())).or((Object)LogLevel.BASIC);
    }

    public boolean keepAlive() {
        return this.getBoolean(this.keepAlive.toString());
    }

    public boolean runInDriver() {
        return this.getBoolean(this.runInDriver.toString());
    }

    private boolean getBoolean(String value) {
        return Optional.of(value).filter(Predicate.isEqual("Y")).isPresent();
    }
}

