/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.pentaho.caching.api.PentahoCacheManager;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.dataservice.Context;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.optimization.AutoOptimizationService;
import org.pentaho.di.trans.dataservice.optimization.PushDownFactory;
import org.pentaho.di.trans.dataservice.serialization.DataServiceMetaStoreUtil;
import org.pentaho.di.trans.dataservice.ui.DataServiceDelegate;
import org.pentaho.di.trans.dataservice.ui.UIFactory;

public class DataServiceContext
implements Context {
    private final DataServiceMetaStoreUtil metaStoreUtil;
    private final List<AutoOptimizationService> autoOptimizationServices;
    private final PentahoCacheManager cacheManager;
    private final List<PushDownFactory> pushDownFactories;
    private final LogChannelInterface logChannel;
    private final UIFactory uiFactory;
    private final ConcurrentMap<String, DataServiceExecutor> executors = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).softValues().build().asMap();

    public DataServiceContext(List<PushDownFactory> pushDownFactories, List<AutoOptimizationService> autoOptimizationServices, PentahoCacheManager cacheManager, UIFactory uiFactory, LogChannelInterface logChannel) {
        this.pushDownFactories = pushDownFactories;
        this.autoOptimizationServices = autoOptimizationServices;
        this.cacheManager = cacheManager;
        this.metaStoreUtil = DataServiceMetaStoreUtil.create(this);
        this.logChannel = logChannel;
        this.uiFactory = uiFactory;
    }

    @VisibleForTesting
    protected DataServiceContext(List<PushDownFactory> pushDownFactories, List<AutoOptimizationService> autoOptimizationServices, PentahoCacheManager cacheManager, DataServiceMetaStoreUtil metaStoreUtil, UIFactory uiFactory, LogChannelInterface logChannel) {
        this.pushDownFactories = pushDownFactories;
        this.autoOptimizationServices = autoOptimizationServices;
        this.cacheManager = cacheManager;
        this.metaStoreUtil = metaStoreUtil;
        this.logChannel = logChannel;
        this.uiFactory = uiFactory;
    }

    @Override
    public PentahoCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public DataServiceMetaStoreUtil getMetaStoreUtil() {
        return this.metaStoreUtil;
    }

    @Override
    public List<AutoOptimizationService> getAutoOptimizationServices() {
        return this.autoOptimizationServices;
    }

    @Override
    public List<PushDownFactory> getPushDownFactories() {
        return this.pushDownFactories;
    }

    @Override
    public LogChannelInterface getLogChannel() {
        return this.logChannel;
    }

    @Override
    public UIFactory getUIFactory() {
        return this.uiFactory;
    }

    @Override
    public DataServiceDelegate getDataServiceDelegate() {
        return DataServiceDelegate.withDefaultSpoonInstance(this);
    }

    @Override
    public void addExecutor(DataServiceExecutor executor) {
        this.executors.putIfAbsent(executor.getId(), executor);
    }

    @Override
    public DataServiceExecutor getExecutor(String id) {
        return (DataServiceExecutor)this.executors.get(id);
    }

    @Override
    public void removeExecutor(String id) {
        this.executors.remove(id);
    }
}

