/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.api;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.util.AccumulatorV2;
import org.pentaho.di.engine.api.model.ModelElement;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.spark.impl.execution.OperationLogger;

public interface SparkOperation
extends ModelElement {
    public String getId();

    public void apply(Subscriber var1);

    default public Optional<Operation> getLogicalOperation() {
        return Optional.empty();
    }

    public static interface Subscriber {
        public Set<SparkOperation> getExpectedOutputs();

        public Map<SparkOperation, JavaRDD<Row>> getInputs();

        default public Optional<JavaRDD<Row>> getInput() {
            return this.getInputs().values().stream().reduce(JavaRDD::union);
        }

        public void addOutput(SparkOperation var1, CompletableFuture<JavaRDD<Row>> var2);

        default public void addOutput(SparkOperation output, JavaRDD<Row> value) {
            this.addOutput(output, CompletableFuture.completedFuture(value));
        }

        default public void setOutput(JavaRDD<Row> output) {
            this.setOutput(CompletableFuture.completedFuture(output));
        }

        public void setOutput(CompletableFuture<JavaRDD<Row>> var1);

        public void registerDriverAction(Runnable var1);

        public void updateMetrics(UnaryOperator<Metrics> var1);

        public Map<String, AccumulatorV2> getAccumulators();

        public OperationLogger getLogger();

        public void updateStatus(Status var1, String var2);

        public void finalize(Throwable var1);
    }
}

