/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.ReplaySubject;
import io.reactivex.subjects.Subject;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.CollectionAccumulator;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.ExecutionResult;
import org.pentaho.di.engine.api.converter.RowConversionManager;
import org.pentaho.di.engine.api.events.LogEvent;
import org.pentaho.di.engine.api.events.MetricsEvent;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.events.StatusEvent;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.spark.LoggingToAccumAdapter;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperationResolver;
import org.pentaho.di.engine.spark.impl.SparkEngine;
import org.pentaho.di.engine.spark.impl.accumulators.LoggingAccumSparkListener;
import org.pentaho.di.engine.spark.impl.execution.DriverTask;
import org.pentaho.di.engine.spark.impl.execution.ExecutionPlan;
import org.pentaho.di.engine.spark.impl.execution.TaskObservable;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.reactivestreams.Publisher;

public class Context
implements ExecutionContext {
    private static LogChannelInterface logChannel = KettleLogStore.getLogChannelInterfaceFactory().create(Context.class);
    public static final String TRANS_LOGGING_ACCUM = "trans_logging";
    public static final String OP_LOGGING_ACCUM = "op_logging";
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final Map<String, Object> environment = new HashMap<String, Object>();
    private final SparkEngine engine;
    private final Transformation transformation;
    private final JavaSparkContext sparkContext;
    private final SparkOperationResolver resolver;
    private final CollectionAccumulator<LogEntry> transLoggingAccumulator = new CollectionAccumulator();
    private Principal actingPrincipal;
    private org.pentaho.di.engine.api.reporting.LogLevel loggingLogLevel;
    private Single<ExecutionPlan> executionPlanSingle;
    private ReplaySubject<LogEntry> loggingSubject;
    private AtomicBoolean listenerRegistered = new AtomicBoolean(false);

    public Context(SparkEngine engine, Transformation trans, JavaSparkContext sparkContext, SparkOperationResolver resolver) {
        this.engine = Objects.requireNonNull(engine);
        this.transformation = Objects.requireNonNull(trans);
        this.sparkContext = Objects.requireNonNull(sparkContext);
        this.resolver = Objects.requireNonNull(resolver);
        this.sparkContext.sc().register(this.transLoggingAccumulator);
        LoggingToAccumAdapter.getInstance().setAccumulator(this.transLoggingAccumulator);
        this.executionPlanSingle = Single.fromCallable(this::createExecutionPlan).cache();
    }

    public Map<String, Object> getParameters() {
        return ImmutableMap.copyOf(this.parameters);
    }

    public Map<String, Object> getEnvironment() {
        return ImmutableMap.copyOf(this.environment);
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public void setEnvironment(Map<String, Object> environment) {
        this.environment.clear();
        this.environment.putAll(environment);
    }

    public void setParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    public void setEnvironment(String key, Object value) {
        this.environment.put(key, value);
    }

    public void setLoggingLogLevel(org.pentaho.di.engine.api.reporting.LogLevel logLevel) {
        DefaultLogLevel.setLogLevel((LogLevel)Util.mapKettleLogLevel(logLevel));
        logChannel.setLogLevel(DefaultLogLevel.getLogLevel());
        this.loggingLogLevel = logLevel;
    }

    public org.pentaho.di.engine.api.reporting.LogLevel getLoggingLogLevel() {
        return this.loggingLogLevel;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public CompletableFuture<ExecutionResult> execute() {
        logChannel.logDebug("Running the transformation");
        ExecutionPlan executionPlan = this.getExecutionPlan();
        ImmutableMap.Builder reportBuilder = ImmutableMap.builder();
        for (TaskObservable taskObservable : executionPlan.getMaterializedOperations().values()) {
            taskObservable.getSparkOperation().getLogicalOperation().ifPresent(operation -> {
                CompletableFuture future = (CompletableFuture)taskObservable.getMetrics().lastOrError().to(Util::completableFuture);
                reportBuilder.put(operation, (Object)future);
            });
        }
        final CompletableFuture report = Util.invertMap(reportBuilder.build());
        ConnectableObservable<DriverTask> driverTasks = executionPlan.getDriverTasks();
        driverTasks.subscribe((Observer)new DisposableObserver<DriverTask>(){

            public void onNext(DriverTask driverTask) {
                Context.this.engine.getExecutorService().execute(driverTask);
                if (logChannel.isDebug()) {
                    logChannel.logDebug("Running the next driver task for the " + driverTask.getSparkOperation().getId() + " step");
                }
            }

            public void onError(Throwable e) {
                report.completeExceptionally(e);
            }

            public void onComplete() {
                if (logChannel.isDebug()) {
                    logChannel.logDebug("The transformation has finished!");
                }
            }
        });
        driverTasks.connect();
        return report.thenApply(SparkEngine.Result::new);
    }

    public SparkOperation compile(Operation operation, StepMeta stepMeta) {
        Objects.requireNonNull(operation);
        Objects.requireNonNull(stepMeta);
        try {
            return this.resolver.resolve(operation, this.transformation, stepMeta, this.sparkContext, this);
        }
        catch (KettlePluginException e) {
            throw new IllegalStateException(e);
        }
    }

    public RowConversionManager getConversionManager() {
        return null;
    }

    public Principal getActingPrincipal() {
        return this.actingPrincipal;
    }

    public void setActingPrincipal(Principal actingPrincipal) {
        this.actingPrincipal = actingPrincipal;
    }

    public <S extends LogicalModelElement, D extends Serializable> Publisher<PDIEvent<S, D>> eventStream(S source, Class<D> type) {
        ExecutionPlan executionPlan = this.getExecutionPlan();
        if (source instanceof Transformation) {
            if (Status.class == type) {
                return executionPlan.getStatus().map(status -> new StatusEvent((LogicalModelElement)this.transformation, status)).toFlowable(BackpressureStrategy.BUFFER);
            }
            if (type == LogEntry.class) {
                if (this.loggingSubject == null) {
                    this.loggingSubject = ReplaySubject.createWithTimeAndSize((long)30L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)Schedulers.trampoline(), (int)1000);
                }
                if (!this.listenerRegistered.getAndSet(true)) {
                    this.sparkContext.sc().addSparkListener((SparkListenerInterface)new LoggingAccumSparkListener(this.transLoggingAccumulator, (Subject<LogEntry>)this.loggingSubject));
                }
                return this.loggingSubject.map(logEntry -> new LogEvent((LogicalModelElement)((Transformation)source), logEntry)).toFlowable(BackpressureStrategy.BUFFER);
            }
        }
        if (source instanceof Operation) {
            TaskObservable taskObservable = (TaskObservable)executionPlan.getMaterializedOperations().get((Object)source.getId());
            Optional operation = Optional.ofNullable(taskObservable).map(TaskObservable::getSparkOperation).flatMap(SparkOperation::getLogicalOperation);
            if (!operation.isPresent()) {
                String message = String.format("Operation %s not found on transformation", source.getId());
                return Flowable.error((Throwable)new IllegalArgumentException(message));
            }
            if (type == Status.class) {
                return taskObservable.getStatus().map(status -> new StatusEvent((LogicalModelElement)operation.get(), status)).toFlowable(BackpressureStrategy.BUFFER);
            }
            if (type == Metrics.class) {
                return taskObservable.getMetrics().map(metrics -> new MetricsEvent((LogicalModelElement)operation.get(), metrics)).toFlowable(BackpressureStrategy.LATEST);
            }
            if (type == LogEntry.class) {
                return taskObservable.getLogging().map(logEntry -> new LogEvent((LogicalModelElement)operation.get(), logEntry)).toFlowable(BackpressureStrategy.BUFFER);
            }
        }
        return Flowable.empty();
    }

    public Collection<LogicalModelElement> getReportingSources() {
        return ImmutableList.builder().add((Object)this.transformation).addAll((Iterable)this.transformation.getOperations()).build();
    }

    public ExecutionPlan getExecutionPlan() {
        return (ExecutionPlan)this.executionPlanSingle.blockingGet();
    }

    public ExecutionPlan createExecutionPlan() {
        logChannel.logDebug("Compiling the transformation");
        TransMeta transMeta = Util.getTransMeta(this.transformation);
        Maps.transformValues(this.environment, String::valueOf).forEach((arg_0, arg_1) -> ((TransMeta)transMeta).setVariable(arg_0, arg_1));
        ImmutableMap<String, StepMeta> stepMetas = transMeta.getSteps().stream().collect(Util.toImmutableMap(StepMeta::getName, stepMeta -> stepMeta));
        return new ExecutionPlan.Builder(this.sparkContext).add(this.transformation.getOperations(), operation -> this.compile((Operation)operation, (StepMeta)stepMetas.get((Object)operation.getId()))).addAccumulator(TRANS_LOGGING_ACCUM, (AccumulatorV2<?, ?>)new CollectionAccumulator()).build(this.sparkContext);
    }
}

