/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.spark.api.java.function.Function;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.functions.TransSerializingBase;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputData;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;

public class FileOutputContentFunction
extends TransSerializingBase
implements Function<Row, String> {
    private transient TextFileOutputData textFileOutputData;
    private transient TextFileOutput step;

    public FileOutputContentFunction() {
    }

    public FileOutputContentFunction(String id, TransMeta transMeta, Operation logicalOp) {
        super(transMeta, id);
        this.init(transMeta, id);
    }

    @Override
    protected void init(TransMeta transMeta, String stepName) {
        super.init(transMeta, this.id);
        this.step = Util.getTypedStep(transMeta, stepName, TextFileOutput.class);
        TextFileOutputMeta textFileOutputMeta = (TextFileOutputMeta)this.step.getStepMeta().getStepMetaInterface();
        textFileOutputMeta.setDoNotOpenNewFileInit(true);
        this.textFileOutputData = (TextFileOutputData)textFileOutputMeta.getStepData();
        this.textFileOutputData.outputRowMeta = Util.getRowMeta(transMeta, stepName).clone();
        this.textFileOutputData.fieldnrs = Ints.toArray((Collection)Arrays.stream(textFileOutputMeta.getOutputFields()).map(TextFileField::getName).map(arg_0 -> ((RowMetaInterface)this.textFileOutputData.outputRowMeta).indexOfValue(arg_0)).collect(Collectors.toList()));
        this.step.init((StepMetaInterface)textFileOutputMeta, (StepDataInterface)this.textFileOutputData);
    }

    public String call(Row row) throws Exception {
        String outputRow;
        this.logRow();
        try (ByteArrayOutputStream writer = new ByteArrayOutputStream();){
            this.textFileOutputData.writer = writer;
            this.step.writeRowToFile(this.textFileOutputData.outputRowMeta, row.getObjects());
            outputRow = ((Object)writer).toString();
        }
        return outputRow;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        super.writeObjectDefault(oos);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        super.readObjectDefault(ois);
    }
}

