/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.functions.TransSerializingBase;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputData;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;

public class FileOutputContentFunctionPartitioned
extends TransSerializingBase
implements FlatMapFunction<Iterator<Row>, String> {
    private transient boolean isInitialized = false;
    private transient TextFileOutputData textFileOutputData;
    private transient TextFileOutput step;

    public FileOutputContentFunctionPartitioned(String id, TransMeta transMeta, Operation logicalOp) {
        super(transMeta, id);
        this.init(transMeta, id);
    }

    @Override
    protected void init(TransMeta transMeta, String stepName) {
        if (!this.isInitialized) {
            super.init(transMeta, this.id);
            this.step = Util.getTypedStep(transMeta, stepName, TextFileOutput.class);
            TextFileOutputMeta textFileOutputMeta = (TextFileOutputMeta)this.step.getStepMeta().getStepMetaInterface();
            textFileOutputMeta.setDoNotOpenNewFileInit(true);
            this.textFileOutputData = (TextFileOutputData)textFileOutputMeta.getStepData();
            this.textFileOutputData.outputRowMeta = Util.getRowMeta(transMeta, stepName).clone();
            this.textFileOutputData.fieldnrs = Ints.toArray((Collection)Arrays.stream(textFileOutputMeta.getOutputFields()).map(TextFileField::getName).map(arg_0 -> ((RowMetaInterface)this.textFileOutputData.outputRowMeta).indexOfValue(arg_0)).collect(Collectors.toList()));
            this.step.init((StepMetaInterface)textFileOutputMeta, (StepDataInterface)this.textFileOutputData);
            this.isInitialized = true;
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        super.writeObjectDefault(oos);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        super.readObjectDefault(ois);
    }

    public Iterator<String> call(Iterator<Row> rowIterator) throws Exception {
        ArrayList outputRows = new ArrayList();
        rowIterator.forEachRemaining(row -> {
            this.logRow();
            try (ByteArrayOutputStream writer = new ByteArrayOutputStream();){
                this.textFileOutputData.writer = writer;
                this.step.writeRowToFile(this.textFileOutputData.outputRowMeta, row.getObjects());
                outputRows.add(((Object)writer).toString());
            }
            catch (Exception ex) {
                logChannel.logError("Error processing " + ex.getMessage());
            }
        });
        return outputRows.iterator();
    }
}

