/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.spark.util.CollectionAccumulator;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.LogLevel;

public class FunctionLogger
implements Serializable {
    public static final FunctionLogger EMPTY = new FunctionLogger(null);
    @Nullable
    private final CollectionAccumulator<LogEntry> accumulator;

    public FunctionLogger(CollectionAccumulator<LogEntry> accumulator) {
        this.accumulator = accumulator;
    }

    public static FunctionLogger empty() {
        return EMPTY;
    }

    public void basic(String message) {
        this.create(LogLevel.BASIC, message, Optional.empty());
    }

    public void basic(String message, Throwable throwable) {
        this.create(LogLevel.BASIC, message, Optional.of(throwable));
    }

    public void error(String message) {
        this.create(LogLevel.ERROR, message, Optional.empty());
    }

    public void error(String message, Throwable throwable) {
        this.create(LogLevel.ERROR, message, Optional.of(throwable));
    }

    public void minimal(String message) {
        this.create(LogLevel.MINIMAL, message, Optional.empty());
    }

    public void minimal(String message, Throwable throwable) {
        this.create(LogLevel.MINIMAL, message, Optional.of(throwable));
    }

    public void detailed(String message) {
        this.create(LogLevel.DETAILED, message, Optional.empty());
    }

    public void detailed(String message, Throwable throwable) {
        this.create(LogLevel.DETAILED, message, Optional.of(throwable));
    }

    public void debug(String message) {
        this.create(LogLevel.DEBUG, message, Optional.empty());
    }

    public void debug(String message, Throwable throwable) {
        this.create(LogLevel.DEBUG, message, Optional.of(throwable));
    }

    private void create(LogLevel level, String message, Optional<Throwable> throwableOptional) {
        if (this.accumulator == null) {
            return;
        }
        LogEntry.LogEntryBuilder logEntryBuilder = new LogEntry.LogEntryBuilder().withMessage(message).withLogLevel(level).withTimestamp(new Date());
        if (throwableOptional.isPresent()) {
            logEntryBuilder = logEntryBuilder.withThrowable(throwableOptional.get());
        }
        this.accumulator.add((Object)logEntryBuilder.build());
    }

    public CollectionAccumulator<LogEntry> getAccumulator() {
        return this.accumulator;
    }
}

