/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Row;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.engine.spark.impl.functions.TransSerializingBase;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.trans.TransMeta;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SparkToKettleRowFunction
extends TransSerializingBase
implements Function<Row, org.pentaho.di.engine.api.model.Row> {
    private static final long serialVersionUID = -8387294136003736814L;
    private transient RowMetaInterface rowMeta;
    private int[] functionFields;
    private List<BiFunction<ValueMetaInterface, Object, Object>> fieldFunctions = new ArrayList<BiFunction<ValueMetaInterface, Object, Object>>();
    private Map<Integer, BiFunction<ValueMetaInterface, Object, Object>> functionMap;

    public SparkToKettleRowFunction(String id, TransMeta transMeta) {
        super(transMeta, id);
        this.functionMap = new HashMap<Integer, BiFunction<ValueMetaInterface, Object, Object>>();
        this.functionMap.put(3, new SqlToDateFunction());
    }

    public SparkToKettleRowFunction(String id, TransMeta transMeta, Map<Integer, BiFunction<ValueMetaInterface, Object, Object>> functionMap) {
        super(transMeta, id);
        this.functionMap = functionMap;
    }

    @Override
    protected void init(TransMeta transMeta, String id) {
        super.init(transMeta, id);
        try {
            this.rowMeta = transMeta.getStepFields(transMeta.findStep(id));
            List valueMetaList = this.rowMeta.getValueMetaList();
            this.functionFields = IntStream.range(0, valueMetaList.size()).filter(i -> this.functionMap.containsKey(((ValueMetaInterface)valueMetaList.get(i)).getType())).peek(i -> this.fieldFunctions.add(this.functionMap.get(((ValueMetaInterface)valueMetaList.get(i)).getType()))).toArray();
        }
        catch (KettleStepException e) {
            throw new RuntimeException(e);
        }
    }

    public org.pentaho.di.engine.api.model.Row call(Row row) throws Exception {
        Object[] values = ((List)JavaConverters.seqAsJavaListConverter((Seq)row.toSeq()).asJava()).toArray();
        for (int i = 0; i < this.functionFields.length; ++i) {
            int fieldIndex = this.functionFields[i];
            ValueMetaInterface valueMeta = (ValueMetaInterface)this.rowMeta.getValueMetaList().get(fieldIndex);
            values[fieldIndex] = this.fieldFunctions.get(i).apply(valueMeta, values[fieldIndex]);
        }
        return new KettleRow(this.rowMeta, values);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        super.writeObjectDefault(oos);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        super.readObjectDefault(ois);
    }

    public static class StrToDateFunction
    implements BiFunction<ValueMetaInterface, Object, Object>,
    Serializable {
        private static final long serialVersionUID = -5523799678526931926L;

        @Override
        public Object apply(ValueMetaInterface valueMeta, Object value) {
            try {
                return valueMeta.getDateFormat().parse((String)value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class SqlToDateFunction
    implements BiFunction<ValueMetaInterface, Object, Object>,
    Serializable {
        private static final long serialVersionUID = -2514096380660655975L;

        @Override
        public Object apply(ValueMetaInterface valueMeta, Object value) {
            return new java.util.Date(((Date)value).getTime());
        }
    }
}

