/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.spi;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.engine.spark.SystemManager;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;

public final class RegisteredFunction<T, R>
implements FlatMapFunction<T, R> {
    private static final long serialVersionUID = -8317956561111332369L;
    protected static SystemManager systemManager = SystemManager.getInstance();
    private final String pluginId;
    private final String className;
    private final ImmutableMap<String, Serializable> config;
    private transient ConfigurableFunction<T, R> function;

    public RegisteredFunction(String pluginId, String className, Map<String, ? extends Serializable> config) {
        this.pluginId = pluginId;
        this.className = className;
        this.config = ImmutableMap.copyOf(config);
    }

    public RegisteredFunction(String pluginId, ConfigurableFunction<T, R> function) {
        this(pluginId, function.getClass().getName(), function.getConfig());
        this.function = function;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getClassName() {
        return this.className;
    }

    public ImmutableMap<String, Serializable> getConfig() {
        return this.config;
    }

    public Iterator<R> call(T input) throws Exception {
        if (this.function == null) {
            PluginRegistry pluginRegistry = systemManager.getPluginRegistry();
            PluginInterface plugin = pluginRegistry.getPlugin(StepPluginType.class, this.pluginId);
            if (plugin == null) {
                throw new KettlePluginException(this.pluginId + " not found");
            }
            this.function = ((SparkOperationFactory)pluginRegistry.loadClass(plugin, SparkOperationFactory.class)).getFunction(this.className);
            this.function.getLogChannel().logDetailed("Loaded function from " + this.pluginId);
            this.function.getLogChannel().logDetailed("Configuring with " + this.config.keySet());
            this.function.setConfig((Map)this.config);
        }
        return this.function.call(input);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredFunction that = (RegisteredFunction)o;
        return Objects.equals(this.pluginId, that.pluginId) && Objects.equals(this.className, that.className) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.pluginId, this.className, this.config);
    }
}

