/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.spi;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.api.java.JavaSparkContext;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperationResolver;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.trans.step.StepMeta;

public class SparkOperationFactory {
    private final SparkOperationResolver constructor;
    private final ImmutableMap<String, Supplier<ConfigurableFunction>> functionSuppliers;

    @SafeVarargs
    public SparkOperationFactory(SparkOperationResolver sparkOperationConstructor, Supplier<ConfigurableFunction> ... functionConstructors) {
        this(sparkOperationConstructor, Arrays.stream(functionConstructors));
    }

    public SparkOperationFactory(SparkOperationResolver sparkOperationConstructor, Stream<Supplier<ConfigurableFunction>> functionConstructors) {
        this.constructor = sparkOperationConstructor;
        this.functionSuppliers = ImmutableMap.copyOf(functionConstructors.collect(Collectors.toMap(supplier -> ((ConfigurableFunction)supplier.get()).getClass().getName(), Function.identity())));
    }

    public SparkOperation getOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) throws KettlePluginException {
        return this.constructor.resolve(operation, transformation, stepMeta, sparkContext, executionContext);
    }

    public <T, R> ConfigurableFunction<T, R> getFunction(String className) {
        return Optional.ofNullable(this.functionSuppliers.get((Object)className)).map(Supplier::get).orElseThrow(() -> new IllegalArgumentException(className + " is not a registered function"));
    }
}

