/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.engine.spark.SystemManager;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SerializableStepMeta
implements Serializable {
    private static final long serialVersionUID = -922354736776016008L;
    private final LogLevel logLevel;
    private transient StepMeta stepMeta;

    public SerializableStepMeta(StepMeta stepMeta) {
        this.stepMeta = Objects.requireNonNull(stepMeta);
        this.logLevel = DefaultLogLevel.getLogLevel();
    }

    public StepMeta getStepMeta() {
        return this.stepMeta;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        try {
            TransMeta transMeta = this.stepMeta.getParentTransMeta();
            if (transMeta == null) {
                oos.writeObject(this.stepMeta.getXML());
            } else {
                oos.writeObject(transMeta.getXML());
                oos.writeObject(this.stepMeta.getName());
                oos.writeObject(StepEnvironment.create((VariableSpace)transMeta));
            }
        }
        catch (KettleException e) {
            throw new IOException(e);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        SystemManager.getInstance().initializeOnce();
        try {
            Document doc = XMLHandler.loadXMLString((String)((String)ois.readObject()));
            Node node = XMLHandler.getSubNode((Node)doc, (String)"transformation");
            if (node != null) {
                String stepName = (String)ois.readObject();
                StepEnvironment stepEnvironment = (StepEnvironment)ois.readObject();
                TransMeta transMeta = new TransMeta(node, null);
                transMeta.setLogLevel(this.logLevel);
                stepEnvironment.forEach((arg_0, arg_1) -> ((TransMeta)transMeta).setVariable(arg_0, arg_1));
                this.stepMeta = Objects.requireNonNull(transMeta.findStep(stepName));
                return;
            }
            node = XMLHandler.getSubNode((Node)doc, (String)"step");
            if (node != null) {
                this.stepMeta = new StepMeta(node, Collections.emptyList(), (IMetaStore)null);
                return;
            }
            throw new IOException("Unable to read stepMeta");
        }
        catch (KettleException e) {
            throw new IOException(e);
        }
    }

    private static class StepEnvironment
    extends HashMap<String, String> {
        private static final long serialVersionUID = 2751163280635171330L;

        private StepEnvironment() {
        }

        static StepEnvironment create(VariableSpace variables) {
            return Arrays.stream(variables.listVariables()).collect(Collectors.toMap(name -> name, arg_0 -> ((VariableSpace)variables).getVariable(arg_0), (l, r) -> r, StepEnvironment::new));
        }
    }
}

