/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Single;
import io.reactivex.disposables.Disposable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.plugins.Plugin;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.impl.functions.KettleToSparkRowFunction;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowHandler;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Util {
    public static final Map<Integer, DataType> kettleSparkTypeMap = new HashMap<Integer, DataType>();
    public static final Map<Integer, DataType> readSparkTypeMap;
    public static final BiMap<org.pentaho.di.engine.api.reporting.LogLevel, LogLevel> LEVEL_MAP;

    public static TransMeta getTransMeta(Transformation transformation) {
        String transMetaXml = (String)transformation.getConfig().get("TransMeta");
        try {
            Document doc = XMLHandler.loadXMLString((String)transMetaXml);
            Node stepNode = XMLHandler.getSubNode((Node)doc, (String)"transformation");
            return new TransMeta(stepNode, null);
        }
        catch (KettleMissingPluginsException | KettleXMLException e) {
            throw new RuntimeException(e);
        }
    }

    public static StepMeta getStepMeta(String id, TransMeta transMeta) {
        return transMeta.getSteps().stream().filter(stepMeta -> stepMeta.getName().equals(id)).findFirst().orElseThrow(() -> new RuntimeException("Couldn't find corresponding input step " + id));
    }

    public static RowMetaInterface getRowMeta(TransMeta transMeta, String stepName) {
        try {
            return transMeta.getStepFields(stepName);
        }
        catch (KettleStepException e) {
            throw new RuntimeException(e);
        }
    }

    public static RowMetaInterface getPrevStepFields(TransMeta transMeta, String stepName) {
        try {
            return transMeta.getPrevStepFields(stepName);
        }
        catch (KettleStepException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends StepMetaInterface> T getTypedStepMeta(StepMeta stepMeta, Class<T> clazz) {
        return (T)Optional.ofNullable(stepMeta).map(StepMeta::getStepMetaInterface).filter(clazz::isInstance).map(clazz::cast).orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("Couldn't find corresponding input step {0} [{1}]", stepMeta.getName(), stepMeta.getTypeId())));
    }

    public static void overridePlugin(String originalType, String substituteType) {
        PluginInterface original = PluginRegistry.getInstance().findPluginWithId(StepPluginType.class, originalType);
        PluginInterface substitute = PluginRegistry.getInstance().findPluginWithId(StepPluginType.class, substituteType);
        if (original == null || !original.equals(substitute)) {
            if (substitute instanceof Plugin) {
                ((Plugin)substitute).setIds(new String[]{originalType, substituteType});
            } else {
                throw new RuntimeException("couldn't substitute " + originalType + " with " + substituteType);
            }
        }
    }

    public static <K, V> CompletableFuture<ImmutableMap<K, V>> invertMap(Map<K, ? extends CompletableFuture<V>> map) {
        CompletionStage futureMap = map.entrySet().stream().map(entry -> ((CompletableFuture)entry.getValue()).thenApply(value -> Stream.of(Maps.immutableEntry(entry.getKey(), (Object)value)))).reduce(CompletableFuture.completedFuture(Stream.empty()), (left, right) -> left.thenCombine((CompletionStage)right, Stream::concat)).thenApply(entryStream -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            entryStream.forEach(arg_0 -> ((ImmutableMap.Builder)builder).put(arg_0));
            return builder.build();
        });
        Util.ifCancelled(futureMap, () -> map.values().forEach(future -> future.cancel(false)));
        return futureMap;
    }

    public static <T extends BaseStep> T getTypedStep(TransMeta transMeta, String stepName, Class<T> stepType) {
        return Util.getTypedStep(transMeta.findStep(stepName), stepType);
    }

    public static <T extends BaseStep> T getTypedStep(StepMeta stepMeta, Class<T> stepType) {
        TransMeta transMeta = stepMeta.getParentTransMeta();
        StepMetaInterface smi = stepMeta.getStepMetaInterface();
        Trans trans = Util.getTrans(stepMeta);
        StepDataInterface sdi = smi.getStepData();
        BaseStep step = (BaseStep)smi.getStep(stepMeta, sdi, 0, transMeta, trans);
        step.initializeVariablesFrom((VariableSpace)transMeta);
        step.setStepMetaInterface(smi);
        step.setStepDataInterface(sdi);
        return (T)((BaseStep)stepType.cast(step));
    }

    private static Trans getTrans(StepMeta stepMeta) {
        TransMeta transMeta = stepMeta.getParentTransMeta();
        Trans trans = new Trans();
        LogChannel logChannel = new LogChannel((Object)stepMeta);
        logChannel.setLogLevel(transMeta.getLogLevel());
        trans.setLog((LogChannelInterface)logChannel);
        trans.setLogLevel(transMeta.getLogLevel());
        trans.rowsets = new ArrayList();
        trans.rowsets.addAll(Util.createRowsets(transMeta, stepMeta));
        return trans;
    }

    public static List<RowSet> createRowsets(TransMeta transMeta, StepMeta stepMeta) {
        return IntStream.range(0, transMeta.nrTransHops()).mapToObj(arg_0 -> ((TransMeta)transMeta).getTransHop(arg_0)).filter(hop -> stepMeta.equals((Object)hop.getFromStep()) || stepMeta.equals((Object)hop.getToStep())).map(hop -> {
            QueueRowSet rs = new QueueRowSet();
            rs.setThreadNameFromToCopy(hop.getFromStep().getName(), 0, hop.getToStep().getName(), 0);
            return rs;
        }).collect(Collectors.toList());
    }

    public static RowHandler rowGetter(Supplier<Object[]> get) {
        return Util.rowHandler(get, null, null);
    }

    public static RowHandler rowPutter(Consumer<Object[]> put) {
        return Util.rowHandler(null, put, null);
    }

    public static RowHandler rowHandler(final Supplier<Object[]> get, final Consumer<Object[]> put, final RowErrorPutter err) {
        return new RowHandler(){

            public Object[] getRow() throws KettleException {
                return Optional.ofNullable(get).orElse(() -> null).get();
            }

            public void putRow(RowMetaInterface rowMetaInterface, Object[] objects) throws KettleStepException {
                Optional.ofNullable(put).ifPresent(consumer -> consumer.accept(objects));
            }

            public void putError(RowMetaInterface rowMetaInterface, Object[] objects, long l, String s, String s1, String s2) throws KettleStepException {
                Optional.ofNullable(err).ifPresent(consumer -> consumer.putError(rowMetaInterface, objects, l, s, s1, s2));
            }
        };
    }

    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(java.util.function.Function<T, K> keyFunction, java.util.function.Function<T, V> valueFunction) {
        return Collector.of(ImmutableMap::builder, (builder, value) -> builder.put(keyFunction.apply(value), valueFunction.apply(value)), (left, right) -> left.putAll((Map)right.build()), ImmutableMap.Builder::build, new Collector.Characteristics[0]);
    }

    public static CompletableFuture<Void> completableFuture(CompletableSource completable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Disposable disposable = Completable.wrap((CompletableSource)completable).subscribe(() -> future.complete(null), future::completeExceptionally);
        Util.ifCancelled(future, () -> ((Disposable)disposable).dispose());
        return future;
    }

    public static <T> CompletableFuture<T> completableFuture(Single<T> single) {
        CompletableFuture future = new CompletableFuture();
        Disposable disposable = single.subscribe(future::complete, future::completeExceptionally);
        Util.ifCancelled(future, () -> ((Disposable)disposable).dispose());
        return future;
    }

    public static void ifCancelled(CompletableFuture<?> future, Runnable action) {
        future.whenComplete((success, exception) -> {
            if (exception instanceof CancellationException) {
                action.run();
            }
        });
    }

    public static <K1, K2, V> ImmutableMap<K2, V> lookupKeys(Map<K1, V> map, java.util.function.Function<K1, K2> lookup) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((id, future) -> builder.put(lookup.apply(id), future));
        return builder.build();
    }

    public static Dataset<Row> convertToSparkDataset(JavaRDD<org.pentaho.di.engine.api.model.Row> input, RowMetaInterface rowMeta) {
        SparkSession spark = Util.getSparkSession();
        StructType schema = Util.getStructType(rowMeta);
        JavaRDD sparkRDD = input.map((Function)new KettleToSparkRowFunction(rowMeta));
        return spark.createDataFrame(sparkRDD, schema);
    }

    public static StructType getStructType(RowMetaInterface rowMeta) {
        return Util.getStructType(rowMeta, kettleSparkTypeMap);
    }

    public static StructType getReadStructType(RowMetaInterface rowMeta) {
        return Util.getStructType(rowMeta, readSparkTypeMap);
    }

    private static StructType getStructType(RowMetaInterface rowMeta, Map<Integer, DataType> kettleSparkTypeMap) {
        List valueMetaList = rowMeta.getValueMetaList();
        List fields = valueMetaList.stream().map(valueMeta -> DataTypes.createStructField((String)valueMeta.getName(), (DataType)((DataType)kettleSparkTypeMap.get(valueMeta.getType())), (boolean)true)).collect(Collectors.toList());
        return DataTypes.createStructType(fields);
    }

    public static LogLevel mapKettleLogLevel(org.pentaho.di.engine.api.reporting.LogLevel loggingLogLevel) {
        return (LogLevel)LEVEL_MAP.getOrDefault((Object)loggingLogLevel, (Object)LogLevel.BASIC);
    }

    public static SparkSession getSparkSession() {
        return SparkSession.builder().appName("SparkDriver").getOrCreate();
    }

    static {
        kettleSparkTypeMap.put(6, DataTypes.DoubleType);
        kettleSparkTypeMap.put(4, DataTypes.BooleanType);
        kettleSparkTypeMap.put(3, DataTypes.DateType);
        kettleSparkTypeMap.put(5, DataTypes.LongType);
        kettleSparkTypeMap.put(2, DataTypes.StringType);
        kettleSparkTypeMap.put(1, DataTypes.DoubleType);
        kettleSparkTypeMap.put(9, DataTypes.TimestampType);
        kettleSparkTypeMap.put(8, DataTypes.BinaryType);
        readSparkTypeMap = new HashMap<Integer, DataType>(kettleSparkTypeMap);
        readSparkTypeMap.put(3, DataTypes.StringType);
        readSparkTypeMap.put(9, DataTypes.StringType);
        LEVEL_MAP = HashBiMap.create();
        LEVEL_MAP.put((Object)org.pentaho.di.engine.api.reporting.LogLevel.BASIC, (Object)LogLevel.BASIC);
        LEVEL_MAP.put((Object)org.pentaho.di.engine.api.reporting.LogLevel.DEBUG, (Object)LogLevel.DEBUG);
        LEVEL_MAP.put((Object)org.pentaho.di.engine.api.reporting.LogLevel.DETAILED, (Object)LogLevel.DETAILED);
        LEVEL_MAP.put((Object)org.pentaho.di.engine.api.reporting.LogLevel.ERROR, (Object)LogLevel.ERROR);
        LEVEL_MAP.put((Object)org.pentaho.di.engine.api.reporting.LogLevel.MINIMAL, (Object)LogLevel.MINIMAL);
        LEVEL_MAP.put((Object)org.pentaho.di.engine.api.reporting.LogLevel.TRACE, (Object)LogLevel.ROWLEVEL);
    }

    @FunctionalInterface
    static interface RowErrorPutter {
        public void putError(RowMetaInterface var1, Object[] var2, long var3, String var5, String var6, String var7);
    }
}

