/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.command.action;

import java.util.Hashtable;
import java.util.TreeMap;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.ScrService;
import org.apache.karaf.scr.command.ScrUtils;
import org.apache.karaf.scr.command.action.ScrActionSupport;
import org.apache.karaf.scr.command.completer.DetailsCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.osgi.framework.ServiceReference;

@Command(scope="scr", name="details", description="Display available components")
@Service
public class DetailsAction
extends ScrActionSupport {
    @Argument(index=0, name="name", description="The component name", required=true, multiValued=false)
    @Completion(value=DetailsCompleter.class)
    String name;

    @Override
    protected Object doScrAction(ScrService scrService) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing the Details Action");
        }
        System.out.println(SimpleAnsi.INTENSITY_BOLD + "Component Details" + SimpleAnsi.INTENSITY_NORMAL);
        Component[] components = scrService.getComponents(this.name);
        for (Component component : ScrUtils.emptyIfNull(Component.class, components)) {
            this.printDetail("  Name                : ", component.getName());
            this.printDetail("  State               : ", ScrUtils.getState(component.getState()));
            Hashtable props = (Hashtable)component.getProperties();
            TreeMap map = new TreeMap(props);
            if (!map.isEmpty()) {
                System.out.println(SimpleAnsi.INTENSITY_BOLD + "  Properties          : " + SimpleAnsi.INTENSITY_NORMAL);
                for (Object key : map.keySet()) {
                    Object value = map.get(key);
                    this.printDetail("    ", key + "=" + value);
                }
            }
            Reference[] references = component.getReferences();
            System.out.println(SimpleAnsi.INTENSITY_BOLD + "References" + SimpleAnsi.INTENSITY_NORMAL);
            for (Reference reference : ScrUtils.emptyIfNull(Reference.class, references)) {
                this.printDetail("  Reference           : ", reference.getName());
                this.printDetail("    State             : ", reference.isSatisfied() ? "satisfied" : "unsatisfied");
                this.printDetail("    Multiple          : ", reference.isMultiple() ? "multiple" : "single");
                this.printDetail("    Optional          : ", reference.isOptional() ? "optional" : "mandatory");
                this.printDetail("    Policy            : ", reference.isStatic() ? "static" : "dynamic");
                ServiceReference[] boundRefs = reference.getServiceReferences();
                for (ServiceReference serviceReference : ScrUtils.emptyIfNull(ServiceReference.class, boundRefs)) {
                    StringBuffer b = new StringBuffer();
                    b.append("Bound Service ID ");
                    b.append(serviceReference.getProperty("service.id"));
                    String componentName = (String)serviceReference.getProperty("component.name");
                    if (componentName == null && (componentName = (String)serviceReference.getProperty("service.pid")) == null) {
                        componentName = (String)serviceReference.getProperty("service.description");
                    }
                    if (componentName != null) {
                        b.append(" (");
                        b.append(componentName);
                        b.append(")");
                    }
                    this.printDetail("    Service Reference : ", b.toString());
                }
                if (ScrUtils.emptyIfNull(ServiceReference.class, boundRefs).length != 0) continue;
                this.printDetail("    Service Reference : ", "No Services bound");
            }
        }
        return null;
    }

    private void printDetail(String header, String value) {
        System.out.println(SimpleAnsi.INTENSITY_BOLD + header + SimpleAnsi.INTENSITY_NORMAL + value);
    }
}

