/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.core;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.aries.rsa.core.ExportReferenceImpl;
import org.apache.aries.rsa.core.RemoteServiceAdminCore;
import org.apache.aries.rsa.spi.Endpoint;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportRegistrationImpl
implements ExportRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(ExportRegistrationImpl.class);
    private final RemoteServiceAdminCore rsaCore;
    private final ExportReferenceImpl exportReference;
    private final Closeable server;
    private final Throwable exception;
    private final ExportRegistrationImpl parent;
    private int instanceCount;
    private volatile boolean closed;

    private ExportRegistrationImpl(ExportRegistrationImpl parent, RemoteServiceAdminCore rsaCore, ExportReferenceImpl exportReference, Closeable server, Throwable exception) {
        this.parent = parent != null ? parent.parent : this;
        this.parent.addInstance();
        this.rsaCore = rsaCore;
        this.exportReference = exportReference;
        this.server = server;
        this.exception = exception;
    }

    public ExportRegistrationImpl(ExportRegistrationImpl parent) {
        this(parent, parent.rsaCore, new ExportReferenceImpl(parent.exportReference), parent.server, parent.exception);
    }

    public ExportRegistrationImpl(ServiceReference sref, Endpoint endpoint, RemoteServiceAdminCore rsaCore) {
        this(null, rsaCore, new ExportReferenceImpl(sref, endpoint.description()), (Closeable)endpoint, null);
    }

    public ExportRegistrationImpl(RemoteServiceAdminCore rsaCore, Throwable exception) {
        this(null, rsaCore, null, null, exception);
    }

    private void ensureParent() {
        if (this.parent != this) {
            throw new IllegalStateException("this method may only be called on the parent");
        }
    }

    public ExportReference getExportReferenceAlways() {
        return this.exportReference;
    }

    @Override
    public ExportReference getExportReference() {
        if (this.exportReference == null) {
            throw new IllegalStateException(this.getException());
        }
        return this.closed ? null : this.exportReference;
    }

    @Override
    public Throwable getException() {
        return this.closed ? null : this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        ExportRegistrationImpl exportRegistrationImpl = this;
        synchronized (exportRegistrationImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.rsaCore.removeExportRegistration(this);
        if (this.exportReference != null) {
            this.exportReference.close();
        }
        this.parent.removeInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstance() {
        this.ensureParent();
        ExportRegistrationImpl exportRegistrationImpl = this;
        synchronized (exportRegistrationImpl) {
            ++this.instanceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInstance() {
        this.ensureParent();
        ExportRegistrationImpl exportRegistrationImpl = this;
        synchronized (exportRegistrationImpl) {
            --this.instanceCount;
            if (this.instanceCount <= 0) {
                LOG.debug("really closing ExportRegistration now!");
                if (this.server != null) {
                    try {
                        this.server.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Error closing ExportRegistration", (Throwable)e);
                    }
                }
            }
        }
    }

    public String toString() {
        if (this.closed) {
            return "ExportRegistration closed";
        }
        EndpointDescription endpoint = this.getExportReference().getExportedEndpoint();
        ServiceReference serviceReference = this.getExportReference().getExportedService();
        String r = "EndpointDescription for ServiceReference " + serviceReference;
        r = r + "\n*** EndpointDescription: ****\n";
        if (endpoint == null) {
            r = r + "---> NULL <---- \n";
        } else {
            Set<Map.Entry<String, Object>> props = endpoint.getProperties().entrySet();
            for (Map.Entry<String, Object> entry : props) {
                Object value = entry.getValue();
                r = r + entry.getKey() + " => " + (value instanceof Object[] ? Arrays.toString((Object[])value) : value) + "\n";
            }
        }
        return r;
    }
}

