/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.ResultSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;

public class OracleDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 2, 4};
    }

    @Override
    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 1521;
        }
        return -1;
    }

    @Override
    public boolean supportsAutoInc() {
        return false;
    }

    @Override
    public String getLimitClause(int nrRows) {
        return " WHERE ROWNUM <= " + nrRows;
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " WHERE 1=0";
    }

    @Override
    public String getSQLTableExists(String tablename) {
        return this.getSQLQueryFields(tablename);
    }

    @Override
    public String getSQLColumnExists(String columnname, String tablename) {
        return this.getSQLQueryColumnFields(columnname, tablename);
    }

    public String getSQLQueryColumnFields(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName + " WHERE 1=0";
    }

    @Override
    public boolean needsToLockAllTables() {
        return false;
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) throws KettleDatabaseException {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        if (this.getAccessType() == 0) {
            if (!Utils.isEmpty(databaseName) && (databaseName.startsWith("/") || databaseName.startsWith(":"))) {
                return "jdbc:oracle:thin:@" + hostname + ":" + port + databaseName;
            }
            if (Utils.isEmpty(hostname) && (Utils.isEmpty(port) || port.equals("-1"))) {
                return "jdbc:oracle:thin:@" + databaseName;
            }
            return "jdbc:oracle:thin:@" + hostname + ":" + port + ":" + databaseName;
        }
        if (databaseName != null && databaseName.length() > 0) {
            if (hostname != null && hostname.length() > 0 && port != null && port.length() > 0) {
                return "jdbc:oracle:oci:@(description=(address=(host=" + hostname + ")(protocol=tcp)(port=" + port + "))(connect_data=(sid=" + databaseName + ")))";
            }
            return "jdbc:oracle:oci:@" + databaseName;
        }
        throw new KettleDatabaseException("Unable to construct a JDBC URL: at least the database name must be specified");
    }

    @Override
    public boolean supportsOptionsInURL() {
        return false;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getSQLSequenceExists(String sequenceName) {
        int dotPos = sequenceName.indexOf(46);
        String sql = "";
        if (dotPos == -1) {
            sql = "SELECT * FROM USER_SEQUENCES WHERE SEQUENCE_NAME = '" + sequenceName.toUpperCase() + "'";
        } else {
            String schemaName = sequenceName.substring(0, dotPos);
            String seqName = sequenceName.substring(dotPos + 1);
            sql = "SELECT * FROM ALL_SEQUENCES WHERE SEQUENCE_NAME = '" + seqName.toUpperCase() + "' AND SEQUENCE_OWNER = '" + schemaName.toUpperCase() + "'";
        }
        return sql;
    }

    @Override
    public String getSQLCurrentSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".currval FROM DUAL";
    }

    @Override
    public String getSQLNextSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".nextval FROM dual";
    }

    @Override
    public boolean supportsSequenceNoMaxValueOption() {
        return true;
    }

    @Override
    public boolean useSchemaNameForTableList() {
        return true;
    }

    @Override
    public boolean supportsSynonyms() {
        return true;
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD ( " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false) + " ) ";
    }

    @Override
    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP ( " + v.getName() + " ) " + Const.CR;
    }

    @Override
    public boolean supportsTimestampDataType() {
        return true;
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        boolean isQuoted;
        ValueMetaInterface tmpColumn = v.clone();
        String tmpName = v.getName();
        boolean bl = isQuoted = tmpName.startsWith("\"") && tmpName.endsWith("\"");
        if (isQuoted) {
            tmpName = tmpName.substring(1, tmpName.length() - 1);
        }
        int threeoh = tmpName.length() >= 30 ? 30 : tmpName.length();
        tmpName = tmpName.substring(0, threeoh);
        tmpName = tmpName + "_KTL";
        if (isQuoted) {
            tmpName = "\"" + tmpName + "\"";
        }
        tmpColumn.setName(tmpName);
        String sql = "";
        sql = sql + this.getAddColumnStatement(tablename, tmpColumn, tk, use_autoinc, pk, semicolon) + ";" + Const.CR;
        sql = sql + "UPDATE " + tablename + " SET " + tmpColumn.getName() + "=" + v.getName() + ";" + Const.CR;
        sql = sql + this.getDropColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon) + ";" + Const.CR;
        sql = sql + this.getAddColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon) + ";" + Const.CR;
        sql = sql + "UPDATE " + tablename + " SET " + v.getName() + "=" + tmpColumn.getName() + ";" + Const.CR;
        sql = sql + this.getDropColumnStatement(tablename, tmpColumn, tk, use_autoinc, pk, semicolon);
        return sql;
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        StringBuilder retval = new StringBuilder(128);
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval.append(fieldname).append(' ');
        }
        int type = v.getType();
        switch (type) {
            case 9: {
                if (this.supportsTimestampDataType()) {
                    retval.append("TIMESTAMP");
                    break;
                }
                retval.append("DATE");
                break;
            }
            case 3: {
                retval.append("DATE");
                break;
            }
            case 4: {
                retval.append("CHAR(1)");
                break;
            }
            case 1: 
            case 6: {
                retval.append("NUMBER");
                if (length <= 0) break;
                retval.append('(').append(length);
                if (precision > 0) {
                    retval.append(", ").append(precision);
                }
                retval.append(')');
                break;
            }
            case 5: {
                retval.append("INTEGER");
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval.append("CLOB");
                    break;
                }
                if (length == 1) {
                    retval.append("CHAR(1)");
                    break;
                }
                if (length > 0 && length <= this.getMaxVARCHARLength()) {
                    retval.append("VARCHAR2(").append(length).append(')');
                    break;
                }
                if (length <= 0) {
                    retval.append("VARCHAR2(2000)");
                    break;
                }
                retval.append("CLOB");
                break;
            }
            case 8: {
                retval.append("BLOB");
                break;
            }
            default: {
                retval.append(" UNKNOWN");
            }
        }
        if (add_cr) {
            retval.append(Const.CR);
        }
        return retval.toString();
    }

    @Override
    public String[] getReservedWords() {
        return new String[]{"ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "ARRAYLEN", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOTFOUND", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWLABEL", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "SQLBUF", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"};
    }

    @Override
    public String getSQLListOfProcedures() {
        return "SELECT DISTINCT DECODE(package_name, NULL, '', package_name||'.') || object_name FROM user_arguments ORDER BY 1";
    }

    @Override
    public String getSQLLockTables(String[] tableNames) {
        StringBuilder sql = new StringBuilder(128);
        for (int i = 0; i < tableNames.length; ++i) {
            sql.append("LOCK TABLE ").append(tableNames[i]).append(" IN EXCLUSIVE MODE;").append(Const.CR);
        }
        return sql.toString();
    }

    @Override
    public String getSQLUnlockTables(String[] tableNames) {
        return null;
    }

    @Override
    public String getExtraOptionsHelpText() {
        return "http://download.oracle.com/docs/cd/B19306_01/java.102/b14355/urls.htm#i1006362";
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"ojdbc14.jar", "orai18n.jar"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkIndexExists(Database database, String schemaName, String tableName, String[] idx_fields) throws KettleDatabaseException {
        String tablename = database.getDatabaseMeta().getQuotedSchemaTableCombination(schemaName, tableName);
        boolean[] exists = new boolean[idx_fields.length];
        for (int i = 0; i < exists.length; ++i) {
            exists[i] = false;
        }
        try {
            String sql = "SELECT * FROM USER_IND_COLUMNS WHERE TABLE_NAME = '" + tableName + "'";
            ResultSet res = null;
            try {
                res = database.openQuery(sql);
                if (res == null) {
                    boolean row22 = false;
                    return row22;
                }
                Object[] row22 = database.getRow(res);
                while (row22 != null) {
                    String column = database.getReturnRowMeta().getString(row22, "COLUMN_NAME", "");
                    int idx = Const.indexOfString(column, idx_fields);
                    if (idx >= 0) {
                        exists[idx] = true;
                    }
                    row22 = database.getRow(res);
                }
            }
            finally {
                if (res != null) {
                    database.closeQuery(res);
                }
            }
            boolean all = true;
            int i = 0;
            while (i < exists.length) {
                if (!all) return all;
                if (!exists[i]) {
                    all = false;
                }
                ++i;
            }
            return all;
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to determine if indexes exists on table [" + tablename + "]", e);
        }
    }

    @Override
    public boolean requiresCreateTablePrimaryKeyAppend() {
        return true;
    }

    @Override
    public boolean supportsPreparedStatementMetadataRetrieval() {
        return false;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 32;
    }

    @Override
    public String getSQLListOfSequences() {
        return "SELECT SEQUENCE_NAME FROM all_sequences";
    }

    @Override
    public String quoteSQLString(String string) {
        string = string.replaceAll("'", "''");
        string = string.replaceAll("\\n", "'||chr(13)||'");
        string = string.replaceAll("\\r", "'||chr(10)||'");
        return "'" + string + "'";
    }

    @Override
    public boolean releaseSavepoint() {
        return false;
    }

    @Override
    public String getTablespaceDDL(VariableSpace variables, DatabaseMeta databaseMeta, String tablespace) {
        if (!Utils.isEmpty(tablespace)) {
            return "TABLESPACE " + databaseMeta.quoteField(variables.environmentSubstitute(tablespace));
        }
        return "";
    }

    @Override
    public boolean supportsErrorHandlingOnBatchUpdates() {
        return false;
    }

    @Override
    public boolean supportsRepository() {
        return true;
    }

    @Override
    public int getMaxVARCHARLength() {
        return 2000;
    }

    @Override
    public String getDropTableIfExistsStatement(String tableName) {
        return "BEGIN EXECUTE IMMEDIATE 'DROP TABLE " + tableName + "'; EXCEPTION WHEN OTHERS THEN IF SQLCODE != -942 THEN RAISE; END IF; END;";
    }
}

