/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.MetricsInterface;
import org.pentaho.di.core.metrics.MetricsSnapshotInterface;

public class MetricsRegistry {
    private static MetricsRegistry registry = new MetricsRegistry();
    private Map<String, Map<String, MetricsSnapshotInterface>> snapshotMaps = new ConcurrentHashMap<String, Map<String, MetricsSnapshotInterface>>();
    private Map<String, Queue<MetricsSnapshotInterface>> snapshotLists = new ConcurrentHashMap<String, Queue<MetricsSnapshotInterface>>();

    public static MetricsRegistry getInstance() {
        return registry;
    }

    private MetricsRegistry() {
    }

    public void addSnapshot(LogChannelInterface logChannel, MetricsSnapshotInterface snapshot) {
        MetricsInterface metric = snapshot.getMetric();
        String channelId = logChannel.getLogChannelId();
        switch (metric.getType()) {
            case START: 
            case STOP: {
                Queue<MetricsSnapshotInterface> list = this.getSnapshotList(channelId);
                list.add(snapshot);
                break;
            }
            case MIN: 
            case MAX: 
            case SUM: 
            case COUNT: {
                Map<String, MetricsSnapshotInterface> map = this.getSnapshotMap(channelId);
                map.put(snapshot.getKey(), snapshot);
                break;
            }
        }
    }

    public Map<String, Queue<MetricsSnapshotInterface>> getSnapshotLists() {
        return this.snapshotLists;
    }

    public Map<String, Map<String, MetricsSnapshotInterface>> getSnapshotMaps() {
        return this.snapshotMaps;
    }

    public Queue<MetricsSnapshotInterface> getSnapshotList(String logChannelId) {
        Queue<MetricsSnapshotInterface> list = this.snapshotLists.get(logChannelId);
        if (list == null) {
            list = new ConcurrentLinkedQueue<MetricsSnapshotInterface>();
            this.snapshotLists.put(logChannelId, list);
        }
        return list;
    }

    public Map<String, MetricsSnapshotInterface> getSnapshotMap(String logChannelId) {
        Map<String, MetricsSnapshotInterface> map = this.snapshotMaps.get(logChannelId);
        if (map == null) {
            map = new ConcurrentHashMap<String, MetricsSnapshotInterface>();
            this.snapshotMaps.put(logChannelId, map);
        }
        return map;
    }
}

