/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.xmla.server.impl;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String nl = System.getProperty("line.separator");
    private static final Function1 IDENTITY_FUNCTION = new Function1<Object, Object>(){

        @Override
        public Object apply(Object param) {
            return param;
        }
    };
    private static final Predicate1 TRUE_PREDICATE1 = new Predicate1<Object>(){

        @Override
        public boolean test(Object o) {
            return true;
        }
    };

    public static void discard(boolean b) {
    }

    public static void discard(byte b) {
    }

    public static void discard(char c) {
    }

    public static void discard(double d) {
    }

    public static void discard(float d) {
    }

    public static void discard(int i) {
    }

    public static void discard(long l) {
    }

    public static void discard(Object o) {
    }

    public static void discard(short s) {
    }

    public static StringBuilder quoteForMdx(StringBuilder buf, String val) {
        buf.append("\"");
        String s0 = Util.replace(val, "\"", "\"\"");
        buf.append(s0);
        buf.append("\"");
        return buf;
    }

    public static String quoteMdxIdentifier(String id) {
        StringBuilder buf = new StringBuilder(id.length() + 20);
        Util.quoteMdxIdentifier(id, buf);
        return buf.toString();
    }

    public static void quoteMdxIdentifier(String id, StringBuilder buf) {
        buf.append('[');
        int start = buf.length();
        buf.append(id);
        Util.replace(buf, start, "]", "]]");
        buf.append(']');
    }

    public static String replace(String s, String find, String replace) {
        int found = s.indexOf(find);
        if (found == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 20);
        int start = 0;
        char[] chars = s.toCharArray();
        int step = find.length();
        if (step == 0) {
            sb.append(s);
            Util.replace(sb, 0, find, replace);
        } else {
            while (true) {
                sb.append(chars, start, found - start);
                if (found == s.length()) break;
                sb.append(replace);
                start = found + step;
                if ((found = s.indexOf(find, start)) != -1) continue;
                found = s.length();
            }
        }
        return sb.toString();
    }

    public static StringBuilder replace(StringBuilder buf, int start, String find, String replace) {
        int i;
        int findLength = find.length();
        if (findLength == 0) {
            for (int j = buf.length(); j >= 0; --j) {
                buf.insert(j, replace);
            }
            return buf;
        }
        int k = buf.length();
        while (k > 0 && (i = buf.lastIndexOf(find, k)) >= start) {
            buf.replace(i, i + find.length(), replace);
            k = i - findLength;
        }
        return buf;
    }

    public static String wildcardToRegexp(List<String> wildcards) {
        StringBuilder buf = new StringBuilder();
        block0: for (String value : wildcards) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            int i = 0;
            while (true) {
                int percent = value.indexOf(37, i);
                int underscore = value.indexOf(95, i);
                if (percent == -1 && underscore == -1) {
                    if (i >= value.length()) continue block0;
                    buf.append(Util.quotePattern(value.substring(i)));
                    continue block0;
                }
                if (underscore >= 0 && (underscore < percent || percent < 0)) {
                    if (i < underscore) {
                        buf.append(Util.quotePattern(value.substring(i, underscore)));
                    }
                    buf.append('.');
                    i = underscore + 1;
                    continue;
                }
                if (percent < 0 || percent >= underscore && underscore >= 0) break;
                if (i < percent) {
                    buf.append(Util.quotePattern(value.substring(i, percent)));
                }
                buf.append(".*");
                i = percent + 1;
            }
            throw new IllegalArgumentException();
        }
        return buf.toString();
    }

    public static String camelToUpper(String s) {
        StringBuilder buf = new StringBuilder(s.length() + 10);
        int prevUpper = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > prevUpper + 1) {
                    buf.append('_');
                }
                prevUpper = i;
            } else {
                c = Character.toUpperCase(c);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static Locale parseLocale(String localeString) {
        String[] strings = localeString.split("_");
        switch (strings.length) {
            case 1: {
                return new Locale(strings[0]);
            }
            case 2: {
                return new Locale(strings[0], strings[1]);
            }
            case 3: {
                return new Locale(strings[0], strings[1], strings[2]);
            }
        }
        throw Util.newInternal("bad locale string '" + localeString + "'");
    }

    public static <T> Iterable<T> filter(final Iterable<T> iterable, Predicate1<T> ... conds) {
        final Predicate1[] conds2 = Util.optimizeConditions(conds);
        if (conds2.length == 0) {
            return iterable;
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    final Iterator<T> iterator;
                    T next;
                    boolean hasNext;
                    {
                        this.iterator = iterable.iterator();
                        this.hasNext = this.moveToNext();
                    }

                    private boolean moveToNext() {
                        block0: while (this.iterator.hasNext()) {
                            this.next = this.iterator.next();
                            for (Predicate1 cond : conds2) {
                                if (!cond.test(this.next)) continue block0;
                            }
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public T next() {
                        Object t = this.next;
                        this.hasNext = this.moveToNext();
                        return t;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static <T> Predicate1<T>[] optimizeConditions(Predicate1<T>[] conds) {
        ArrayList<Predicate1<Predicate1>> predicateList = new ArrayList<Predicate1<Predicate1>>(Arrays.asList(conds));
        Iterator funcIter = predicateList.iterator();
        while (funcIter.hasNext()) {
            Predicate1 predicate = (Predicate1)funcIter.next();
            if (predicate != Util.truePredicate1()) continue;
            funcIter.remove();
        }
        if (predicateList.size() < conds.length) {
            return predicateList.toArray(new Predicate1[predicateList.size()]);
        }
        return conds;
    }

    public static <T extends Comparable> List<T> sort(Collection<T> collection) {
        Object[] a = collection.toArray(new Object[collection.size()]);
        Arrays.sort(a);
        return Util.cast(Arrays.asList(a));
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<T> comparator) {
        Object[] a = collection.toArray(new Object[collection.size()]);
        Arrays.sort(a, comparator);
        return Util.cast(Arrays.asList(a));
    }

    public static RuntimeException newInternal(String message) {
        return new RuntimeException("Internal error: " + message);
    }

    public static RuntimeException newInternal(Throwable e, String message) {
        return new RuntimeException("Internal error: " + message, e);
    }

    public static RuntimeException newError(String message) {
        return Util.newInternal(message);
    }

    public static RuntimeException newError(Throwable e, String message) {
        return Util.newInternal(e, message);
    }

    public static Map<String, String> toMap(final Properties properties) {
        return new AbstractMap<String, String>(){

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                return properties.entrySet();
            }
        };
    }

    public static String printMemory() {
        return Util.printMemory(null);
    }

    public static String printMemory(String msg) {
        Runtime rt = Runtime.getRuntime();
        long freeMemory = rt.freeMemory();
        long totalMemory = rt.totalMemory();
        StringBuilder buf = new StringBuilder(64);
        buf.append("FREE_MEMORY:");
        if (msg != null) {
            buf.append(msg);
            buf.append(':');
        }
        buf.append(' ');
        buf.append(freeMemory / 1024L);
        buf.append("kb ");
        long hundredths = freeMemory * 10000L / totalMemory;
        buf.append(hundredths / 100L);
        if ((hundredths %= 100L) >= 10L) {
            buf.append('.');
        } else {
            buf.append(".0");
        }
        buf.append(hundredths);
        buf.append('%');
        return buf.toString();
    }

    public static <T> List<T> cast(List<?> list) {
        return list;
    }

    public static <E extends Enum<E>> E lookup(Class<E> clazz, String name) {
        return Util.lookup(clazz, name, null);
    }

    public static <E extends Enum<E>> E lookup(Class<E> clazz, String name, E defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(clazz, name);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static BigDecimal makeBigDecimalFromDouble(double d) {
        return new BigDecimal(d, MathContext.DECIMAL64);
    }

    public static String quotePattern(String s) {
        return Pattern.quote(s);
    }

    public static <T> Function1<T, T> identityFunction() {
        return IDENTITY_FUNCTION;
    }

    public static <PT> Predicate1<PT> truePredicate1() {
        return TRUE_PREDICATE1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Predicate1<PT>
    implements Predicate,
    Function1<PT, Boolean> {
        @Override
        public Boolean apply(PT param) {
            return this.test(param);
        }

        public boolean evaluate(Object o) {
            return this.test(o);
        }

        public abstract boolean test(PT var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Function1<PT, RT> {
        public RT apply(PT var1);
    }
}

