/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Hop;
import org.pentaho.di.engine.api.model.ModelElement;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.execution.FinalOperationCountEvent;
import org.pentaho.di.engine.spark.impl.execution.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.functions.FileOutputContentFunctionPartitioned;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;

public class FileOutputSparkOperation
implements SparkOperation {
    private final TransMeta transMeta;
    private final TextFileOutputMeta fileMeta;
    private final Operation operation;
    private final JavaSparkContext sparkContext;
    private final AtomicReference<Object[]> nextRow = new AtomicReference();
    private final Consumer<JavaRDD<Row>> DEFAULT_FILE_ACTION = this::saveDefaultAction;
    private Map<String, Consumer<JavaRDD<Row>>> fileActionMap = ImmutableMap.of((Object)"file", this::saveAsLocalFile, (Object)"hdfs", this.DEFAULT_FILE_ACTION);
    private int totalRows = 0;
    private final boolean isFinalOperation;

    public FileOutputSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        this.transMeta = stepMeta.getParentTransMeta();
        this.fileMeta = (TextFileOutputMeta)Util.getTypedStepMeta((StepMeta)stepMeta, TextFileOutputMeta.class);
        this.fileMeta.setFileFormat("NONE");
        this.operation = operation;
        this.sparkContext = sparkContext;
        this.isFinalOperation = operation.getHopsOut() == null || operation.getHopsOut().isEmpty();
    }

    @VisibleForTesting
    FileOutputSparkOperation(Operation operation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext, Map<String, Consumer<JavaRDD<Row>>> fileActionMap) {
        this(operation, null, stepMeta, sparkContext, executionContext);
        this.fileActionMap = fileActionMap;
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(FileOutputSparkOperation::new, new Supplier[0]);
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public String getId() {
        return this.operation.getId();
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        Set expectedOutputs = subscriber.getExpectedOutputs();
        JavaRDD rdd = subscriber.getInput().map(input -> expectedOutputs.isEmpty() ? input : input.cache()).orElseGet(() -> ((JavaSparkContext)this.sparkContext).emptyRDD());
        expectedOutputs.forEach(output -> subscriber.addOutput(output, rdd));
        subscriber.registerDriverAction(() -> this.fileActionMap.getOrDefault(this.getUri().getScheme(), this.DEFAULT_FILE_ACTION).accept((JavaRDD<Row>)rdd));
    }

    private void saveDefaultAction(JavaRDD<Row> rdd) {
        try {
            FileOutputContentFunctionPartitioned partMap = new FileOutputContentFunctionPartitioned(this.getId(), this.transMeta, this.operation);
            JavaRDD outputRdd = rdd.mapPartitions((FlatMapFunction)partMap);
            outputRdd.saveAsTextFile(this.getUri().getPath());
            if (this.isFinalOperation) {
                FinalOperationCountEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getId(), (long)-1L);
            }
        }
        catch (Exception e) {
            OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.operation.getId(), (Throwable)e);
        }
    }

    private void saveAsLocalFile(JavaRDD<Row> rdd) {
        try {
            boolean init;
            Preconditions.checkArgument((boolean)"file".equals(this.getUri().getScheme()));
            TextFileOutput step = (TextFileOutput)Util.getTypedStep((TransMeta)this.transMeta, (String)this.operation.getId(), TextFileOutput.class);
            step.setInputRowMeta(Util.getRowMeta((TransMeta)this.transMeta, (String)this.previousStepName()));
            if (step.getParentVariableSpace() == null) {
                step.setParentVariableSpace((VariableSpace)new Variables());
            }
            if ((init = step.init(step.getStepMeta().getStepMetaInterface(), step.getStepDataInterface())) && step.getErrors() == 0L) {
                step.setRowHandler(Util.rowGetter(this.nextRow::get));
                rdd.toLocalIterator().forEachRemaining(row -> this.processRow(step, (Row)row));
                this.processRow(step, (Row)new KettleRow(Util.getRowMeta((TransMeta)this.transMeta, (String)this.operation.getId()), null));
                step.dispose(step.getStepMeta().getStepMetaInterface(), step.getStepDataInterface());
                if (this.isFinalOperation) {
                    FinalOperationCountEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.getId(), (long)this.totalRows);
                }
            } else {
                OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.operation.getId(), (Throwable)new RuntimeException("Error initializing " + this.operation.getId()));
            }
        }
        catch (Exception e) {
            OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.operation.getId(), (Throwable)e);
        }
    }

    private String previousStepName() {
        return this.operation.getHopsIn().stream().map(Hop::getFrom).map(ModelElement::getId).findFirst().orElse(this.operation.getId());
    }

    private void processRow(TextFileOutput step, Row row) {
        this.nextRow.set(row.getObjects());
        try {
            if (step.processRow(step.getStepMeta().getStepMetaInterface(), step.getStepDataInterface())) {
                ++this.totalRows;
            }
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    private URI getUri() {
        try {
            URI uri = new URI(this.fileMeta.getFileName());
            if (uri.getScheme() == null) {
                uri = new URI("file", uri.getHost(), uri.getPath(), uri.getFragment());
            }
            return uri;
        }
        catch (URISyntaxException e) {
            return new File(this.fileMeta.getFileName()).toURI();
        }
    }
}

