/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.engine.daemon.service;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.pentaho.di.engine.api.remote.Execution;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.pentaho.osgi.objecttunnel.TunnelMarker;
import org.pentaho.osgi.objecttunnel.TunneledPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteExecution
implements Execution<Serializable> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteExecution.class);
    private final ExecutorService executorService;
    private final ExecutionRequest request;
    private final UUID uuid;
    private final BlockingDeque<Serializable> updates = Queues.newLinkedBlockingDeque((int)512);
    private final Semaphore executionClaim = new Semaphore(1);
    private final AtomicBoolean acceptingUpdates = new AtomicBoolean(true);
    private static final Future<Void> INIT = CompletableFuture.completedFuture(null);
    private final AtomicReference<Future<Void>> processing = new AtomicReference<Future<Void>>(INIT);
    final CompletableFuture<Void> streaming = new CompletableFuture();
    private boolean sendHeartbeat = true;

    RemoteExecution(ExecutionRequest request, UUID uuid) {
        this.request = request;
        this.uuid = uuid;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Execution Request Stream: " + uuid + "-%d").build();
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
    }

    public ExecutionRequest getRequest() {
        if (this.executionClaim.tryAcquire()) {
            return this.request;
        }
        return null;
    }

    public void releaseRequest() {
        this.executionClaim.release();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public InputStream eventStream() throws IOException {
        if (this.streaming.isDone()) {
            return this.sendFinal();
        }
        Future<Void> current = this.processing.get();
        EventConsumer eventConsumer = new EventConsumer();
        if (this.processing.compareAndSet(current, eventConsumer.task)) {
            try {
                current.get(5L, TimeUnit.SECONDS);
            }
            catch (CancellationException | ExecutionException e) {
                LOG.warn("Error on event consumer", (Throwable)e);
            }
            catch (InterruptedException | TimeoutException e) {
                current.cancel(true);
            }
            this.executorService.execute(eventConsumer.task);
            return eventConsumer.inputStream;
        }
        throw new IOException("Unable to open an event stream. Ensure only one thread is processing events.");
    }

    private InputStream sendFinal() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(buffer);){
            objectOutputStream.writeObject(TunnelMarker.END);
        }
        return new ByteArrayInputStream(buffer.toByteArray());
    }

    public void update(Serializable event) {
        if (!this.acceptingUpdates.get()) {
            LOG.warn("Received event after Execution was closed", (Object)event);
        } else if (!this.updates.offer(event)) {
            LOG.warn("Buffer capacity is full, event will be skipped", (Object)event);
        } else {
            try {
                LOG.info("Received event for execution ({}) - {}", (Object)this.uuid, (Object)((TunneledPayload)event).getObjectStr());
            }
            catch (Exception e) {
                LOG.info("Received event for execution ({}) - Unable to serialize event");
            }
        }
    }

    public void close() {
        LOG.info("Closing Execution");
        this.acceptingUpdates.set(false);
    }

    public void closeExceptionally(org.pentaho.di.engine.api.remote.ExecutionException throwable) {
        LOG.info("Closing Execution with Exception", (Throwable)throwable);
        this.acceptingUpdates.set(false);
        this.streaming.completeExceptionally((Throwable)throwable);
    }

    void setSendHeartbeat(boolean sendHeartbeat) {
        this.sendHeartbeat = sendHeartbeat;
    }

    public boolean isClaimed() {
        return this.executionClaim.availablePermits() == 0;
    }

    private static class HeartBeat
    implements Runnable,
    AutoCloseable {
        private ObjectOutputStream outputStream;
        private boolean running = true;
        private static String HEARTBEAT = "heartbeat";

        public HeartBeat(ObjectOutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public void close() throws Exception {
            this.running = false;
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    this.outputStream.writeObject(HEARTBEAT);
                    Thread.sleep(60000L);
                }
                catch (IOException | InterruptedException e) {
                    this.running = false;
                    return;
                }
            }
        }
    }

    private class EventConsumer
    implements Runnable {
        final PipedOutputStream outputStream = new PipedOutputStream();
        final PipedInputStream inputStream = new PipedInputStream(this.outputStream);
        final FutureTask<Void> task = new FutureTask<Object>(this, null);

        private EventConsumer() throws IOException {
        }

        @Override
        public void run() {
            try (ObjectOutputStream objectStream = new ObjectOutputStream(this.outputStream);
                 HeartBeat heartBeat = new HeartBeat(objectStream);){
                if (RemoteExecution.this.sendHeartbeat) {
                    Thread thread = new Thread(heartBeat);
                    thread.setName("Daemon Heartbeat");
                    thread.setDaemon(true);
                    thread.start();
                }
                while (RemoteExecution.this.processing.get() == this.task && !RemoteExecution.this.streaming.isDone()) {
                    Serializable head = (Serializable)RemoteExecution.this.updates.poll(1L, TimeUnit.SECONDS);
                    if (head != null) {
                        LOG.info("Received Object from Driver: " + head);
                        objectStream.writeObject(head);
                    }
                    if (!RemoteExecution.this.acceptingUpdates.get() && RemoteExecution.this.updates.isEmpty()) {
                        LOG.info("Data Stream complete. Writing End Marker.");
                        objectStream.writeObject(TunnelMarker.END);
                        RemoteExecution.this.streaming.complete(null);
                    }
                    objectStream.flush();
                }
                heartBeat.running = false;
            }
            catch (IOException e) {
                LOG.warn("Unable to write event to event stream", (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

