/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public final class MinDocQuery
extends Query {
    private final int minDoc;

    public MinDocQuery(int minDoc) {
        this.minDoc = minDoc;
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.minDoc;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        MinDocQuery that = (MinDocQuery)((Object)obj);
        return this.minDoc == that.minDoc;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final int maxDoc = context.reader().maxDoc();
                if (context.docBase + maxDoc <= MinDocQuery.this.minDoc) {
                    return null;
                }
                final int segmentMinDoc = Math.max(0, MinDocQuery.this.minDoc - context.docBase);
                DocIdSetIterator disi = new DocIdSetIterator(){
                    int doc = -1;

                    public int docID() {
                        return this.doc;
                    }

                    public int nextDoc() throws IOException {
                        return this.advance(this.doc + 1);
                    }

                    public int advance(int target) throws IOException {
                        assert (target > this.doc);
                        this.doc = this.doc == -1 ? Math.max(target, segmentMinDoc) : target;
                        if (this.doc >= maxDoc) {
                            this.doc = Integer.MAX_VALUE;
                        }
                        return this.doc;
                    }

                    public long cost() {
                        return maxDoc - segmentMinDoc;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }
        };
    }

    public String toString(String field) {
        return "MinDocQuery(minDoc=" + this.minDoc + ")";
    }
}

