/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.baserver.utils.BAServerCommonDialog;
import org.pentaho.di.baserver.utils.SetSessionVariableMeta;
import org.pentaho.di.baserver.utils.widgets.CheckBoxBuilder;
import org.pentaho.di.baserver.utils.widgets.TableViewBuilder;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class SetSessionVariableDialog
extends BAServerCommonDialog<SetSessionVariableMeta> {
    private Button wApplyFormatting;
    private TableView wFields;

    public SetSessionVariableDialog(Shell parent, Object in, TransMeta transMeta, String name) {
        super(parent, (SetSessionVariableMeta)((Object)in), transMeta, name);
    }

    @Override
    protected String getTitleKey() {
        return "SetSessionVariableDialog.DialogTitle";
    }

    @Override
    protected void buildContent(Composite parent) {
        this.wApplyFormatting = (Button)new CheckBoxBuilder(parent, this.props).setText(BaseMessages.getString((Class)PKG, (String)"SetSessionVariableDialog.Label.ApplyFormatting", (String[])new String[0])).setToolTipText(BaseMessages.getString((Class)PKG, (String)"SetSessionVariableDialog.Label.ApplyFormatting.Tooltip", (String[])new String[0])).setTopPlacement(0).setLeftPlacement(0).setRightPlacement(100).build();
        this.wApplyFormatting.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Event e = new Event();
                e.widget = SetSessionVariableDialog.this.wApplyFormatting;
                SetSessionVariableDialog.this.changeListener.modifyText(new ModifyEvent(e));
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        ColumnInfo cFieldNames = new ColumnInfo(BaseMessages.getString((Class)PKG, (String)"SetSessionVariableDialog.Column.FieldName", (String[])new String[0]), 1, false);
        cFieldNames.setComboValues(this.getFieldNames());
        ColumnInfo variableColumn = new ColumnInfo(BaseMessages.getString((Class)PKG, (String)"SetSessionVariableDialog.Column.VariableName", (String[])new String[0]), 1, false);
        variableColumn.setUsingVariables(true);
        variableColumn.setToolTip(BaseMessages.getString((Class)PKG, (String)"SetSessionVariableDialog.Column.VariableName.Tooltip", (String[])new String[0]));
        ColumnInfo defaultValueColumn = new ColumnInfo(BaseMessages.getString((Class)PKG, (String)"SetSessionVariableDialog.Column.DefaultValue", (String[])new String[0]), 1, false);
        defaultValueColumn.setUsingVariables(true);
        defaultValueColumn.setToolTip(BaseMessages.getString((Class)PKG, (String)"SetSessionVariableDialog.Column.DefaultValue.Tooltip", (String[])new String[0]));
        this.wFields = (TableView)new TableViewBuilder(this.props, parent, variables).addColumnInfo(cFieldNames).addColumnInfo(variableColumn).addColumnInfo(defaultValueColumn).setTop((Control)this.wApplyFormatting).setTopMargin(10).setBottomPlacement(100).setLeftPlacement(0).setRightPlacement(100).build();
        this.wFields.addModifyListener(this.changeListener);
    }

    @Override
    protected Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"icons/setsessionvariable.svg", (int)32, (int)32);
    }

    @Override
    protected void loadData(SetSessionVariableMeta meta) {
        super.loadData(meta);
        this.wApplyFormatting.setSelection(meta.isUsingFormatting());
        int metaFieldsLength = meta.getFieldName().length;
        this.wFields.table.removeAll();
        this.wFields.table.setItemCount(metaFieldsLength == 0 ? 1 : metaFieldsLength);
        for (int i = 0; i < metaFieldsLength; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            int index = 0;
            item.setText(++index, Const.NVL((String)meta.getFieldName()[i], (String)""));
            item.setText(++index, Const.NVL((String)meta.getVariableName()[i], (String)""));
            item.setText(++index, Const.NVL((String)meta.getDefaultValue()[i], (String)""));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    @Override
    protected void saveData(SetSessionVariableMeta meta) {
        super.saveData(meta);
        meta.setUseFormatting(this.wApplyFormatting.getSelection());
        int count = this.wFields.nrNonEmpty();
        meta.allocate(count);
        for (int i = 0; i < count; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            int index = 0;
            meta.getFieldName()[i] = item.getText(++index);
            meta.getVariableName()[i] = item.getText(++index);
            meta.getDefaultValue()[i] = item.getText(++index);
        }
    }

    @Override
    protected int getMinimumHeight() {
        return 414;
    }

    @Override
    protected int getMinimumWidth() {
        return 505;
    }
}

