/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.aries.rsa.spi.ExportPolicy;
import org.apache.aries.rsa.topologymanager.exporter.DefaultExportPolicy;
import org.apache.aries.rsa.topologymanager.exporter.EndpointListenerNotifier;
import org.apache.aries.rsa.topologymanager.exporter.EndpointRepository;
import org.apache.aries.rsa.topologymanager.exporter.TopologyManagerExport;
import org.apache.aries.rsa.topologymanager.importer.TopologyManagerImport;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static final String RSA_EXPORT_POLICY_FILTER = "rsa.export.policy.filter";
    static final String DOSGI_SERVICES = "(service.exported.interfaces=*)";
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private TopologyManagerExport exportManager;
    private TopologyManagerImport importManager;
    private EndpointListenerNotifier notifier;
    private ServiceTracker<RemoteServiceAdmin, RemoteServiceAdmin> rsaTracker;
    private ThreadPoolExecutor exportExecutor;
    private ServiceTracker<EndpointListener, EndpointListener> epListenerTracker;
    private ServiceTracker<ExportPolicy, ExportPolicy> policyTracker;

    public void start(final BundleContext bc) throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("name", "default");
        bc.registerService(ExportPolicy.class, (Object)new DefaultExportPolicy(), props);
        Filter policyFilter = this.exportPolicyFilter(bc);
        this.policyTracker = new ServiceTracker<ExportPolicy, ExportPolicy>(bc, policyFilter, null){

            public ExportPolicy addingService(ServiceReference<ExportPolicy> reference) {
                ExportPolicy policy = (ExportPolicy)super.addingService(reference);
                if (Activator.this.exportManager == null) {
                    Activator.this.doStart(bc, policy);
                }
                return policy;
            }

            public void removedService(ServiceReference<ExportPolicy> reference, ExportPolicy service) {
                if (Activator.this.exportManager != null) {
                    Activator.this.doStop(bc);
                }
                super.removedService(reference, (Object)service);
            }
        };
        this.policyTracker.open();
    }

    private Filter exportPolicyFilter(BundleContext bc) throws InvalidSyntaxException {
        String filter = bc.getProperty(RSA_EXPORT_POLICY_FILTER);
        if (filter == null) {
            filter = "(name=default)";
        }
        return FrameworkUtil.createFilter((String)String.format("(&(objectClass=%s)%s)", ExportPolicy.class.getName(), filter));
    }

    public void doStart(BundleContext bc, ExportPolicy policy) {
        LOG.debug("TopologyManager: start()");
        EndpointRepository endpointRepo = new EndpointRepository();
        this.notifier = new EndpointListenerNotifier(endpointRepo);
        this.epListenerTracker = new EndpointListenerTracker(bc);
        endpointRepo.setNotifier(this.notifier);
        this.exportExecutor = new ThreadPoolExecutor(5, 10, 50L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.exportManager = new TopologyManagerExport(endpointRepo, this.exportExecutor, policy);
        this.importManager = new TopologyManagerImport(bc);
        this.rsaTracker = new RSATracker(bc, RemoteServiceAdmin.class, null);
        bc.addServiceListener((ServiceListener)this.exportManager);
        this.rsaTracker.open();
        this.epListenerTracker.open();
        this.exportExistingServices(bc);
        this.importManager.start();
    }

    public void stop(BundleContext bc) throws Exception {
        this.policyTracker.close();
    }

    public void doStop(BundleContext bc) {
        LOG.debug("TopologyManager: stop()");
        this.epListenerTracker.close();
        bc.removeServiceListener((ServiceListener)this.exportManager);
        this.exportExecutor.shutdown();
        this.importManager.stop();
        this.rsaTracker.close();
        this.exportManager = null;
    }

    public void exportExistingServices(BundleContext context) {
        try {
            ServiceReference[] references = context.getServiceReferences((String)null, DOSGI_SERVICES);
            if (references != null) {
                for (ServiceReference sref : references) {
                    this.exportManager.serviceChanged(new ServiceEvent(1, sref));
                }
            }
        }
        catch (InvalidSyntaxException e) {
            LOG.error("Error in filter {}. This should not occur!", (Object)DOSGI_SERVICES);
        }
    }

    private final class RSATracker
    extends ServiceTracker<RemoteServiceAdmin, RemoteServiceAdmin> {
        private RSATracker(BundleContext context, Class<RemoteServiceAdmin> clazz, ServiceTrackerCustomizer<RemoteServiceAdmin, RemoteServiceAdmin> customizer) {
            super(context, clazz, customizer);
        }

        public RemoteServiceAdmin addingService(ServiceReference<RemoteServiceAdmin> reference) {
            RemoteServiceAdmin rsa = (RemoteServiceAdmin)super.addingService(reference);
            LOG.debug("New RemoteServiceAdmin {} detected, trying to import and export services with it", (Object)rsa);
            Activator.this.importManager.add(rsa);
            Activator.this.exportManager.add(rsa);
            return rsa;
        }

        public void removedService(ServiceReference<RemoteServiceAdmin> reference, RemoteServiceAdmin rsa) {
            Activator.this.exportManager.remove(rsa);
            Activator.this.importManager.remove(rsa);
            super.removedService(reference, (Object)rsa);
        }
    }

    private final class EndpointListenerTracker
    extends ServiceTracker<EndpointListener, EndpointListener> {
        private EndpointListenerTracker(BundleContext context) {
            super(context, EndpointListener.class, null);
        }

        public EndpointListener addingService(ServiceReference<EndpointListener> reference) {
            EndpointListener listener = (EndpointListener)super.addingService(reference);
            Activator.this.notifier.add(listener, EndpointListenerNotifier.getFiltersFromEndpointListenerScope(reference));
            return listener;
        }

        public void modifiedService(ServiceReference<EndpointListener> reference, EndpointListener listener) {
            super.modifiedService(reference, (Object)listener);
            Activator.this.notifier.add(listener, EndpointListenerNotifier.getFiltersFromEndpointListenerScope(reference));
        }

        public void removedService(ServiceReference<EndpointListener> reference, EndpointListener listener) {
            Activator.this.notifier.remove(listener);
            super.removedService(reference, (Object)listener);
        }
    }
}

