/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.palo.core;

import com.jedox.palojlib.interfaces.ICube;
import com.jedox.palojlib.interfaces.IDatabase;
import com.jedox.palojlib.interfaces.IDimension;
import com.jedox.palojlib.interfaces.IElement;
import java.util.ArrayList;
import org.pentaho.di.palo.core.PaloDimensionCache;
import org.pentaho.di.palo.core.PaloHelper;

public class PaloCubeCache {
    private final IDatabase database;
    private final IDimension[] dimensions;
    private final ICube cube;
    private final ArrayList<PaloDimensionCache> cubeCache = new ArrayList();
    private final boolean enableCache;

    public PaloCubeCache(PaloHelper helper, String cubeName, boolean enableCache) throws Exception {
        this.database = helper.getDatabase();
        this.cube = this.database.getCubeByName(cubeName);
        this.enableCache = enableCache;
        if (this.cube == null) {
            throw new Exception("The cube " + cubeName + " does not exist.");
        }
        this.dimensions = this.cube.getDimensions();
    }

    public void loadCubeCache() throws Exception {
        if (!this.enableCache) {
            throw new Exception("Cache is not enabled");
        }
        this.cubeCache.clear();
        for (IDimension d : this.cube.getDimensions()) {
            PaloDimensionCache dimensionCache = new PaloDimensionCache(this.database, d, this.enableCache);
            dimensionCache.loadDimensionCache();
            this.cubeCache.add(dimensionCache);
        }
    }

    public IElement getElement(int dimensionIndex, String dimensionName) {
        IElement element = null;
        if (this.cubeCache.size() <= dimensionIndex) {
            for (IDimension d : this.cube.getDimensions()) {
                this.cubeCache.add(new PaloDimensionCache(this.database, d, this.enableCache));
            }
        }
        element = this.cubeCache.get(dimensionIndex).getElement(dimensionName);
        return element;
    }

    public ICube getCube() {
        return this.cube;
    }

    public String getCubeName() {
        return this.cube.getName();
    }

    public IDimension[] getDimensions() {
        return this.dimensions;
    }
}

