/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.engine.api.Engine;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.model.ActingPrincipal;
import org.pentaho.di.engine.spark.SystemManager;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.ael.adapters.TransMetaConverter;
import org.pentaho.pdi.spark.driver.CLI;

public class StandaloneSparkMain {
    protected static SystemManager systemManager = SystemManager.getInstance();

    public static void main(String[] args) throws Exception {
        CLI cli = new CLI();
        if (args.length == 0) {
            cli.printUsage();
            System.exit(2);
        } else if (cli.parse(Lists.newArrayList((Object[])args))) {
            SparkConf sparkConf = new SparkConf();
            if (cli.runInDriver()) {
                sparkConf.setAppName("RunInDriver").setMaster("local[*]");
            }
            SparkContext sparkContext = SparkContext.getOrCreate((SparkConf)sparkConf);
            CompletableFuture<Void> execute = StandaloneSparkMain.execute(cli);
            if (!cli.keepAlive()) {
                execute.whenComplete((success, error) -> {
                    Optional.ofNullable(error).ifPresent(Throwable::printStackTrace);
                    KettleEnvironment.shutdown();
                    sparkContext.stop();
                    System.exit(error == null ? 0 : 1);
                });
            }
        } else {
            System.exit(2);
        }
    }

    private static CompletableFuture<Void> execute(CLI cli) {
        String engineId = cli.getEngine();
        StandaloneSparkMain.println("Using engine: " + engineId);
        return ((CompletableFuture)((CompletableFuture)systemManager.loadEngine(engineId).thenCombine(StandaloneSparkMain.getTransformation(cli), Engine::prepare)).thenCompose(context -> {
            context.setActingPrincipal((Principal)new ActingPrincipal("anonymous"));
            context.setLoggingLogLevel(cli.getLogLevel());
            context.subscribeAll(Transformation.class, Status.class, StandaloneSparkMain::printEvent);
            context.subscribeAll(Operation.class, Status.class, StandaloneSparkMain::printEvent);
            context.subscribeAll(Operation.class, Metrics.class, StandaloneSparkMain::printEvent);
            return context.execute();
        })).thenAccept(result -> {
            StandaloneSparkMain.println("\n***** COMPLETED *****\n");
            System.out.format("%-32s|%10s%10s%10s%10s%n", "Step ID", "in", "out", "dropped", "inFlight");
            result.getDataEventReport().forEach((operation, metrics) -> System.out.format("%-32s|%10d%10d%10d%10d%n", operation.getId(), metrics.getIn(), metrics.getOut(), metrics.getDropped(), metrics.getInFlight()));
        });
    }

    private static void printEvent(LogicalModelElement src, Object event) {
        StandaloneSparkMain.println(MessageFormat.format("{0} {1}: {2}", src.getClass().getSimpleName(), src.getId(), event));
    }

    private static CompletableFuture<Transformation> getTransformation(CLI cli) {
        return CompletableFuture.runAsync(() -> ((SystemManager)systemManager).initializeOnce()).thenApply(ready -> {
            String ktrPath = cli.getKtrPath().orElseThrow(() -> new IllegalArgumentException("--ktrFile not specified"));
            try {
                return TransMetaConverter.convert((TransMeta)new TransMeta(ktrPath));
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        });
    }

    private static void println(String message) {
        System.out.println(message);
    }
}

