/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class POPoissonSample
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    private static final TupleFactory tf = TupleFactory.getInstance();
    private static Result eop = new Result(3, null);
    private int numRowsSampled = 0;
    private long avgTupleMemSz = 0L;
    private long rowNum = 0L;
    private long skipInterval = -1L;
    private long memToSkipPerSample = 0L;
    private boolean numRowSplTupleReturned = false;
    public static final int DEFAULT_SAMPLE_RATE = 17;
    private int sampleRate = 0;
    private float heapPerc = 0.0f;
    private long totalMemory = Runtime.getRuntime().maxMemory();
    private Result newSample = null;

    public POPoissonSample(OperatorKey k, int rp, int sr, float hp, long tm) {
        super(k, rp, null);
        this.sampleRate = sr;
        this.heapPerc = hp;
        if (tm != -1L) {
            this.totalMemory = tm;
        }
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitPoissonSample(this);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        if (this.numRowSplTupleReturned) {
            return eop;
        }
        Result res = null;
        if (this.skipInterval == -1L) {
            while (true) {
                res = this.processInput();
                if (res.returnStatus == 1) continue;
                if (res.returnStatus == 3) {
                    return res;
                }
                if (res.returnStatus == 2) {
                    return res;
                }
                if (res.result != null) break;
            }
            long availRedMem = (long)((float)this.totalMemory * this.heapPerc);
            this.memToSkipPerSample = availRedMem / (long)this.sampleRate;
            this.updateSkipInterval((Tuple)res.result);
            ++this.rowNum;
            this.newSample = res;
        }
        for (long numSkipped = 0L; numSkipped < this.skipInterval; ++numSkipped) {
            res = this.processInput();
            if (res.returnStatus == 1) continue;
            if (res.returnStatus == 3) {
                if (this.parentPlan.endOfAllInput) {
                    return this.createNumRowTuple((Tuple)this.newSample.result);
                }
                return res;
            }
            if (res.returnStatus == 2) {
                return res;
            }
            ++this.rowNum;
        }
        while (true) {
            res = this.processInput();
            if (res.returnStatus == 1) continue;
            if (res.returnStatus == 3) {
                if (this.parentPlan.endOfAllInput) {
                    return this.createNumRowTuple((Tuple)this.newSample.result);
                }
                return res;
            }
            if (res.returnStatus == 2) {
                return res;
            }
            if (res.result != null) break;
        }
        this.updateSkipInterval((Tuple)res.result);
        Result currentSample = this.newSample;
        ++this.rowNum;
        this.newSample = res;
        return currentSample;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public String name() {
        return this.getAliasString() + "PoissonSample - " + this.mKey.toString();
    }

    private void updateSkipInterval(Tuple t) {
        this.avgTupleMemSz = (this.avgTupleMemSz * (long)this.numRowsSampled + t.getMemorySize()) / (long)(this.numRowsSampled + 1);
        this.skipInterval = this.memToSkipPerSample / this.avgTupleMemSz;
        if (this.numRowsSampled < 5) {
            this.skipInterval /= (long)(10 - this.numRowsSampled);
        }
        ++this.numRowsSampled;
    }

    private Result createNumRowTuple(Tuple sample) throws ExecException {
        int sz = sample == null ? 0 : sample.size();
        Tuple t = tf.newTuple(sz + 2);
        if (sample != null) {
            for (int i = 0; i < sample.size(); ++i) {
                t.set(i, sample.get(i));
            }
        }
        t.set(sz, "\u4956\u3838_pig_inTeRnal-spEcial_roW_num_tuple3kt579CFLehkblah");
        t.set(sz + 1, this.rowNum);
        this.numRowSplTupleReturned = true;
        return new Result(0, t);
    }
}

