/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;

public class TezResourceManager {
    private static TezResourceManager instance = null;
    private boolean inited = false;
    private Path stagingDir;
    private FileSystem remoteFs;
    private Configuration conf;
    private PigContext pigContext;
    public Map<String, Path> resources = new HashMap<String, Path>();

    public static TezResourceManager getInstance() {
        if (instance == null) {
            instance = new TezResourceManager();
        }
        return instance;
    }

    public void init(PigContext pigContext, Configuration conf) throws IOException {
        if (!this.inited) {
            this.stagingDir = FileLocalizer.getTemporaryResourcePath(pigContext);
            this.remoteFs = FileSystem.get((Configuration)conf);
            this.conf = conf;
            this.pigContext = pigContext;
            this.inited = true;
        }
    }

    public Path getStagingDir() {
        return this.stagingDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path addTezResource(URI uri) throws IOException {
        TezResourceManager tezResourceManager = this;
        synchronized (tezResourceManager) {
            Path resourcePath = new Path(uri.getPath());
            String resourceName = resourcePath.getName();
            if (this.resources.containsKey(resourceName)) {
                return this.resources.get(resourceName);
            }
            if (!this.pigContext.getExecType().isLocal() && uri.toString().startsWith("file:")) {
                Path remoteFsPath = this.remoteFs.makeQualified(new Path(this.stagingDir, resourceName));
                this.remoteFs.copyFromLocalFile(resourcePath, remoteFsPath);
                this.remoteFs.setReplication(remoteFsPath, (short)this.conf.getInt("mapreduce.client.submit.file.replication", 3));
                this.resources.put(resourceName, remoteFsPath);
                return remoteFsPath;
            }
            this.resources.put(resourceName, resourcePath);
            return resourcePath;
        }
    }

    public void addTezResource(String resourceName, Path remoteFsPath) throws IOException {
        if (!this.resources.containsKey(resourceName)) {
            this.resources.put(resourceName, remoteFsPath);
        }
    }

    public Map<String, LocalResource> addTezResources(Set<URI> resources) throws Exception {
        HashSet<String> resourceNames = new HashSet<String>();
        for (URI uri : resources) {
            this.addTezResource(uri);
            resourceNames.add(new Path(uri.getPath()).getName());
        }
        return this.getTezResources(resourceNames);
    }

    public Map<String, LocalResource> getTezResources(Set<String> resourceNames) throws Exception {
        HashMap<String, LocalResource> tezResources = new HashMap<String, LocalResource>();
        for (String resourceName : resourceNames) {
            Path resourcePath = this.resources.get(resourceName);
            FileStatus fstat = this.remoteFs.getFileStatus(resourcePath);
            LocalResource tezResource = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)fstat.getPath()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)fstat.getLen(), (long)fstat.getModificationTime());
            tezResources.put(resourceName, tezResource);
        }
        return tezResources;
    }
}

